/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.filters.ProcessingYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class IntegratorBiasCompensatorYoVariable
extends YoDouble
implements ProcessingYoVariable {
    private final double dt;
    private final DoubleProvider kp;
    private final DoubleProvider ki;
    private final DoubleProvider rawPosition;
    private final DoubleProvider rawRate;
    private final YoDouble error;
    private final YoDouble estimatedRate;
    private final YoDouble estimatedRateBias;
    private final YoBoolean hasBeenCalled;

    public static DoubleProvider createKpYoDouble(String namePrefix, double initialValue, YoRegistry registry) {
        YoDouble kp = new YoDouble(namePrefix + "FilterKp", registry);
        kp.set(initialValue);
        return kp;
    }

    public static DoubleProvider createKiYoDouble(String namePrefix, double initialValue, YoRegistry registry) {
        YoDouble ki = new YoDouble(namePrefix + "FilterKi", registry);
        ki.set(initialValue);
        return ki;
    }

    public IntegratorBiasCompensatorYoVariable(String name, YoRegistry registry, double kp, double ki, DoubleProvider rawPositionVariable, DoubleProvider rawRateVariable, double dt) {
        this(name, registry, IntegratorBiasCompensatorYoVariable.createKpYoDouble(name, kp, registry), IntegratorBiasCompensatorYoVariable.createKiYoDouble(name, ki, registry), rawPositionVariable, rawRateVariable, dt);
    }

    public IntegratorBiasCompensatorYoVariable(String name, YoRegistry registry, DoubleProvider kp, DoubleProvider ki, DoubleProvider rawPositionVariable, DoubleProvider rawRateVariable, double dt) {
        super(name, registry);
        this.kp = kp;
        this.ki = ki;
        this.dt = dt;
        this.rawPosition = rawPositionVariable;
        this.rawRate = rawRateVariable;
        this.error = new YoDouble(name + "PositionError", registry);
        this.estimatedRate = new YoDouble(name + "EstimatedRate", registry);
        this.estimatedRateBias = new YoDouble(name + "EstimatedRateBias", registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.reset();
    }

    public void reset() {
        this.hasBeenCalled.set(false);
    }

    public YoDouble getPositionEstimation() {
        return this;
    }

    public YoDouble getRateEstimation() {
        return this.estimatedRate;
    }

    public YoDouble getBiasEstimation() {
        return this.estimatedRateBias;
    }

    public void update() {
        this.update(this.rawPosition.getValue(), this.rawRate.getValue());
    }

    public void update(double rawPosition, double rawRate) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.set(rawPosition);
            this.estimatedRate.set(rawRate);
            this.error.set(0.0);
            this.estimatedRateBias.set(0.0);
            return;
        }
        double x_filt = this.getValue();
        double xd_filt_new = rawRate + this.estimatedRateBias.getValue();
        double xd_filt_old = this.estimatedRate.getValue();
        double x_pred = x_filt + 0.5 * (xd_filt_old + xd_filt_new) * this.dt;
        double error = rawPosition - x_pred;
        x_filt = x_pred + this.kp.getValue() * error;
        this.error.set(error);
        this.estimatedRateBias.add(this.ki.getValue() * error);
        this.estimatedRate.set(rawRate + this.estimatedRateBias.getValue());
        this.set(x_filt);
    }
}

