/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.filters.ButterworthFilteredYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ButterworthFusedYoVariable
extends YoDouble {
    private final ButterworthFilteredYoVariable lowPassFilteredSlowVariable;
    private final ButterworthFilteredYoVariable highPassFilteredFastVariable;

    public ButterworthFusedYoVariable(String name, YoRegistry registry, double alpha) {
        this(name, registry, alpha, null, null);
    }

    public ButterworthFusedYoVariable(String name, YoRegistry registry, double alpha, DoubleProvider slowSignal, DoubleProvider fastSignal) {
        this(name, registry, AlphaFilteredYoVariable.createAlphaYoDouble((String)name, (double)alpha, (YoRegistry)registry), slowSignal, fastSignal);
    }

    public ButterworthFusedYoVariable(String name, YoRegistry registry, DoubleProvider alphaVariable) {
        this(name, registry, alphaVariable, null, null);
    }

    public ButterworthFusedYoVariable(String name, YoRegistry registry, DoubleProvider alphaVariable, DoubleProvider slowSignal, DoubleProvider fastSignal) {
        super(name, registry);
        this.lowPassFilteredSlowVariable = new ButterworthFilteredYoVariable(name + "LowPass", registry, alphaVariable, slowSignal, ButterworthFilteredYoVariable.ButterworthFilterType.LOW_PASS);
        this.highPassFilteredFastVariable = new ButterworthFilteredYoVariable(name + "HighPass", registry, alphaVariable, fastSignal, ButterworthFilteredYoVariable.ButterworthFilterType.HIGH_PASS);
        this.reset();
    }

    public void reset() {
        this.lowPassFilteredSlowVariable.reset();
        this.highPassFilteredFastVariable.reset();
    }

    public void update() {
        this.lowPassFilteredSlowVariable.update();
        this.highPassFilteredFastVariable.update();
        this.set(this.lowPassFilteredSlowVariable.getDoubleValue() + this.highPassFilteredFastVariable.getDoubleValue());
    }

    public void update(double slowSignalVal, double fastSignalVal) {
        this.lowPassFilteredSlowVariable.update(slowSignalVal);
        this.highPassFilteredFastVariable.update(fastSignalVal);
        this.set(this.lowPassFilteredSlowVariable.getDoubleValue() + this.highPassFilteredFastVariable.getDoubleValue());
    }
}

