/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import org.apache.commons.lang3.NotImplementedException;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class AlphaFilteredTuple3D
implements Tuple3DBasics,
Settable<Tuple3DBasics> {
    private double alpha;
    private double x = Double.NaN;
    private double y = Double.NaN;
    private double z = Double.NaN;
    private boolean resetX = false;
    private boolean resetY = false;
    private boolean resetZ = false;

    public AlphaFilteredTuple3D() {
        this.alpha = 0.0;
    }

    public AlphaFilteredTuple3D(double alpha) {
        this.alpha = alpha;
    }

    public AlphaFilteredTuple3D(double x, double y, double z, double alpha) {
        this.alpha = alpha;
        this.beginReset();
        this.set(x, y, z);
    }

    public AlphaFilteredTuple3D(Tuple3DReadOnly other, double alpha) {
        this.alpha = alpha;
        this.beginReset();
        this.set(other);
    }

    public void beginReset() {
        this.resetX = true;
        this.resetY = true;
        this.resetZ = true;
    }

    public void endReset() {
        this.resetX = false;
        this.resetY = false;
        this.resetZ = false;
    }

    public void reset(Tuple3DReadOnly other) {
        this.beginReset();
        this.set(other);
    }

    public void setX(double x) {
        if (this.resetX || Double.isNaN(this.x)) {
            this.x = x;
            this.resetX = false;
        } else {
            this.x = EuclidCoreTools.interpolate((double)x, (double)this.x, (double)this.alpha);
        }
    }

    public void setY(double y) {
        if (this.resetY || Double.isNaN(this.y)) {
            this.y = y;
            this.resetY = false;
        } else {
            this.y = EuclidCoreTools.interpolate((double)y, (double)this.y, (double)this.alpha);
        }
    }

    public void setZ(double z) {
        if (this.resetZ || Double.isNaN(this.z)) {
            this.z = z;
            this.resetZ = false;
        } else {
            this.z = EuclidCoreTools.interpolate((double)z, (double)this.z, (double)this.alpha);
        }
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void applyTransform(Transform transform) {
        throw new NotImplementedException("Sorry mate, " + this.getClass().getSimpleName() + " doesn't implement this method.");
    }

    public void applyInverseTransform(Transform transform) {
        throw new NotImplementedException("Sorry mate, " + this.getClass().getSimpleName() + " doesn't implement this method.");
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        return this.epsilonEquals(geometry, epsilon);
    }

    public void set(Tuple3DBasics other) {
        this.beginReset();
        this.interpolate((Tuple3DReadOnly)other, (Tuple3DReadOnly)this, this.alpha);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

