/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.commons.MathTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoSolvePseudoInverseSVDWithDampedLeastSquaresNearSingularities
implements LinearSolverDense<DMatrixRMaj> {
    private final SingularValueDecomposition_F64<DMatrixRMaj> svd;
    private final DMatrixRMaj pseudoInverse = new DMatrixRMaj(1, 1);
    private final YoRegistry registry;
    private final YoDouble mu;
    private final YoDouble firstSingularValueThreshold;
    private final YoDouble secondSingularValueThreshold;
    private final YoDouble singularValueAlpha;
    private final YoDouble yoMinSingularValue;
    private final YoDouble[] yoSingularValues;
    private final YoDouble[] yoSingularValuesInverse;
    private final DMatrixRMaj tempV;
    private double alpha = 1.0;

    public YoSolvePseudoInverseSVDWithDampedLeastSquaresNearSingularities(String namePrefix, int maxRows, int maxCols, YoRegistry parentRegistry) {
        int i;
        this.svd = DecompositionFactory_DDRM.svd((int)maxRows, (int)maxCols, (boolean)true, (boolean)true, (boolean)true);
        this.tempV = new DMatrixRMaj(maxCols, maxCols);
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.mu = new YoDouble(namePrefix + "Mu", this.registry);
        this.firstSingularValueThreshold = new YoDouble(namePrefix + "FirstSingularValueThreshold", this.registry);
        this.secondSingularValueThreshold = new YoDouble(namePrefix + "SecondSingularValueThreshold", this.registry);
        this.singularValueAlpha = new YoDouble(namePrefix + "SingularValueAlpha", this.registry);
        this.yoMinSingularValue = new YoDouble(namePrefix + "MinSingularValue", this.registry);
        this.mu.set(0.003);
        this.firstSingularValueThreshold.set(0.005);
        this.secondSingularValueThreshold.set(1.0E-5);
        this.yoSingularValues = new YoDouble[Math.max(maxRows, maxCols)];
        this.yoSingularValuesInverse = new YoDouble[Math.max(maxRows, maxCols)];
        for (i = 0; i < this.yoSingularValues.length; ++i) {
            this.yoSingularValues[i] = new YoDouble(namePrefix + "SingularValue_" + i, this.registry);
            this.yoSingularValues[i].set(Double.NaN);
        }
        for (i = 0; i < this.yoSingularValuesInverse.length; ++i) {
            this.yoSingularValuesInverse[i] = new YoDouble(namePrefix + "SingularValueInverse_" + i, this.registry);
            this.yoSingularValuesInverse[i].set(Double.NaN);
        }
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
    }

    public void setThresholds(double firstThreshold, double secondThreshold) {
        this.firstSingularValueThreshold.set(firstThreshold);
        this.secondSingularValueThreshold.set(secondThreshold);
    }

    public void setDampedLeastSquaresMu(double mu) {
        this.mu.set(mu);
    }

    public boolean setA(DMatrixRMaj A) {
        int i;
        this.pseudoInverse.reshape(A.numCols, A.numRows, false);
        this.tempV.reshape(A.numCols, A.numRows, false);
        if (!this.svd.decompose((Matrix)A)) {
            return false;
        }
        DMatrixRMaj U_t = (DMatrixRMaj)this.svd.getU(null, true);
        DMatrixRMaj V = (DMatrixRMaj)this.svd.getV((Matrix)this.tempV, false);
        double[] S = this.svd.getSingularValues();
        int N = Math.min(A.numRows, A.numCols);
        double minSingular = Double.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < N; ++i2) {
            this.yoSingularValues[i2].set(S[i2]);
            if (!(S[i2] < minSingular)) continue;
            minSingular = S[i2];
        }
        this.yoMinSingularValue.set(minSingular);
        double deltaThresholds = this.firstSingularValueThreshold.getDoubleValue() - this.secondSingularValueThreshold.getDoubleValue();
        double muSquare = this.mu.getDoubleValue() * this.mu.getDoubleValue();
        this.alpha = 1.0;
        if (minSingular < this.secondSingularValueThreshold.getDoubleValue()) {
            this.alpha = 0.0;
        } else if (minSingular < this.firstSingularValueThreshold.getDoubleValue()) {
            this.alpha = (minSingular - this.secondSingularValueThreshold.getDoubleValue()) / deltaThresholds;
        }
        this.alpha = MathTools.clamp((double)this.alpha, (double)0.0, (double)1.0);
        this.alpha *= this.alpha;
        this.singularValueAlpha.set(this.alpha);
        for (i = 0; i < N; ++i) {
            double s = S[i];
            S[i] = minSingular <= this.secondSingularValueThreshold.getDoubleValue() ? s / (s * s + muSquare) : this.alpha / s + (1.0 - this.alpha) * s / (s * s + muSquare);
            this.yoSingularValuesInverse[i].set(S[i]);
        }
        for (i = 0; i < V.numRows; ++i) {
            int index = i * V.numCols;
            for (int j = 0; j < V.numCols; ++j) {
                int n = index++;
                V.data[n] = V.data[n] * S[j];
            }
        }
        CommonOps_DDRM.mult((DMatrix1Row)V, (DMatrix1Row)U_t, (DMatrix1Row)this.pseudoInverse);
        return true;
    }

    public double quality() {
        return this.alpha;
    }

    public void solve(DMatrixRMaj b, DMatrixRMaj x) {
        CommonOps_DDRM.mult((DMatrix1Row)this.pseudoInverse, (DMatrix1Row)b, (DMatrix1Row)x);
    }

    public void invert(DMatrixRMaj A_inv) {
        A_inv.set((DMatrixD1)this.pseudoInverse);
    }

    public boolean modifiesA() {
        return this.svd.inputModified();
    }

    public boolean modifiesB() {
        return false;
    }

    public SingularValueDecomposition_F64<DMatrixRMaj> getDecomposition() {
        return this.svd;
    }
}

