/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class DitherProducer {
    private final YoRegistry registry;
    private final YoDouble desiredDitherFrequency;
    private final YoDouble ditherFrequency;
    private final YoDouble amplitude;
    private final double maxFrequency;
    private final YoDouble dither;

    public DitherProducer(String namePrefix, YoRegistry parentRegistry, double controlDT) {
        this.registry = new YoRegistry(namePrefix);
        this.desiredDitherFrequency = new YoDouble(namePrefix + "_dither_frequency_desired", this.registry);
        this.desiredDitherFrequency.set(0.0);
        this.desiredDitherFrequency.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                DitherProducer.this.checkFrequency();
            }
        });
        this.ditherFrequency = new YoDouble(namePrefix + "_dither_frequency", this.registry);
        this.ditherFrequency.set(0.0);
        this.amplitude = new YoDouble(namePrefix + "_dither_amplitude", this.registry);
        this.amplitude.set(0.0);
        this.dither = new YoDouble(namePrefix + "_dither_output", this.registry);
        this.dither.set(0.0);
        this.maxFrequency = 1.0 / (2.0 * controlDT);
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
    }

    protected void checkFrequency() {
        double lowerMatch;
        if (this.desiredDitherFrequency.getDoubleValue() >= this.maxFrequency) {
            this.ditherFrequency.set(this.maxFrequency);
            return;
        }
        if (this.desiredDitherFrequency.getDoubleValue() <= 0.0) {
            this.ditherFrequency.set(0.0);
            return;
        }
        for (lowerMatch = this.maxFrequency; lowerMatch > this.desiredDitherFrequency.getDoubleValue(); lowerMatch /= 2.0) {
        }
        double upperMatch = lowerMatch * 2.0;
        if (this.desiredDitherFrequency.getDoubleValue() - lowerMatch < upperMatch - this.desiredDitherFrequency.getDoubleValue()) {
            this.ditherFrequency.set(lowerMatch);
        } else {
            this.ditherFrequency.set(upperMatch);
        }
    }

    public void setFrequency(double desiredFrequency) {
        this.desiredDitherFrequency.set(desiredFrequency);
    }

    public double getFrequency() {
        return this.ditherFrequency.getDoubleValue();
    }

    public void setAmplitude(double desiredAmplitude) {
        this.amplitude.set(desiredAmplitude);
    }

    public double getAmplitude() {
        return this.amplitude.getDoubleValue();
    }

    public double getValue(double time) {
        double controlDT = 1.0 / (2.0 * this.maxFrequency);
        long tick = (long)(time / controlDT);
        int ticks = (int)(1.0 / (this.ditherFrequency.getDoubleValue() * controlDT));
        if (2L * (tick %= (long)ticks) >= (long)ticks) {
            this.dither.set(this.amplitude.getDoubleValue());
        } else {
            this.dither.set(-this.amplitude.getDoubleValue());
        }
        return this.dither.getDoubleValue();
    }
}

