/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.lists;

import java.util.List;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;

public class FrameTupleArrayList<T extends FrameTuple3DBasics>
extends RecyclingArrayList<T> {
    private FrameTupleArrayList(Class<T> clazz) {
        super(clazz);
    }

    private FrameTupleArrayList(int initialSize, Class<T> clazz) {
        super(initialSize, clazz);
    }

    public void setOrCreate(int i, FrameTuple3DReadOnly frameTuple) {
        ((FrameTuple3DBasics)this.getAndGrowIfNeeded(i)).setIncludingFrame(frameTuple);
    }

    public void set(int i, FrameTuple3DReadOnly frameTuple) {
        ((FrameTuple3DBasics)this.get(i)).setIncludingFrame(frameTuple);
    }

    private void unsafeSet(int i, FrameTuple3DReadOnly frameTuple) {
        ((FrameTuple3DBasics)this.unsafeGet(i)).setIncludingFrame(frameTuple);
    }

    public void set(FrameTupleArrayList<?> otherList) {
        for (int i = 0; i < otherList.size(); ++i) {
            ((FrameTuple3DBasics)this.getAndGrowIfNeeded(i)).setIncludingFrame((FrameTuple3DReadOnly)otherList.get(i));
        }
        while (this.size() > otherList.size()) {
            this.remove(this.size() - 1);
        }
    }

    public void copyFromListAndTrimSize(List<? extends FrameTuple3DReadOnly> otherList) {
        for (int i = 0; i < otherList.size(); ++i) {
            ((FrameTuple3DBasics)this.getAndGrowIfNeeded(i)).setIncludingFrame(otherList.get(i));
        }
        while (this.size() > otherList.size()) {
            this.remove(this.size() - 1);
        }
    }

    public static FrameTupleArrayList<FramePoint3D> createFramePointArrayList() {
        return new FrameTupleArrayList<FramePoint3D>(FramePoint3D.class);
    }

    public static FrameTupleArrayList<FrameVector3D> createFrameVectorArrayList() {
        return new FrameTupleArrayList<FrameVector3D>(FrameVector3D.class);
    }

    public static FrameTupleArrayList<FramePoint3D> createFramePointArrayList(int initialSize) {
        return new FrameTupleArrayList<FramePoint3D>(initialSize, FramePoint3D.class);
    }

    public static FrameTupleArrayList<FrameVector3D> createFrameVectorArrayList(int initialSize) {
        return new FrameTupleArrayList<FrameVector3D>(initialSize, FrameVector3D.class);
    }
}

