/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.lidar;

import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.kinematics.TransformInterpolationCalculator;
import us.ihmc.robotics.lidar.LidarScanParameters;

public class LidarScan {
    public LidarScanParameters params;
    public RigidBodyTransform worldTransformStart;
    public RigidBodyTransform worldTransformEnd;
    public RigidBodyTransform localTransformStart;
    public RigidBodyTransform localTransformEnd;
    public RigidBodyTransform averageTransform;
    @FieldSerializer.Optional(value="TranformationInterpolationCalculator")
    private final TransformInterpolationCalculator transformInterpolationCalculator = new TransformInterpolationCalculator();
    public float[] ranges;
    public int sensorId;

    public LidarScan() {
    }

    public LidarScan(LidarScanParameters params, float[] ranges, int sensorId) {
        this.params = params;
        this.ranges = ranges;
        this.sensorId = sensorId;
    }

    public LidarScan(LidarScanParameters params, RigidBodyTransform start, RigidBodyTransform end, float[] ranges, int sensorId) {
        this.params = params;
        this.setWorldTransforms(start, end);
        this.ranges = ranges;
        this.sensorId = sensorId;
    }

    public LidarScan(LidarScanParameters params, RigidBodyTransform start, RigidBodyTransform end, float[] ranges) {
        this.params = params;
        this.setWorldTransforms(start, end);
        this.ranges = ranges;
        this.sensorId = 0;
    }

    public ArrayList<Point3D> getAllPoints() {
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        for (int i = 0; i < this.ranges.length; ++i) {
            points.add(this.getPoint(i, this.ranges[i]));
        }
        return points;
    }

    public ArrayList<Point3D32> getAllPoints3f() {
        ArrayList<Point3D32> points = new ArrayList<Point3D32>();
        for (int i = 0; i < this.ranges.length; ++i) {
            points.add(this.getPoint3f(i, this.ranges[i]));
        }
        return points;
    }

    public Point3D[] toPointArray() {
        Point3D[] points = new Point3D[this.ranges.length];
        for (int i = 0; i < this.ranges.length; ++i) {
            points[i] = this.getPoint(i);
        }
        return points;
    }

    public int size() {
        return this.ranges.length;
    }

    public Point3D getPoint(int index) {
        return this.getPoint(index, this.ranges[index]);
    }

    public Point3D32 getPoint3f(int index) {
        return this.getPoint3f(index, this.ranges[index]);
    }

    public LineSegment3D getLineSegment(int index) {
        return this.getLineSegment(index, this.ranges[index]);
    }

    public float getRange(int i) {
        return this.ranges[i];
    }

    public float[] getRanges() {
        return this.ranges;
    }

    public LidarScan getCopy() {
        return new LidarScan(this.getParams(), (float[])this.ranges.clone(), this.sensorId);
    }

    public int getSensorId() {
        return this.sensorId;
    }

    public LidarScan flipNew() {
        float[] flippedRanges = Arrays.copyOf(this.ranges, this.ranges.length);
        ArrayUtils.reverse((float[])flippedRanges);
        return new LidarScan(this.getParams(), this.getEndTransform(), this.getStartTransform(), flippedRanges, this.sensorId);
    }

    public LidarScanParameters getParams() {
        return this.params;
    }

    public void setWorldTransforms(RigidBodyTransform start, RigidBodyTransform end) {
        this.worldTransformStart = start;
        this.worldTransformEnd = end;
        this.averageTransform = new RigidBodyTransform();
        this.transformInterpolationCalculator.computeInterpolation(this.worldTransformStart, this.worldTransformEnd, this.averageTransform, 0.5);
    }

    public LidarScanParameters getScanParameters() {
        return this.params;
    }

    public RigidBodyTransform getStartTransform() {
        return this.worldTransformStart;
    }

    public RigidBodyTransform getEndTransform() {
        return this.worldTransformEnd;
    }

    public RigidBodyTransform getAverageTransform() {
        return this.averageTransform;
    }

    protected Point3D getPoint(int index, float range) {
        Point3D p = new Point3D((double)range, 0.0, 0.0);
        RigidBodyTransform transform = new RigidBodyTransform();
        this.getInterpolatedTransform(index, transform);
        transform.multiply((RigidBodyTransformReadOnly)this.getSweepTransform(index));
        transform.transform((Point3DBasics)p);
        return p;
    }

    protected Point3D32 getPoint3f(int index, float range) {
        Point3D32 p = new Point3D32(range, 0.0f, 0.0f);
        RigidBodyTransform transform = new RigidBodyTransform();
        this.getInterpolatedTransform(index, transform);
        transform.multiply((RigidBodyTransformReadOnly)this.getSweepTransform(index));
        transform.transform((Point3DBasics)p);
        return p;
    }

    protected LineSegment3D getLineSegment(int index, float range) {
        Vector3D origin = new Vector3D();
        RigidBodyTransform transform = new RigidBodyTransform();
        this.getInterpolatedTransform(index, transform);
        origin.set((Tuple3DReadOnly)transform.getTranslation());
        return new LineSegment3D((Point3DReadOnly)new Point3D((Tuple3DReadOnly)origin), (Point3DReadOnly)this.getPoint(index, range));
    }

    public void getInterpolatedTransform(int index, RigidBodyTransform target) {
        this.transformInterpolationCalculator.computeInterpolation(this.worldTransformStart, this.worldTransformEnd, target, (double)index / (double)(this.params.pointsPerSweep - 1));
    }

    public RigidBodyTransform getSweepTransform(int i) {
        if (i >= this.params.pointsPerSweep * this.params.scanHeight) {
            throw new IndexOutOfBoundsException("Index " + i + " greater than or equal to pointsPerSweep " + this.params.pointsPerSweep + " * scanHeight " + this.params.scanHeight);
        }
        double yawPerIndex = (this.params.sweepYawMax - this.params.sweepYawMin) / (float)(this.params.pointsPerSweep - 1);
        double pitchPerIndex = (this.params.heightPitchMax - this.params.heightPitchMin) / (float)(this.params.scanHeight - 1);
        RigidBodyTransform sweepTransform = new RigidBodyTransform();
        if (this.params.pointsPerSweep > 1) {
            sweepTransform.setRotationYawAndZeroTranslation((double)this.params.sweepYawMin + yawPerIndex * (double)(i % this.params.pointsPerSweep));
        }
        if (this.params.scanHeight > 1) {
            sweepTransform.setRotationPitchAndZeroTranslation((double)this.params.heightPitchMin + pitchPerIndex * (double)(i / this.params.pointsPerSweep));
        }
        return sweepTransform;
    }

    public long getScanTimeStamp() {
        return this.params.getTimestamp();
    }

    public long getScanEndTime() {
        return this.params.getTimestamp() + this.params.getScanTimeNanos();
    }
}

