/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;

public class TimeStampedTransform3D {
    public RigidBodyTransform transform3D = new RigidBodyTransform();
    public long timeStamp;

    public TimeStampedTransform3D() {
    }

    public TimeStampedTransform3D(RigidBodyTransform transform3D, long timeStamp) {
        this.transform3D.set(transform3D);
        this.timeStamp = timeStamp;
    }

    public void setTransform3D(RigidBodyTransform transform3D) {
        this.transform3D.set(transform3D);
    }

    public void setTransform3D(Pose3D pose3D) {
        pose3D.get((RigidBodyTransformBasics)this.transform3D);
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public RigidBodyTransform getTransform3D() {
        return this.transform3D;
    }

    public void set(TimeStampedTransform3D other) {
        this.setTransform3D(other.getTransform3D());
        this.setTimeStamp(other.getTimeStamp());
    }

    public boolean epsilonEquals(TimeStampedTransform3D other, double epsilon) {
        boolean haveTheSameTransform = this.transform3D.epsilonEquals((EuclidGeometry)other.transform3D, epsilon);
        boolean haveTheSameTimestamp = this.timeStamp == other.timeStamp;
        return haveTheSameTransform && haveTheSameTimestamp;
    }

    public String toString() {
        String ret = "Timestamp: " + this.timeStamp + "\n";
        ret = ret + "Transform: \n" + String.valueOf(this.transform3D);
        return ret;
    }
}

