/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import java.util.ArrayList;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.kinematics.InverseKinematicsCalculator;
import us.ihmc.robotics.kinematics.InverseKinematicsStepListener;
import us.ihmc.robotics.screwTheory.GeometricJacobian;

public class KinematicSolver
implements InverseKinematicsCalculator {
    private static long seed = 129092439L;
    private static final Random randomNumberGenerator = new Random(seed);
    private static int nDoF = 0;
    private final ArrayList<Double> errorCourse = new ArrayList();
    private final LinearSolverDense<DMatrixRMaj> getPseudoInverse = LinearSolverFactory_DDRM.pseudoInverse((boolean)true);
    private final RigidBodyTransform transformShoulderToEndEffector = new RigidBodyTransform();
    private final RigidBodyTransform transformEndEffectorToShoulder = new RigidBodyTransform();
    private final RigidBodyTransform transformEndEffectorToDesired = new RigidBodyTransform();
    private final Vector3D errorTranslationVector = new Vector3D();
    private final Vector3D errorAngularVector = new Vector3D();
    private final AxisAngle errorAxisAngle = new AxisAngle();
    private final Quaternion errorQuat = new Quaternion();
    private final DMatrixRMaj spatialError;
    private final DMatrixRMaj jacobianTranspose;
    private final DMatrixRMaj jacobianJacobianTranspose;
    private final DMatrixRMaj correction;
    private final DMatrixRMaj jacobianMethod;
    private final DMatrixRMaj jJTe;
    private final DMatrixRMaj dampingSquaredDiagonal;
    private final DMatrixRMaj inverseTerm;
    private final GeometricJacobian jacobian;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final double dampingConstant;
    private final double tolerance;
    private final double maxIterations;
    private final double convergeRate;
    private final double[] bestJointAngles = new double[6];
    private int iterationNumber;
    private double currentBest;
    private double alpha;
    private boolean desiredReached;
    private JacobianMethod solveMethod;

    public KinematicSolver(GeometricJacobian jacobian, double tolerance, double maxIterations) {
        this.jacobian = jacobian;
        this.tolerance = tolerance;
        this.maxIterations = maxIterations;
        this.oneDoFJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])jacobian.getJointsInOrder(), OneDoFJointBasics.class);
        nDoF = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])this.oneDoFJoints);
        this.jacobianMethod = new DMatrixRMaj(nDoF, nDoF);
        this.jacobianTranspose = new DMatrixRMaj(nDoF, nDoF);
        this.jacobianJacobianTranspose = new DMatrixRMaj(nDoF, nDoF);
        this.jJTe = new DMatrixRMaj(nDoF, 1);
        this.correction = new DMatrixRMaj(nDoF, 1);
        this.spatialError = new DMatrixRMaj(6, 1);
        this.dampingSquaredDiagonal = new DMatrixRMaj(nDoF, nDoF);
        this.inverseTerm = new DMatrixRMaj(nDoF, nDoF);
        this.convergeRate = 1.0E-8;
        this.solveMethod = JacobianMethod.JACOBIAN_TRANSPOSE;
        this.dampingConstant = 0.3;
    }

    @Override
    public boolean solve(RigidBodyTransformReadOnly desiredTransform) {
        this.currentBest = Double.MAX_VALUE;
        this.iterationNumber = 0;
        this.errorCourse.clear();
        this.desiredReached = false;
        do {
            this.calculateErrorTransform(desiredTransform);
            this.minimizeError();
            this.updateJointAngles();
            this.monitorProgress();
            this.desiredReached = this.correctionNearZero();
        } while ((double)this.iterationNumber++ < this.maxIterations && !this.desiredReached);
        this.setBestJointAngles();
        return this.desiredReached;
    }

    private void calculateErrorTransform(RigidBodyTransformReadOnly transformShoulderToDesired) {
        this.jacobian.getEndEffector().getBodyFixedFrame().getTransformToDesiredFrame(this.transformShoulderToEndEffector, this.jacobian.getBaseFrame());
        this.transformEndEffectorToShoulder.setAndInvert((RigidBodyTransformReadOnly)this.transformShoulderToEndEffector);
        this.transformEndEffectorToDesired.set(this.transformEndEffectorToShoulder);
        this.transformEndEffectorToDesired.multiply(transformShoulderToDesired);
    }

    private void minimizeError() {
        this.jacobianMethod.set((DMatrixD1)this.getUpdatedJacobianMatrix());
        this.spatialError.set((DMatrixD1)this.getSpatialErrorEndEffectorDesired());
        this.jacobianOperation(this.solveMethod);
        CommonOps_DDRM.mult((DMatrix1Row)this.jacobianMethod, (DMatrix1Row)this.spatialError, (DMatrix1Row)this.correction);
    }

    private void monitorProgress() {
        double converge = 10.0;
        double spatialErrorNorm = NormOps_DDRM.normP2((DMatrixRMaj)this.spatialError);
        this.errorCourse.add(spatialErrorNorm);
        int lastIndex = this.errorCourse.size();
        int limit = 10;
        if (lastIndex >= limit) {
            converge = this.errorCourse.get(0) - this.errorCourse.get(limit - 1);
            this.errorCourse.remove(0);
        }
        if (converge < this.convergeRate) {
            this.introduceRandomPose();
        }
        this.checkAndSetIfPoseIsBest(spatialErrorNorm);
    }

    private void updateJointAngles() {
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            double newQ = this.oneDoFJoints[i].getQ() + this.correction.get(i, 0);
            newQ = MathTools.clamp((double)newQ, (double)this.oneDoFJoints[i].getJointLimitLower(), (double)this.oneDoFJoints[i].getJointLimitUpper());
            this.oneDoFJoints[i].setQ(newQ);
            this.oneDoFJoints[i].getFrameAfterJoint().update();
        }
    }

    private boolean correctionNearZero() {
        return NormOps_DDRM.normP2((DMatrixRMaj)this.spatialError) < this.tolerance;
    }

    private void setBestJointAngles() {
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            this.oneDoFJoints[i].setQ(this.bestJointAngles[i]);
        }
    }

    private DMatrixRMaj getUpdatedJacobianMatrix() {
        this.jacobian.compute();
        return this.jacobian.getJacobianMatrix();
    }

    private void jacobianOperation(JacobianMethod type) {
        CommonOps_DDRM.transpose((DMatrixRMaj)this.jacobianMethod, (DMatrixRMaj)this.jacobianTranspose);
        CommonOps_DDRM.mult((DMatrix1Row)this.jacobianMethod, (DMatrix1Row)this.jacobianTranspose, (DMatrix1Row)this.jacobianJacobianTranspose);
        switch (type) {
            case JACOBIAN_INVERSE: {
                CommonOps_DDRM.invert((DMatrixRMaj)this.jacobianMethod);
                break;
            }
            case JACOBIAN_TRANSPOSE: {
                CommonOps_DDRM.mult((DMatrix1Row)this.jacobianJacobianTranspose, (DMatrix1Row)this.spatialError, (DMatrix1Row)this.jJTe);
                this.alpha = this.getDotProduct(this.spatialError, this.jJTe) / this.getDotProduct(this.jJTe, this.jJTe);
                CommonOps_DDRM.transpose((DMatrixRMaj)this.jacobianMethod);
                CommonOps_DDRM.scale((double)this.alpha, (DMatrixD1)this.jacobianMethod);
                break;
            }
            case PSEUDO_INVERSE: {
                if (!this.getPseudoInverse.setA((Matrix)this.jacobianMethod)) {
                    throw new RuntimeException("PseudoInverse failed");
                }
                this.getPseudoInverse.invert((Matrix)this.jacobianMethod);
                break;
            }
            case DAMPED_LEAST_SQUARES: {
                CommonOps_DDRM.setIdentity((DMatrix1Row)this.dampingSquaredDiagonal);
                CommonOps_DDRM.scale((double)(this.dampingConstant * this.dampingConstant), (DMatrixD1)this.dampingSquaredDiagonal);
                CommonOps_DDRM.add((DMatrixD1)this.jacobianJacobianTranspose, (DMatrixD1)this.dampingSquaredDiagonal, (DMatrixD1)this.inverseTerm);
                CommonOps_DDRM.invert((DMatrixRMaj)this.inverseTerm);
                CommonOps_DDRM.mult((DMatrix1Row)this.jacobianTranspose, (DMatrix1Row)this.inverseTerm, (DMatrix1Row)this.jacobianMethod);
            }
        }
    }

    private double getDotProduct(DMatrixRMaj a, DMatrixRMaj b) {
        double ret = 0.0;
        for (int i = 0; i < a.numRows; ++i) {
            ret += a.get(i, 0) * b.get(i, 0);
        }
        return ret;
    }

    private DMatrixRMaj getSpatialErrorEndEffectorDesired() {
        this.errorTranslationVector.set((Tuple3DReadOnly)this.transformEndEffectorToDesired.getTranslation());
        this.errorQuat.set((Orientation3DReadOnly)this.transformEndEffectorToDesired.getRotation());
        this.errorAxisAngle.set((Orientation3DReadOnly)this.errorQuat);
        this.errorAngularVector.set(this.errorAxisAngle.getX(), this.errorAxisAngle.getY(), this.errorAxisAngle.getZ());
        this.errorAngularVector.scale(this.errorAxisAngle.getAngle());
        this.errorAngularVector.get(0, 0, (DMatrix)this.spatialError);
        this.errorTranslationVector.get(3, 0, (DMatrix)this.spatialError);
        return this.spatialError;
    }

    private void introduceRandomPose() {
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            double newQ = this.generateRandomDoubleInRange(this.oneDoFJoints[i].getJointLimitUpper(), this.oneDoFJoints[i].getJointLimitLower());
            this.oneDoFJoints[i].setQ(newQ);
        }
    }

    private void checkAndSetIfPoseIsBest(double spatialErrorNorm) {
        if (spatialErrorNorm < this.currentBest) {
            this.currentBest = spatialErrorNorm;
            for (int i = 0; i < this.bestJointAngles.length; ++i) {
                this.bestJointAngles[i] = this.oneDoFJoints[i].getQ();
            }
        }
    }

    private double generateRandomDoubleInRange(double max, double min) {
        return min + (max - min) * randomNumberGenerator.nextDouble();
    }

    @Override
    public double getErrorScalar() {
        return NormOps_DDRM.normF((DMatrixD1)this.spatialError);
    }

    @Override
    public int getNumberOfIterations() {
        return this.iterationNumber;
    }

    public JacobianMethod getSolveMethod() {
        return this.solveMethod;
    }

    public void setSolveMethod(JacobianMethod solveMethod) {
        this.solveMethod = solveMethod;
    }

    public double getDampingConstant() {
        return this.dampingConstant;
    }

    @Override
    public void attachInverseKinematicsStepListener(InverseKinematicsStepListener stepListener) {
    }

    @Override
    public void setLimitJointAngles(boolean limitJointAngles) {
    }

    public static enum JacobianMethod {
        JACOBIAN_INVERSE,
        JACOBIAN_TRANSPOSE,
        PSEUDO_INVERSE,
        DAMPED_LEAST_SQUARES;

    }
}

