/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.math.linearAlgebra.SymmetricQRAlgorithmDecomposition_D64GCFree;

public class AverageQuaternionCalculator {
    private final SymmetricQRAlgorithmDecomposition_D64GCFree eigenDecomposition;
    private final DMatrixRMaj quaternions = new DMatrixRMaj(0, 4);
    private final DMatrixRMaj outerProduct = new DMatrixRMaj(0, 0);
    private final Quaternion averageQuaternion = new Quaternion();
    private final Quaternion tempQuaternion = new Quaternion();
    private ReferenceFrame referenceFrame = null;

    public AverageQuaternionCalculator() {
        this.eigenDecomposition = new SymmetricQRAlgorithmDecomposition_D64GCFree(true);
    }

    public void reset() {
        this.quaternions.reshape(0, 4);
        this.outerProduct.reshape(0, 0);
        this.referenceFrame = null;
    }

    public void queueQuaternion(Quaternion quaternion) {
        this.quaternions.reshape(this.quaternions.getNumRows() + 1, 4, true);
        int lastIndex = this.quaternions.getNumRows() - 1;
        this.quaternions.set(lastIndex, 0, quaternion.getX());
        this.quaternions.set(lastIndex, 1, quaternion.getY());
        this.quaternions.set(lastIndex, 2, quaternion.getZ());
        this.quaternions.set(lastIndex, 3, quaternion.getS());
    }

    public void queueFrameOrientation(FrameQuaternion frameOrientation) {
        if (this.referenceFrame != null) {
            this.referenceFrame.checkReferenceFrameMatch((ReferenceFrameHolder)frameOrientation);
        }
        this.tempQuaternion.set((QuaternionReadOnly)frameOrientation);
        this.queueQuaternion(this.tempQuaternion);
    }

    public void queueAxisAngle(AxisAngle axisAngle) {
        this.tempQuaternion.set((Orientation3DReadOnly)axisAngle);
        this.queueQuaternion(this.tempQuaternion);
    }

    public void queueMatrix(RotationMatrix rotationMatrix) {
        this.tempQuaternion.set((Orientation3DReadOnly)rotationMatrix);
        this.queueQuaternion(this.tempQuaternion);
    }

    public void compute() {
        double weight = 1.0 / (double)this.quaternions.getNumRows();
        this.outerProduct.reshape(4, 4);
        CommonOps_DDRM.multAddTransA((double)weight, (DMatrix1Row)this.quaternions, (DMatrix1Row)this.quaternions, (DMatrix1Row)this.outerProduct);
        this.eigenDecomposition.decompose(this.outerProduct);
        double maxEigenValue = Double.NEGATIVE_INFINITY;
        DMatrixRMaj eigenVectorAssociatedWithMaxEigenValue = null;
        for (int i = 0; i < this.eigenDecomposition.getNumberOfEigenvalues(); ++i) {
            double eigenValue = this.eigenDecomposition.getEigenValueAsDouble(i);
            if (!(eigenValue > maxEigenValue)) continue;
            maxEigenValue = eigenValue;
            eigenVectorAssociatedWithMaxEigenValue = this.eigenDecomposition.getEigenVector(i);
        }
        double x = eigenVectorAssociatedWithMaxEigenValue.get(0, 0);
        double y = eigenVectorAssociatedWithMaxEigenValue.get(1, 0);
        double z = eigenVectorAssociatedWithMaxEigenValue.get(2, 0);
        double s = eigenVectorAssociatedWithMaxEigenValue.get(3, 0);
        this.averageQuaternion.set(x, y, z, s);
    }

    public void getAverageQuaternion(Quaternion averageQuaternionToPack) {
        averageQuaternionToPack.set(this.averageQuaternion);
    }

    public void getAverageFrameOrientation(FrameQuaternion averageFrameOrientationToPack) {
        if (this.referenceFrame != null) {
            this.referenceFrame.checkReferenceFrameMatch((ReferenceFrameHolder)averageFrameOrientationToPack);
        }
        averageFrameOrientationToPack.set((QuaternionReadOnly)this.averageQuaternion);
    }

    public void getAverageAxisAngle(AxisAngle averageAxisAngleToPack) {
        averageAxisAngleToPack.set((Orientation3DReadOnly)this.averageQuaternion);
    }

    public void getAverageMatrix(RotationMatrix averageRotationMatrixToPack) {
        averageRotationMatrixToPack.set((Orientation3DReadOnly)this.averageQuaternion);
    }
}

