/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.interaction;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;

public class PointCollidable {
    private final FrameShape3DReadOnly shape;
    private final FramePoint3D pickPoint = new FramePoint3D();
    private final FramePoint3D closestPointOnSurface = new FramePoint3D();
    private final FrameVector3D normalAtClosestPointOnSurface = new FrameVector3D();
    private double signedDistanceToSurface;

    public PointCollidable(FrameShape3DReadOnly shape) {
        this.shape = shape;
    }

    public boolean collide(FramePoint3DReadOnly callerPickPoint) {
        this.pickPoint.setIncludingFrame((FrameTuple3DReadOnly)callerPickPoint);
        this.pickPoint.changeFrame(this.shape.getReferenceFrame());
        this.closestPointOnSurface.changeFrame(this.pickPoint.getReferenceFrame());
        this.normalAtClosestPointOnSurface.changeFrame(this.pickPoint.getReferenceFrame());
        boolean isInsideOrOnSurface = this.shape.evaluatePoint3DCollision((FramePoint3DReadOnly)this.pickPoint, (FramePoint3DBasics)this.closestPointOnSurface, (FrameVector3DBasics)this.normalAtClosestPointOnSurface);
        double absoluteDistance = this.closestPointOnSurface.distance((FramePoint3DReadOnly)this.pickPoint);
        this.signedDistanceToSurface = isInsideOrOnSurface ? -absoluteDistance : absoluteDistance;
        this.closestPointOnSurface.changeFrame(ReferenceFrame.getWorldFrame());
        this.normalAtClosestPointOnSurface.changeFrame(ReferenceFrame.getWorldFrame());
        return isInsideOrOnSurface;
    }

    public FramePoint3DReadOnly getClosestPointOnSurface() {
        return this.closestPointOnSurface;
    }

    public double getSignedDistanceToSurface() {
        return this.signedDistanceToSurface;
    }
}

