/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolygon;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.geometry.GroundPlaneEstimator;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoGroundPlaneEstimator
extends GroundPlaneEstimator {
    private final YoFramePoint3D yoGroundPlanePoint;
    private final YoFrameVector3D yoGroundPlaneNormal;
    private final YoFrameYawPitchRoll yoGroundPlaneOrientation;
    private YoGraphicPolygon groundPlaneVisualizer;

    public YoGroundPlaneEstimator(YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        this("", parentRegistry, graphicsListRegistry, YoAppearance.Glass());
    }

    public YoGroundPlaneEstimator(String prefix, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry, AppearanceDefinition groundPlaneAppearance) {
        YoRegistry registry = new YoRegistry(prefix + this.getClass().getSimpleName());
        this.yoGroundPlanePoint = new YoFramePoint3D(prefix + "GroundPlanePointInWorld", ReferenceFrame.getWorldFrame(), registry);
        this.yoGroundPlaneNormal = new YoFrameVector3D(prefix + "GroundPlaneNormalInWorld", ReferenceFrame.getWorldFrame(), registry);
        this.yoGroundPlaneOrientation = new YoFrameYawPitchRoll(prefix + "GroundPlaneOrientationInWorld", ReferenceFrame.getWorldFrame(), registry);
        if (parentRegistry != null) {
            parentRegistry.addChild(registry);
        }
        if (graphicsListRegistry != null) {
            YoFrameConvexPolygon2D yoGroundPlaneEstimate = new YoFrameConvexPolygon2D("groundPlaneEstimate", "", ReferenceFrame.getWorldFrame(), 4, parentRegistry);
            yoGroundPlaneEstimate.addVertex(2.0, 2.0);
            yoGroundPlaneEstimate.addVertex(2.0, -2.0);
            yoGroundPlaneEstimate.addVertex(-2.0, -2.0);
            yoGroundPlaneEstimate.addVertex(-2.0, 2.0);
            this.groundPlaneVisualizer = new YoGraphicPolygon("groundPlaneEstimateVisualizer", yoGroundPlaneEstimate, this.yoGroundPlanePoint, this.yoGroundPlaneOrientation, 1.0, YoAppearance.Glass());
            graphicsListRegistry.registerYoGraphic(prefix + "GroundPlaneEstimate", (YoGraphic)this.groundPlaneVisualizer);
        }
        this.hideGraphics();
    }

    @Override
    public void compute() {
        this.compute(0.0);
    }

    @Override
    public void compute(double yaw) {
        super.compute(yaw);
        this.yoGroundPlaneNormal.set((Tuple3DReadOnly)this.getPlaneNormal());
        this.yoGroundPlanePoint.set((Tuple3DReadOnly)this.getPlanePoint());
        this.yoGroundPlaneOrientation.setYawPitchRoll(yaw, this.getPitch(yaw), this.getRoll(yaw));
        this.groundPlaneVisualizer.update();
    }

    @Override
    public void compute(List<? extends FramePoint3DReadOnly> contactPoints) {
        this.compute(contactPoints, 0.0);
    }

    @Override
    public void compute(List<? extends FramePoint3DReadOnly> contactPoints, double yaw) {
        super.compute(contactPoints, yaw);
        this.yoGroundPlaneNormal.set((Tuple3DReadOnly)this.getPlaneNormal());
        this.yoGroundPlanePoint.set((Tuple3DReadOnly)this.getPlanePoint());
        this.yoGroundPlaneOrientation.setYawPitchRoll(yaw, this.getPitch(yaw), this.getRoll(yaw));
        this.groundPlaneVisualizer.update();
    }

    @Override
    public void compute(QuadrantDependentList<? extends FramePoint3DReadOnly> contactPoints) {
        this.compute(contactPoints, 0.0);
    }

    @Override
    public void compute(QuadrantDependentList<? extends FramePoint3DReadOnly> contactPoints, double yaw) {
        super.compute(contactPoints, yaw);
        this.yoGroundPlaneNormal.set((Tuple3DReadOnly)this.getPlaneNormal());
        this.yoGroundPlanePoint.set((Tuple3DReadOnly)this.getPlanePoint());
        this.yoGroundPlaneOrientation.setYawPitchRoll(yaw, this.getPitch(yaw), this.getRoll(yaw));
        this.groundPlaneVisualizer.update();
    }

    public void hideGraphics() {
        this.yoGroundPlaneNormal.setToNaN();
        this.yoGroundPlanePoint.setToNaN();
    }
}

