/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class TransformTools {
    public static RigidBodyTransform createTransformFromPointAndZAxis(FramePoint3D point, FrameVector3D zAxis) {
        RigidBodyTransform ret = new RigidBodyTransform();
        ret.getRotation().set((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)zAxis));
        ret.getTranslation().set((Tuple3DReadOnly)point);
        return ret;
    }

    public static RigidBodyTransform yawPitchDegreesTransform(Vector3D center, double yawCCWDegrees, double pitchDownDegrees) {
        RigidBodyTransform location = new RigidBodyTransform();
        location.getRotation().setYawPitchRoll(Math.toRadians(yawCCWDegrees), Math.toRadians(pitchDownDegrees), 0.0);
        location.getTranslation().set((Tuple3DReadOnly)center);
        return location;
    }

    public static RigidBodyTransform createTransformFromTranslationAndEulerAngles(double x, double y, double z, double roll, double pitch, double yaw) {
        return TransformTools.createTransformFromTranslationAndEulerAngles(new Vector3D(x, y, z), new Vector3D(roll, pitch, yaw));
    }

    public static RigidBodyTransform createTransformFromTranslationAndEulerAngles(Vector3D translation, Vector3D eulerAngles) {
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.getRotation().setEuler((Vector3DReadOnly)eulerAngles);
        transform.getTranslation().set((Tuple3DReadOnly)translation);
        return transform;
    }

    public static void appendRotation(RigidBodyTransform transformToModify, double angle, Axis3D axis) {
        switch (axis) {
            case X: {
                transformToModify.appendRollRotation(angle);
                break;
            }
            case Y: {
                transformToModify.appendPitchRotation(angle);
                break;
            }
            case Z: {
                transformToModify.appendYawRotation(angle);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled value of Axis: " + String.valueOf(axis));
            }
        }
    }

    public static void appendRotation(AffineTransform transformToModify, double angle, Axis3D axis) {
        switch (axis) {
            case X: {
                transformToModify.appendRollRotation(angle);
                break;
            }
            case Y: {
                transformToModify.appendPitchRotation(angle);
                break;
            }
            case Z: {
                transformToModify.appendYawRotation(angle);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled value of Axis: " + String.valueOf(axis));
            }
        }
    }

    public static RigidBodyTransform getTransformFromA2toA1(RigidBodyTransform transformFromBtoA1, RigidBodyTransform transformFromBtoA2) {
        RigidBodyTransform ret = new RigidBodyTransform((RigidBodyTransformReadOnly)transformFromBtoA1);
        ret.multiplyInvertOther((RigidBodyTransformReadOnly)transformFromBtoA2);
        return ret;
    }

    public static double getMagnitudeOfAngleOfRotation(RigidBodyTransform rigidBodyTransform) {
        AxisAngle axisAngle = new AxisAngle();
        axisAngle.set((Orientation3DReadOnly)rigidBodyTransform.getRotation());
        return Math.abs(axisAngle.getAngle());
    }

    public static double getMagnitudeOfTranslation(RigidBodyTransform rigidBodyTransform) {
        return rigidBodyTransform.getTranslation().length();
    }

    public static double getSizeOfTransformWithRotationScaled(RigidBodyTransform rigidBodyTransform, double radiusForScalingRotation) {
        return TransformTools.getMagnitudeOfTranslation(rigidBodyTransform) + radiusForScalingRotation * TransformTools.getMagnitudeOfAngleOfRotation(rigidBodyTransform);
    }

    public static double getSizeOfTransformBetweenTwoWithRotationScaled(RigidBodyTransform rigidBodyTransform1, RigidBodyTransform rigidBodyTransform2, double radiusForScalingRotation) {
        RigidBodyTransform temp = TransformTools.getTransformFromA2toA1(rigidBodyTransform1, rigidBodyTransform2);
        return TransformTools.getMagnitudeOfTranslation(temp) + radiusForScalingRotation * TransformTools.getMagnitudeOfAngleOfRotation(temp);
    }
}

