/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.decomposition.svd.SvdImplicitQrDecompose_DDRM;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;
import us.ihmc.robotics.geometry.AngleTools;

public class RotationTools {
    public static final int QUATERNION_SIZE = 4;
    public static final double MATRIX_TO_QUATERNION_THRESHOLD = 1.0E-10;
    private static final ThreadLocal<RotationMatrix> rotationMatrixForYawPitchRollConvertor = new ThreadLocal<RotationMatrix>(){

        @Override
        public RotationMatrix initialValue() {
            return new RotationMatrix();
        }
    };
    private static final ThreadLocal<Quaternion> quaternionForEpsilonEquals = new ThreadLocal<Quaternion>(){

        @Override
        public Quaternion initialValue() {
            return new Quaternion();
        }
    };
    private static final ThreadLocal<AxisAngle> originalAxisAngleForEpsilonEquals = new ThreadLocal<AxisAngle>(){

        @Override
        public AxisAngle initialValue() {
            return new AxisAngle();
        }
    };
    private static final ThreadLocal<AxisAngle> resultAxisAngleForEpsilonEquals = new ThreadLocal<AxisAngle>(){

        @Override
        public AxisAngle initialValue() {
            return new AxisAngle();
        }
    };
    private static ThreadLocal<RotationMatrix> rotationMatrixForQuaternionFromYawAndZNormal = new ThreadLocal<RotationMatrix>(){

        @Override
        protected RotationMatrix initialValue() {
            return new RotationMatrix();
        }
    };
    private static final ThreadLocal<Vector3D> angularVelocityForIntegrator = new ThreadLocal<Vector3D>(){

        @Override
        public Vector3D initialValue() {
            return new Vector3D();
        }
    };
    private static final ThreadLocal<AxisAngle> axisAngleForIntegrator = new ThreadLocal<AxisAngle>(){

        @Override
        public AxisAngle initialValue() {
            return new AxisAngle();
        }
    };

    public static void computeQuaternionFromYawAndZNormal(double yaw, Vector3DReadOnly zNormal, QuaternionBasics quaternionToPack) {
        double Cx = 1.0;
        double Cy = Math.tan(yaw);
        if (Math.abs(zNormal.getZ()) < 1.0E-9) {
            quaternionToPack.setToNaN();
            return;
        }
        double Cz = -1.0 * (zNormal.getX() + Cy * zNormal.getY()) / zNormal.getZ();
        double CT = Math.sqrt(Cx * Cx + Cy * Cy + Cz * Cz);
        if (CT < 1.0E-9) {
            throw new RuntimeException("Error calculating Quaternion");
        }
        Vector3D xAxis = new Vector3D(Cx / CT, Cy / CT, Cz / CT);
        if (xAxis.getX() * Math.cos(yaw) + xAxis.getY() * Math.sin(yaw) < 0.0) {
            xAxis.negate();
        }
        Vector3D yAxis = new Vector3D();
        Vector3DReadOnly zAxis = zNormal;
        yAxis.cross((Tuple3DReadOnly)zAxis, (Tuple3DReadOnly)xAxis);
        RotationMatrix rotationMatrix = rotationMatrixForQuaternionFromYawAndZNormal.get();
        rotationMatrix.setColumns((Tuple3DReadOnly)xAxis, (Tuple3DReadOnly)yAxis, (Tuple3DReadOnly)zAxis);
        quaternionToPack.set((Orientation3DReadOnly)rotationMatrix);
    }

    static double closest(double org, double ref) {
        double my_angle;
        double my_diff;
        double result = org;
        double min_diff = Math.abs(result - ref);
        int i = 1;
        while ((my_diff = Math.abs((my_angle = org + (double)i * Math.PI) - ref)) < min_diff) {
            result = my_angle;
            min_diff = my_diff;
            ++i;
        }
        i = -1;
        while ((my_diff = Math.abs((my_angle = org + (double)i * Math.PI) - ref)) < min_diff) {
            result = my_angle;
            min_diff = my_diff;
            --i;
        }
        return result;
    }

    public static void convertMatrixToClosestYawPitchRoll(RotationMatrix rotationMatrix, double[] yawPitchRollRef, double[] yawPitchRollToPack) {
        double yawRef = yawPitchRollRef[0];
        double pitchRef = yawPitchRollRef[1];
        double rollRef = yawPitchRollRef[2];
        double m20 = rotationMatrix.getM20();
        m20 = Math.min(m20, 1.0);
        double pitch1 = Math.asin(-(m20 = Math.max(m20, -1.0)));
        if (Double.isNaN(pitch1)) {
            throw new RuntimeException("Pitch is NaN! rotationMatrix = " + String.valueOf(rotationMatrix));
        }
        double pitch2 = Math.PI - pitch1;
        double sinp = -m20;
        double cosp1 = Math.cos(pitch1);
        double cosp2 = Math.cos(pitch2);
        double pitch = 0.0;
        double yaw = 0.0;
        double roll = 0.0;
        if (Math.abs(cosp1) > 0.1) {
            double roll2;
            double yaw2;
            double diff2;
            double roll1;
            double yaw1 = Math.atan2(rotationMatrix.getM10() / cosp1, rotationMatrix.getM00() / cosp1);
            double diff1 = (yaw1 - yawRef) * (yaw1 - yawRef) + (pitch1 - pitchRef) * (pitch1 - pitchRef) + ((roll1 = Math.atan2(rotationMatrix.getM21() / cosp1, rotationMatrix.getM22() / cosp1)) - rollRef) * (roll1 - rollRef);
            if (diff1 < (diff2 = ((yaw2 = Math.atan2(rotationMatrix.getM10() / cosp2, rotationMatrix.getM00() / cosp2)) - yawRef) * (yaw2 - yawRef) + (pitch2 - pitchRef) * (pitch2 - pitchRef) + ((roll2 = Math.atan2(rotationMatrix.getM21() / cosp2, rotationMatrix.getM22() / cosp2)) - rollRef) * (roll2 - rollRef))) {
                yaw = yaw1;
                pitch = pitch1;
                roll = roll1;
            } else {
                yaw = yaw2;
                pitch = pitch2;
                roll = roll2;
            }
        } else {
            double cosc;
            double sinc;
            double cosa;
            double sina;
            double a01;
            double c01;
            double m01 = rotationMatrix.getM01();
            double m02 = rotationMatrix.getM02();
            double m11 = rotationMatrix.getM11();
            double m12 = rotationMatrix.getM12();
            double c00 = m01 * m01 + m02 * m02 - sinp * sinp;
            double c10 = c01 = m11 * m01 + m12 * m02;
            double c11 = m11 * m11 + m12 * m12 - sinp * sinp;
            double a00 = m12 * m12 + m02 * m02 - sinp * sinp;
            double a10 = a01 = m01 * m02 + m11 * m12;
            double a11 = m01 * m01 * m11 * m11 - sinp * sinp;
            int index = 0;
            double max_value = Math.abs(c01);
            if (Math.abs(c11) > max_value) {
                max_value = Math.abs(c11);
                index = 1;
            }
            if (Math.abs(a01) > max_value) {
                max_value = Math.abs(a01);
                index = 2;
            }
            if (Math.abs(a11) > max_value) {
                max_value = Math.abs(a11);
                index = 3;
            }
            double pitch0 = 0.0;
            double yaw0 = 0.0;
            double roll0 = 0.0;
            if (index == 0 || index == 1) {
                if (index == 0) {
                    yaw0 = RotationTools.closest(Math.atan2(c00, -c01), yawRef);
                } else if (index == 1) {
                    yaw0 = RotationTools.closest(Math.atan2(c10, -c11), yawRef);
                }
                double sinc2 = Math.sin(yaw0);
                double cosc2 = Math.cos(yaw0);
                double sina2 = (cosc2 * m01 + sinc2 * m11) / sinp;
                double cosa2 = (cosc2 * m02 + sinc2 * m12) / sinp;
                roll0 = RotationTools.closest(Math.atan2(sina2, cosa2), rollRef);
            } else {
                if (index == 2) {
                    roll0 = RotationTools.closest(Math.atan2(a00, -a01), rollRef);
                } else if (index == 3) {
                    roll0 = RotationTools.closest(Math.atan2(a10, -a11), rollRef);
                }
                sina = Math.sin(roll0);
                cosa = Math.cos(roll0);
                sinc = (sina * m11 + cosa * m12) / sinp;
                cosc = (sina * m01 + cosa * m02) / sinp;
                yaw0 = RotationTools.closest(Math.atan2(sinc, cosc), yawRef);
            }
            sina = Math.sin(roll0);
            cosa = Math.cos(roll0);
            sinc = Math.sin(yaw0);
            cosc = Math.cos(yaw0);
            int index0 = 0;
            double max_val = Math.abs(sina);
            if (Math.abs(cosa) > max_val) {
                index0 = 1;
                max_val = Math.abs(cosa);
            }
            if (Math.abs(sinc) > max_val) {
                index0 = 2;
                max_val = Math.abs(sinc);
            }
            if (Math.abs(cosc) > max_val) {
                index0 = 3;
                max_val = Math.abs(cosc);
            }
            double cosp = 0.0;
            cosp = index0 == 0 ? rotationMatrix.getM21() / sina : (index0 == 1 ? rotationMatrix.getM22() / cosa : (index0 == 3 ? rotationMatrix.getM00() / cosc : rotationMatrix.getM10() / sinc));
            pitch0 = Math.atan2(-rotationMatrix.getM20(), cosp);
            yaw = yaw0;
            roll = roll0;
            pitch = pitch0;
        }
        if (Double.isNaN(yaw)) {
            throw new RuntimeException("Yaw is NaN! rotationMatrix = " + String.valueOf(rotationMatrix));
        }
        if (Double.isNaN(roll)) {
            throw new RuntimeException("Roll is NaN! rotationMatrix = " + String.valueOf(rotationMatrix));
        }
        yawPitchRollToPack[0] = yaw;
        yawPitchRollToPack[1] = pitch;
        yawPitchRollToPack[2] = roll;
    }

    public static void convertTransformToClosestYawPitchRoll(RigidBodyTransform transform, double[] yawPitchRollRef, double[] yawPitchRollToPack) {
        RotationMatrix rotationMatrix = rotationMatrixForYawPitchRollConvertor.get();
        rotationMatrix.set((RotationMatrixReadOnly)transform.getRotation());
        RotationTools.convertMatrixToClosestYawPitchRoll(rotationMatrix, yawPitchRollRef, yawPitchRollToPack);
    }

    public static void removePitchAndRollFromTransform(RigidBodyTransform transform) {
        if (Math.abs(transform.getM22() - 1.0) < 1.0E-4) {
            return;
        }
        double m00 = transform.getM00();
        double m10 = transform.getM10();
        double magnitude = Math.sqrt(m00 * m00 + m10 * m10);
        transform.getRotation().set(m00 /= magnitude, -(m10 /= magnitude), 0.0, m10, m00, 0.0, 0.0, 0.0, 1.0);
    }

    public static void integrateAngularVelocity(FrameVector3D angularVelocityToIntegrate, double integrationTime, FrameQuaternion orientationResultToPack) {
        AxisAngle axisAngleResult = axisAngleForIntegrator.get();
        RotationTools.integrateAngularVelocity((Vector3DReadOnly)angularVelocityToIntegrate, integrationTime, (AxisAngleBasics)axisAngleResult);
        orientationResultToPack.setIncludingFrame(angularVelocityToIntegrate.getReferenceFrame(), (Orientation3DReadOnly)axisAngleResult);
    }

    public static void integrateAngularVelocity(Vector3DReadOnly angularVelocityToIntegrate, double integrationTime, RotationMatrix orientationResultToPack) {
        AxisAngle axisAngleResult = axisAngleForIntegrator.get();
        RotationTools.integrateAngularVelocity(angularVelocityToIntegrate, integrationTime, (AxisAngleBasics)axisAngleResult);
        orientationResultToPack.set((Orientation3DReadOnly)axisAngleResult);
    }

    public static void integrateAngularVelocity(Vector3DReadOnly angularVelocityToIntegrate, double integrationTime, QuaternionBasics orientationResultToPack) {
        AxisAngle axisAngleResult = axisAngleForIntegrator.get();
        RotationTools.integrateAngularVelocity(angularVelocityToIntegrate, integrationTime, (AxisAngleBasics)axisAngleResult);
        orientationResultToPack.set((Orientation3DReadOnly)axisAngleResult);
    }

    public static void integrateAngularVelocity(Vector3DReadOnly angularVelocityToIntegrate, double integrationTime, AxisAngleBasics orientationResultToPack) {
        Vector3D angularVelocityIntegrated = angularVelocityForIntegrator.get();
        angularVelocityIntegrated.set((Tuple3DReadOnly)angularVelocityToIntegrate);
        angularVelocityIntegrated.scale(integrationTime);
        AxisAngleConversion.convertRotationVectorToAxisAngle((Vector3DReadOnly)angularVelocityIntegrated, (AxisAngleBasics)orientationResultToPack);
    }

    public static void computeAngularVelocityInBodyFrameFromYawPitchRollAnglesRate(double[] yawPitchRoll, double[] yawPitchRollRates, Vector3DBasics angularVelocityToPack) {
        RotationTools.computeAngularVelocityInBodyFrameFromYawPitchRollAnglesRate(yawPitchRoll[0], yawPitchRoll[1], yawPitchRoll[2], yawPitchRollRates[0], yawPitchRollRates[1], yawPitchRollRates[2], angularVelocityToPack);
    }

    public static void computeAngularVelocityInBodyFrameFromYawPitchRollAnglesRate(double yaw, double pitch, double roll, double yawRate, double pitchRate, double rollRate, Vector3DBasics angularVelocityToPack) {
        double sRoll = Math.sin(roll);
        double cRoll = Math.cos(roll);
        double sPitch = Math.sin(pitch);
        double cPitch = Math.cos(pitch);
        angularVelocityToPack.setX(rollRate - yawRate * sPitch);
        angularVelocityToPack.setY(yawRate * cPitch * sRoll + pitchRate * cRoll);
        angularVelocityToPack.setZ(yawRate * cPitch * cRoll - pitchRate * sRoll);
    }

    public static void computeAngularVelocityInWorldFrameFromYawPitchRollAnglesRate(double[] yawPitchRoll, double[] yawPitchRollRates, Vector3DBasics angularVelocityToPack) {
        RotationTools.computeAngularVelocityInWorldFrameFromYawPitchRollAnglesRate(yawPitchRoll[0], yawPitchRoll[1], yawPitchRoll[2], yawPitchRollRates[0], yawPitchRollRates[1], yawPitchRollRates[2], angularVelocityToPack);
    }

    public static void computeAngularVelocityInWorldFrameFromYawPitchRollAnglesRate(double yaw, double pitch, double roll, double yawRate, double pitchRate, double rollRate, Vector3DBasics angularVelocityToPack) {
        double sYaw = Math.sin(yaw);
        double cYaw = Math.cos(yaw);
        double sPitch = Math.sin(pitch);
        double cPitch = Math.cos(pitch);
        angularVelocityToPack.setX(rollRate * cYaw * cPitch - pitchRate * sYaw);
        angularVelocityToPack.setY(rollRate * sYaw * cPitch + pitchRate * cYaw);
        angularVelocityToPack.setZ(yawRate - rollRate * sPitch);
    }

    public static void computeYawPitchRollAngleRatesFromAngularVelocityInBodyFrame(Vector3DReadOnly angularVelocityInBody, double yaw, double pitch, double roll, double[] yawPitchRollRatesToPack) {
        double sRoll = Math.sin(roll);
        double cRoll = Math.cos(roll);
        double sPitch = Math.sin(pitch);
        double cPitch = Math.cos(pitch);
        double yawRate = (angularVelocityInBody.getY() * sRoll + angularVelocityInBody.getZ() * cRoll) / cPitch;
        double pitchRate = angularVelocityInBody.getY() * cRoll - angularVelocityInBody.getZ() * sRoll;
        double rollRate = angularVelocityInBody.getX() + sPitch * yawRate;
        yawPitchRollRatesToPack[0] = yawRate;
        yawPitchRollRatesToPack[1] = pitchRate;
        yawPitchRollRatesToPack[2] = rollRate;
    }

    public static void computeYawPitchRollAngleRatesFromAngularVelocityInWorldFrame(Vector3DReadOnly angularVelocityInWorld, double yaw, double pitch, double roll, double[] yawPitchRollRatesToPack) {
        double yawRate;
        double sYaw = Math.sin(yaw);
        double cYaw = Math.cos(yaw);
        double sPitch = Math.sin(pitch);
        double cPitch = Math.cos(pitch);
        double rollRate = (angularVelocityInWorld.getX() * cYaw + angularVelocityInWorld.getY() * sYaw) / cPitch;
        double pitchRate = angularVelocityInWorld.getY() * cYaw - angularVelocityInWorld.getX() * sYaw;
        yawPitchRollRatesToPack[0] = yawRate = angularVelocityInWorld.getZ() + rollRate * sPitch;
        yawPitchRollRatesToPack[1] = pitchRate;
        yawPitchRollRatesToPack[2] = rollRate;
    }

    public static boolean quaternionEpsilonEquals(QuaternionReadOnly original, QuaternionReadOnly result, double epsilon) {
        if (original.epsilonEquals((EuclidGeometry)result, epsilon)) {
            return true;
        }
        Quaternion originalNegated = quaternionForEpsilonEquals.get();
        originalNegated.setAndNegate(original);
        return originalNegated.epsilonEquals((EuclidGeometry)result, epsilon);
    }

    public static void trimAxisAngleMinusPiToPi(AxisAngleReadOnly axisAngle4d, AxisAngleBasics axisAngleTrimmedToPack) {
        axisAngleTrimmedToPack.set(axisAngle4d);
        axisAngleTrimmedToPack.setAngle(AngleTools.trimAngleMinusPiToPi(axisAngleTrimmedToPack.getAngle()));
    }

    public static boolean axisAngleEpsilonEquals(AxisAngleReadOnly original, AxisAngleReadOnly result, double epsilon, AxisAngleComparisonMode mode) {
        if (mode == AxisAngleComparisonMode.IGNORE_FLIPPED_AXES) {
            return RotationTools.axisAngleEpsilonEqualsIgnoreFlippedAxes(original, result, epsilon);
        }
        if (mode == AxisAngleComparisonMode.IGNORE_FLIPPED_AXES_ROTATION_DIRECTION_AND_COMPLETE_ROTATIONS) {
            AxisAngle originalMinusPiToPi = originalAxisAngleForEpsilonEquals.get();
            RotationTools.trimAxisAngleMinusPiToPi(original, (AxisAngleBasics)originalMinusPiToPi);
            AxisAngle resultMinusPiToPi = resultAxisAngleForEpsilonEquals.get();
            RotationTools.trimAxisAngleMinusPiToPi(result, (AxisAngleBasics)resultMinusPiToPi);
            boolean originalAxisAngleIsZero = MathTools.epsilonEquals((double)originalMinusPiToPi.getAngle(), (double)0.0, (double)(0.1 * epsilon));
            boolean resultAxisAngleIsZero = MathTools.epsilonEquals((double)resultMinusPiToPi.getAngle(), (double)0.0, (double)(0.1 * epsilon));
            boolean originalAngleIs180 = MathTools.epsilonEquals((double)Math.abs(originalMinusPiToPi.getAngle()), (double)Math.PI, (double)(0.1 * epsilon));
            boolean resultAngleIs180 = MathTools.epsilonEquals((double)Math.abs(resultMinusPiToPi.getAngle()), (double)Math.PI, (double)(0.1 * epsilon));
            if (originalAxisAngleIsZero && resultAxisAngleIsZero) {
                return true;
            }
            if (originalAngleIs180 && resultAngleIs180) {
                return RotationTools.axisAngleEpsilonEqualsIgnoreFlippedAxes(original, result, epsilon);
            }
            return RotationTools.axisAngleEpsilonEqualsIgnoreFlippedAxes((AxisAngleReadOnly)originalMinusPiToPi, (AxisAngleReadOnly)resultMinusPiToPi, epsilon);
        }
        return original.epsilonEquals((EuclidGeometry)result, epsilon);
    }

    public static boolean axisAngleEpsilonEqualsIgnoreFlippedAxes(AxisAngleReadOnly original, AxisAngleReadOnly result, double epsilon) {
        if (original.epsilonEquals((EuclidGeometry)result, epsilon)) {
            return true;
        }
        AxisAngle originalNegated = originalAxisAngleForEpsilonEquals.get();
        originalNegated.setAndNegate(original);
        return originalNegated.epsilonEquals((EuclidGeometry)result, epsilon);
    }

    public static double computeYawRate(YawPitchRollReadOnly yawPitchRoll, Vector3DReadOnly angularVelocity, boolean isVelocityInLocalCoordinates) {
        double wx = angularVelocity.getX();
        double wy = angularVelocity.getY();
        double wz = angularVelocity.getZ();
        double yaw = yawPitchRoll.getYaw();
        double pitch = yawPitchRoll.getPitch();
        double roll = yawPitchRoll.getRoll();
        if (isVelocityInLocalCoordinates) {
            return (Math.sin(roll) * wy + Math.cos(roll) * wz) / Math.cos(pitch);
        }
        return wz + Math.tan(pitch) * (Math.sin(yaw) * wy + Math.cos(yaw) * wx);
    }

    public static Quaternion computeAverageQuaternion(List<QuaternionReadOnly> quaternions, TDoubleArrayList weights) {
        int i;
        DMatrixRMaj Q = new DMatrixRMaj(4, quaternions.size());
        DMatrixRMaj QWQt = new DMatrixRMaj(4, 4);
        DMatrixRMaj QW = new DMatrixRMaj(4, weights.size());
        DMatrixRMaj W = new DMatrixRMaj(weights.size(), weights.size());
        for (i = 0; i < weights.size(); ++i) {
            W.set(i, i, weights.get(i));
        }
        for (i = 0; i < quaternions.size(); ++i) {
            QuaternionReadOnly quaternion = quaternions.get(i);
            Q.set(0, i, quaternion.getX());
            Q.set(1, i, quaternion.getY());
            Q.set(2, i, quaternion.getZ());
            Q.set(3, i, quaternion.getS());
        }
        CommonOps_DDRM.mult((DMatrix1Row)Q, (DMatrix1Row)W, (DMatrix1Row)QW);
        CommonOps_DDRM.multTransB((DMatrix1Row)QW, (DMatrix1Row)Q, (DMatrix1Row)QWQt);
        CommonOps_DDRM.scale((double)((double)quaternions.size() / CommonOps_DDRM.trace((DMatrix1Row)W)), (DMatrixD1)QWQt);
        SvdImplicitQrDecompose_DDRM svd = new SvdImplicitQrDecompose_DDRM(false, true, true, true);
        DMatrixRMaj U = new DMatrixRMaj(4, 4);
        DMatrixRMaj D = new DMatrixRMaj(4, 4);
        DMatrixRMaj Vt = new DMatrixRMaj(4, 4);
        if (svd.decompose(QWQt)) {
            svd.getU(U, false);
            svd.getV(Vt, true);
            svd.getW(D);
            int maxIndex = 0;
            for (int i2 = 1; i2 < 4; ++i2) {
                if (!(D.get(i2, i2) > D.get(maxIndex, maxIndex))) continue;
                maxIndex = i2;
            }
            return new Quaternion(U.get(0, maxIndex), U.get(1, maxIndex), U.get(2, maxIndex), U.get(3, maxIndex));
        }
        return new Quaternion(quaternions.get(0));
    }

    public static enum AxisAngleComparisonMode {
        IGNORE_FLIPPED_AXES,
        IGNORE_FLIPPED_AXES_ROTATION_DIRECTION_AND_COMPLETE_ROTATIONS;

    }
}

