/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.robotics.EuclidCoreMissingTools;
import us.ihmc.robotics.RegionInWorldInterface;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.geometry.GeometryTools;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class PlanarRegionTools {
    private final ConvexPolygon2D tempPolygon = new ConvexPolygon2D();
    private final ConvexPolygon2D tempPolygon2 = new ConvexPolygon2D();
    private final ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
    private final ConvexPolygon2D regionBPolygonInRegionA = new ConvexPolygon2D();

    public double getDistanceBetweenPlanarRegions(PlanarRegion regionA, PlanarRegion regionB) {
        double minDistance = Double.POSITIVE_INFINITY;
        for (int indexA = 0; indexA < regionA.getNumberOfConvexPolygons(); ++indexA) {
            for (int indexB = 0; indexB < regionB.getNumberOfConvexPolygons(); ++indexB) {
                this.regionBPolygonInRegionA.set(regionB.getConvexPolygon(indexB));
                this.regionBPolygonInRegionA.applyTransform((Transform)regionB.getTransformToWorld(), false);
                this.regionBPolygonInRegionA.applyTransform((Transform)regionA.getTransformToLocal(), false);
                double distance = this.convexPolygonTools.distanceBetweenTwoConvexPolygon2Ds((ConvexPolygon2DReadOnly)regionA.getConvexPolygon(indexA), (ConvexPolygon2DReadOnly)this.regionBPolygonInRegionA);
                minDistance = Math.min(distance, minDistance);
                if (!(minDistance < 1.0E-8)) continue;
                return 0.0;
            }
        }
        return minDistance;
    }

    public void getPolygonIntersectionsWhenProjectedVertically(PlanarRegion regionToProjectOnto, ConvexPolygon2DReadOnly convexPolygon2DBasics, RecyclingArrayList<Point2DBasics> intersectionsInPlaneFrameToPack) {
        intersectionsInPlaneFrameToPack.clear();
        regionToProjectOnto.projectPolygonVerticallyToRegion(convexPolygon2DBasics, (ConvexPolygon2DBasics)this.tempPolygon);
        for (int i = 0; i < regionToProjectOnto.getNumberOfConvexPolygons(); ++i) {
            if (!regionToProjectOnto.getPolygonIntersection(i, (ConvexPolygon2DReadOnly)this.tempPolygon, (ConvexPolygon2DBasics)this.tempPolygon2)) continue;
            for (int j = 0; j < this.tempPolygon2.getNumberOfVertices(); ++j) {
                ((Point2DBasics)intersectionsInPlaneFrameToPack.add()).set((Tuple2DReadOnly)this.tempPolygon2.getVertex(j));
            }
        }
    }

    public static List<Point2DReadOnly> getPolygonIntersectionsWhenProjectedVertically(PlanarRegion regionToProjectOnto, ConvexPolygon2DReadOnly convexPolygon2DBasics) {
        ArrayList<Point2DReadOnly> intersectionsInPlaneFrame = new ArrayList<Point2DReadOnly>();
        ConvexPolygon2D tempPolygon = new ConvexPolygon2D();
        regionToProjectOnto.projectPolygonVerticallyToRegion(convexPolygon2DBasics, (ConvexPolygon2DBasics)tempPolygon);
        for (int i = 0; i < regionToProjectOnto.getNumberOfConvexPolygons(); ++i) {
            ConvexPolygon2D intersectingPolygon = new ConvexPolygon2D();
            if (!regionToProjectOnto.getPolygonIntersection(i, (ConvexPolygon2DReadOnly)tempPolygon, (ConvexPolygon2DBasics)intersectingPolygon)) continue;
            intersectionsInPlaneFrame.addAll(intersectingPolygon.getPolygonVerticesView());
        }
        return intersectionsInPlaneFrame;
    }

    public static boolean isPlanarRegionAAbovePlanarRegionB(PlanarRegion regionA, PlanarRegion regionB, double epsilon) {
        double minBzInWorld = regionB.getBoundingBox3dInWorld().getMinZ();
        double maxBzInWorld = regionB.getBoundingBox3dInWorld().getMaxZ();
        double maxAzInWorld = regionA.getBoundingBox3dInWorld().getMaxZ();
        if (maxAzInWorld > maxBzInWorld + epsilon) {
            return true;
        }
        if (maxAzInWorld <= minBzInWorld + epsilon) {
            return false;
        }
        ConvexPolygon2D convexHullA = regionA.getConvexHull();
        RigidBodyTransformReadOnly transformToWorldA = regionA.getTransformToWorld();
        RigidBodyTransformReadOnly transformFromWorldToLocalB = regionB.getTransformToLocal();
        List verticesA = convexHullA.getPolygonVerticesView();
        Point3D pointAInWorld = new Point3D();
        Point3D pointAInLocalB = new Point3D();
        for (Point2DReadOnly vertexAInLocal : verticesA) {
            pointAInWorld.set((Tuple2DReadOnly)vertexAInLocal);
            pointAInWorld.setZ(0.0);
            transformToWorldA.transform((Point3DBasics)pointAInWorld);
            pointAInLocalB.set(pointAInWorld);
            transformFromWorldToLocalB.transform((Point3DBasics)pointAInLocalB);
            if (!(pointAInWorld.getZ() > minBzInWorld + epsilon) || !(pointAInLocalB.getZ() > epsilon)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlanarRegionIntersectingWithCircle(Point2DReadOnly circleOriginInWorld, double circleRadius, PlanarRegion query) {
        Point2D originInLocal = new Point2D((Tuple2DReadOnly)circleOriginInWorld);
        originInLocal.applyTransform((Transform)query.getTransformToLocal(), false);
        return query.getConvexHull().signedDistance((Point2DReadOnly)originInLocal) <= circleRadius;
    }

    public static boolean isPointInsidePolygon(Point2DReadOnly[] polygon, Point2DReadOnly pointToCheck) {
        return PlanarRegionTools.isPointInsidePolygon(Arrays.asList(polygon), pointToCheck);
    }

    public static boolean isPointInsidePolygon(ConvexPolygon2DReadOnly polygon, Point2DReadOnly pointToCheck) {
        return PlanarRegionTools.isPointInsidePolygon(polygon.getPolygonVerticesView(), pointToCheck);
    }

    public static boolean isPointInsidePolygon(List<? extends Point2DReadOnly> polygon, Point2DReadOnly pointToCheck) {
        return PlanarRegionTools.isPointInsidePolygon(polygon, pointToCheck.getX(), pointToCheck.getY());
    }

    public static boolean isPointInsidePolygon(List<? extends Point2DReadOnly> polygon, double pointToCheckX, double pointToCheckY) {
        return PlanarRegionTools.isPointInsideConcaveHull(polygon, pointToCheckX, pointToCheckY);
    }

    public static boolean isPointInsidePolygon(List<? extends Point2DReadOnly> polygon, Point2DReadOnly pointToCheck, double epsilon) {
        return PlanarRegionTools.isPointInsideConcaveHull(polygon, pointToCheck.getX(), pointToCheck.getY(), epsilon);
    }

    public static boolean isPointInsideConcaveHull(List<? extends Point2DReadOnly> polygon, Point2DReadOnly test) {
        return PlanarRegionTools.isPointInsideConcaveHull(polygon, test.getX(), test.getY());
    }

    public static boolean isPointInsideConcaveHull(List<? extends Point2DReadOnly> polygon, double testX, double testY) {
        return PlanarRegionTools.isPointInsideConcaveHull(polygon, testX, testY, 1.0E-7);
    }

    public static boolean isPointInsideConcaveHull(List<? extends Point2DReadOnly> polygon, double testX, double testY, double epsilon) {
        Point2DReadOnly previousVertex;
        Point2DReadOnly vertex;
        int numberOfVertices = polygon.size();
        boolean result = false;
        int i = 0;
        int j = numberOfVertices - 1;
        while (i < numberOfVertices) {
            vertex = polygon.get(i);
            if (PlanarRegionTools.rayIntersectsWithEdge(vertex, previousVertex = polygon.get(j), testX, testY)) {
                result = !result;
            }
            j = i++;
        }
        if (result) {
            return true;
        }
        i = 0;
        j = numberOfVertices - 1;
        while (i < numberOfVertices) {
            vertex = polygon.get(i);
            if (EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((double)testX, (double)testY, (Point2DReadOnly)vertex, (Point2DReadOnly)(previousVertex = polygon.get(j))) <= epsilon) {
                return true;
            }
            j = i++;
        }
        return false;
    }

    static boolean rayIntersectsWithEdge(Point2DReadOnly vertex, Point2DReadOnly previousVertex, double startOfRayX, double startOfRayY) {
        if (startOfRayY < vertex.getY() == startOfRayY < previousVertex.getY()) {
            return false;
        }
        return startOfRayX < (previousVertex.getX() - vertex.getX()) / (previousVertex.getY() - vertex.getY()) * (startOfRayY - vertex.getY()) + vertex.getX();
    }

    public static boolean isPointInWorldInsidePlanarRegion(PlanarRegion planarRegion, Point3DReadOnly pointInWorldToCheck, double epsilon) {
        Point2D pointInLocalToCheck = new Point2D((Tuple3DReadOnly)pointInWorldToCheck);
        pointInLocalToCheck.applyTransform((Transform)planarRegion.getTransformToLocal(), false);
        return PlanarRegionTools.isPointInLocalInsidePlanarRegion(planarRegion, (Point2DReadOnly)pointInLocalToCheck, epsilon);
    }

    public static boolean isPointInLocalInsidePlanarRegion(PlanarRegion planarRegion, Point2DReadOnly pointInLocalToCheck) {
        return PlanarRegionTools.isPointInLocalInsidePlanarRegion(planarRegion, pointInLocalToCheck, 0.0);
    }

    public static boolean isPointInLocalInsidePlanarRegion(PlanarRegion planarRegion, Point2DReadOnly pointInLocalToCheck, double epsilon) {
        return PlanarRegionTools.isPointInLocalInsidePlanarRegion(planarRegion, pointInLocalToCheck.getX(), pointInLocalToCheck.getY(), epsilon);
    }

    public static boolean isPointInLocalInsidePlanarRegion(PlanarRegion planarRegion, double pointInLocalToCheckX, double pointInLocalToCheckY, double epsilon) {
        ConvexPolygon2D convexHull = planarRegion.getConvexHull();
        BoundingBox2DReadOnly boundingBox = convexHull.getBoundingBox();
        if (!boundingBox.isInsideEpsilon(pointInLocalToCheckX, pointInLocalToCheckY, epsilon)) {
            return false;
        }
        if (!convexHull.isPointInside(pointInLocalToCheckX, pointInLocalToCheckY, epsilon)) {
            return false;
        }
        if (planarRegion.getNumberOfConvexPolygons() == 1) {
            return true;
        }
        if (MathTools.epsilonEquals((double)0.0, (double)epsilon, (double)1.0E-10)) {
            return PlanarRegionTools.isPointInsideConcaveHull(planarRegion.getConcaveHull(), pointInLocalToCheckX, pointInLocalToCheckY);
        }
        List<ConvexPolygon2D> convexPolygons = planarRegion.getConvexPolygons();
        return convexPolygons.stream().anyMatch(convexPolygon2D -> convexPolygon2D.isPointInside(pointInLocalToCheckX, pointInLocalToCheckY, epsilon));
    }

    public static double getDistanceFromLineSegment3DToPlanarRegion(LineSegment3DReadOnly lineSegmentInLocal, PlanarRegion planarRegion, Point3DBasics closestPointOnSegmentToPack, Point3DBasics closestPointOnRegionToPack) {
        return PlanarRegionTools.getDistanceFromLineSegment3DToPlanarRegion(lineSegmentInLocal.getFirstEndpoint(), lineSegmentInLocal.getSecondEndpoint(), planarRegion, closestPointOnSegmentToPack, closestPointOnRegionToPack);
    }

    public static double getDistanceFromLineSegment3DToPlanarRegion(Point3DReadOnly firstEndPointInLocal, Point3DReadOnly secondEndPointInLocal, PlanarRegion planarRegion, Point3DBasics closestPointOnSegmentToPack, Point3DBasics closestPointOnRegionToPack) {
        List vertices = planarRegion.getConcaveHull().stream().map(Point3D::new).collect(Collectors.toList());
        int numberOfVertices = vertices.size();
        double minDistanceToEdge = Double.POSITIVE_INFINITY;
        if (numberOfVertices == 0) {
            minDistanceToEdge = Double.NaN;
        } else if (numberOfVertices == 1) {
            if (closestPointOnRegionToPack != null) {
                closestPointOnRegionToPack.set((Tuple3DReadOnly)vertices.get(0));
            }
            if (closestPointOnSegmentToPack != null) {
                closestPointOnSegmentToPack.set((Tuple3DReadOnly)EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)((Point3DReadOnly)vertices.get(0)), (Point3DReadOnly)firstEndPointInLocal, (Point3DReadOnly)secondEndPointInLocal));
                minDistanceToEdge = ((Point3D)vertices.get(0)).distance((Point3DReadOnly)closestPointOnSegmentToPack);
            } else {
                minDistanceToEdge = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((Point3DReadOnly)((Point3DReadOnly)vertices.get(0)), (Point3DReadOnly)firstEndPointInLocal, (Point3DReadOnly)secondEndPointInLocal);
            }
        } else if (numberOfVertices == 2) {
            minDistanceToEdge = EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)firstEndPointInLocal, (Point3DReadOnly)secondEndPointInLocal, (Point3DReadOnly)((Point3DReadOnly)vertices.get(0)), (Point3DReadOnly)((Point3DReadOnly)vertices.get(1)), (Point3DBasics)closestPointOnSegmentToPack, (Point3DBasics)closestPointOnRegionToPack);
        } else {
            Point3D point1ToThrowAway = new Point3D();
            Point3D point2ToThrowAway = new Point3D();
            for (ConvexPolygon2D convexPolygon : planarRegion.getConvexPolygons()) {
                List<Point3D> polygonVertices = convexPolygon.getVertexBufferView().stream().map(Point3D::new).collect(Collectors.toList());
                double distanceToPolygon = PlanarRegionTools.getDistanceFromLineSegment3DToConvexPolygon(firstEndPointInLocal, secondEndPointInLocal, polygonVertices, (Point3DBasics)point1ToThrowAway, (Point3DBasics)point2ToThrowAway);
                if (!(distanceToPolygon < minDistanceToEdge)) continue;
                minDistanceToEdge = distanceToPolygon;
                if (closestPointOnSegmentToPack != null) {
                    closestPointOnSegmentToPack.set((Tuple3DReadOnly)point1ToThrowAway);
                }
                if (closestPointOnRegionToPack == null) continue;
                closestPointOnRegionToPack.set((Tuple3DReadOnly)point2ToThrowAway);
            }
        }
        return minDistanceToEdge;
    }

    public static double getDistanceFromLineSegment3DToConvexPolygon(Point3DReadOnly firstEndPointInLocal, Point3DReadOnly secondEndPointInLocal, List<Point3D> convexPolygon3D, Point3DBasics closestPointOnSegmentToPack, Point3DBasics closestPointOnRegionToPack) {
        int numberOfVertices = convexPolygon3D.size();
        double minDistanceToEdge = Double.POSITIVE_INFINITY;
        if (numberOfVertices == 0) {
            minDistanceToEdge = Double.NaN;
        } else if (numberOfVertices == 1) {
            if (closestPointOnRegionToPack != null) {
                closestPointOnRegionToPack.set((Tuple3DReadOnly)convexPolygon3D.get(0));
            }
            if (closestPointOnSegmentToPack != null) {
                closestPointOnSegmentToPack.set((Tuple3DReadOnly)EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)((Point3DReadOnly)convexPolygon3D.get(0)), (Point3DReadOnly)firstEndPointInLocal, (Point3DReadOnly)secondEndPointInLocal));
                minDistanceToEdge = convexPolygon3D.get(0).distance((Point3DReadOnly)closestPointOnSegmentToPack);
            } else {
                minDistanceToEdge = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((Point3DReadOnly)((Point3DReadOnly)convexPolygon3D.get(0)), (Point3DReadOnly)firstEndPointInLocal, (Point3DReadOnly)secondEndPointInLocal);
            }
        } else if (numberOfVertices == 2) {
            minDistanceToEdge = EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)firstEndPointInLocal, (Point3DReadOnly)secondEndPointInLocal, (Point3DReadOnly)((Point3DReadOnly)convexPolygon3D.get(0)), (Point3DReadOnly)((Point3DReadOnly)convexPolygon3D.get(1)), (Point3DBasics)closestPointOnSegmentToPack, (Point3DBasics)closestPointOnRegionToPack);
        } else {
            Point3D intersectionWithPlane;
            boolean pointsAllBelow;
            Point3D point1ToThrowAway = new Point3D();
            Point3D point2ToThrowAway = new Point3D();
            boolean isQueryStartOutsidePolygon = false;
            boolean isQueryEndOutsidePolygon = false;
            for (int index = 0; index < numberOfVertices; ++index) {
                Point3DReadOnly edgeStart = (Point3DReadOnly)convexPolygon3D.get(index);
                Point3DReadOnly edgeEnd = (Point3DReadOnly)convexPolygon3D.get(EuclidGeometryPolygonTools.next((int)index, (int)numberOfVertices));
                Point2D edgeStart2D = new Point2D((Tuple3DReadOnly)edgeStart);
                Point2D edgeEnd2D = new Point2D((Tuple3DReadOnly)edgeEnd);
                double distanceToEdge = EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)firstEndPointInLocal, (Point3DReadOnly)secondEndPointInLocal, (Point3DReadOnly)edgeStart, (Point3DReadOnly)edgeEnd, (Point3DBasics)point1ToThrowAway, (Point3DBasics)point2ToThrowAway);
                if (distanceToEdge < minDistanceToEdge) {
                    minDistanceToEdge = distanceToEdge;
                    if (closestPointOnSegmentToPack != null) {
                        closestPointOnSegmentToPack.set((Tuple3DReadOnly)point1ToThrowAway);
                    }
                    if (closestPointOnRegionToPack != null) {
                        closestPointOnRegionToPack.set((Tuple3DReadOnly)point2ToThrowAway);
                    }
                }
                isQueryStartOutsidePolygon |= EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)firstEndPointInLocal.getX(), (double)firstEndPointInLocal.getY(), (Point2DReadOnly)edgeStart2D, (Point2DReadOnly)edgeEnd2D, (boolean)true);
                isQueryEndOutsidePolygon |= EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)secondEndPointInLocal.getX(), (double)secondEndPointInLocal.getY(), (Point2DReadOnly)edgeStart2D, (Point2DReadOnly)edgeEnd2D, (boolean)true);
            }
            boolean pointsAllAbove = firstEndPointInLocal.getZ() > 0.0 && secondEndPointInLocal.getZ() > 0.0;
            boolean bl = pointsAllBelow = firstEndPointInLocal.getZ() < 0.0 && secondEndPointInLocal.getZ() < 0.0;
            if (!isQueryStartOutsidePolygon && !isQueryEndOutsidePolygon) {
                double distanceToSecondEnd;
                double distanceToFirstEnd = Math.abs(firstEndPointInLocal.getZ());
                if (distanceToFirstEnd < (distanceToSecondEnd = Math.abs(secondEndPointInLocal.getZ()))) {
                    minDistanceToEdge = distanceToFirstEnd;
                    if (closestPointOnSegmentToPack != null) {
                        closestPointOnSegmentToPack.set((Tuple3DReadOnly)firstEndPointInLocal);
                    }
                    if (closestPointOnRegionToPack != null) {
                        closestPointOnRegionToPack.set(firstEndPointInLocal.getX(), firstEndPointInLocal.getY(), 0.0);
                    }
                } else {
                    minDistanceToEdge = distanceToSecondEnd;
                    if (closestPointOnSegmentToPack != null) {
                        closestPointOnSegmentToPack.set((Tuple3DReadOnly)secondEndPointInLocal);
                    }
                    if (closestPointOnRegionToPack != null) {
                        closestPointOnRegionToPack.set(secondEndPointInLocal.getX(), secondEndPointInLocal.getY(), 0.0);
                    }
                }
            } else if (!(pointsAllAbove && pointsAllBelow || (intersectionWithPlane = EuclidGeometryTools.intersectionBetweenLineSegment3DAndPlane3D((Point3DReadOnly)((Point3DReadOnly)convexPolygon3D.get(0)), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0), (Point3DReadOnly)firstEndPointInLocal, (Point3DReadOnly)secondEndPointInLocal)) == null)) {
                ArrayList polygonIn2D = new ArrayList();
                Point2D intersectionIn2D = new Point2D((Tuple3DReadOnly)intersectionWithPlane);
                convexPolygon3D.forEach(vertex -> polygonIn2D.add(new Point2D((Tuple3DReadOnly)vertex)));
                if (PlanarRegionTools.isPointInsidePolygon(polygonIn2D, (Point2DReadOnly)intersectionIn2D)) {
                    minDistanceToEdge = -minDistanceToEdge;
                    if (closestPointOnRegionToPack != null) {
                        closestPointOnRegionToPack.set((Tuple3DReadOnly)intersectionWithPlane);
                    }
                    if (closestPointOnSegmentToPack != null) {
                        closestPointOnSegmentToPack.set((Tuple3DReadOnly)intersectionWithPlane);
                    }
                }
            }
        }
        return minDistanceToEdge;
    }

    public static double getDistanceFromLineSegment3DToConvexPolygon(Point3DReadOnly firstEndPointInLocal, Point3DReadOnly secondEndPointInLocal, List<Point3D> convexPolygon3D) {
        int numberOfVertices = convexPolygon3D.size();
        double minDistanceToEdge = Double.POSITIVE_INFINITY;
        if (numberOfVertices == 0) {
            minDistanceToEdge = Double.NaN;
        } else if (numberOfVertices == 1) {
            minDistanceToEdge = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((Point3DReadOnly)((Point3DReadOnly)convexPolygon3D.get(0)), (Point3DReadOnly)firstEndPointInLocal, (Point3DReadOnly)secondEndPointInLocal);
        } else if (numberOfVertices == 2) {
            minDistanceToEdge = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)firstEndPointInLocal, (Point3DReadOnly)secondEndPointInLocal, (Point3DReadOnly)((Point3DReadOnly)convexPolygon3D.get(0)), (Point3DReadOnly)((Point3DReadOnly)convexPolygon3D.get(1)));
        } else {
            Point3D intersectionWithPlane;
            boolean pointsAllBelow;
            boolean isQueryStartOutsidePolygon = false;
            boolean isQueryEndOutsidePolygon = false;
            for (int index = 0; index < numberOfVertices; ++index) {
                Point3DReadOnly edgeStart = (Point3DReadOnly)convexPolygon3D.get(index);
                Point3DReadOnly edgeEnd = (Point3DReadOnly)convexPolygon3D.get(EuclidGeometryPolygonTools.next((int)index, (int)numberOfVertices));
                Point2D edgeStart2D = new Point2D((Tuple3DReadOnly)edgeStart);
                Point2D edgeEnd2D = new Point2D((Tuple3DReadOnly)edgeEnd);
                minDistanceToEdge = Math.min(minDistanceToEdge, EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)firstEndPointInLocal, (Point3DReadOnly)secondEndPointInLocal, (Point3DReadOnly)edgeStart, (Point3DReadOnly)edgeEnd));
                isQueryStartOutsidePolygon |= EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)firstEndPointInLocal.getX(), (double)firstEndPointInLocal.getY(), (Point2DReadOnly)edgeStart2D, (Point2DReadOnly)edgeEnd2D, (boolean)true);
                isQueryEndOutsidePolygon |= EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)secondEndPointInLocal.getX(), (double)secondEndPointInLocal.getY(), (Point2DReadOnly)edgeStart2D, (Point2DReadOnly)edgeEnd2D, (boolean)true);
            }
            boolean pointsAllAbove = firstEndPointInLocal.getZ() > 0.0 && secondEndPointInLocal.getZ() > 0.0;
            boolean bl = pointsAllBelow = firstEndPointInLocal.getZ() < 0.0 && secondEndPointInLocal.getZ() < 0.0;
            if (!isQueryStartOutsidePolygon && !isQueryEndOutsidePolygon) {
                minDistanceToEdge = Math.min(Math.abs(firstEndPointInLocal.getZ()), Math.abs(secondEndPointInLocal.getZ()));
            } else if (!(pointsAllAbove && pointsAllBelow || (intersectionWithPlane = EuclidGeometryTools.intersectionBetweenLineSegment3DAndPlane3D((Point3DReadOnly)((Point3DReadOnly)convexPolygon3D.get(0)), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0), (Point3DReadOnly)firstEndPointInLocal, (Point3DReadOnly)secondEndPointInLocal)) == null)) {
                ArrayList polygonIn2D = new ArrayList();
                Point2D intersectionIn2D = new Point2D((Tuple3DReadOnly)intersectionWithPlane);
                convexPolygon3D.forEach(vertex -> polygonIn2D.add(new Point2D((Tuple3DReadOnly)vertex)));
                if (PlanarRegionTools.isPointInsidePolygon(polygonIn2D, (Point2DReadOnly)intersectionIn2D)) {
                    minDistanceToEdge = -minDistanceToEdge;
                }
            }
        }
        return minDistanceToEdge;
    }

    public static boolean isPlanarRegionIntersectingWithCapsule(LineSegment3D capsuleSegmentInWorld, double capsuleRadius, PlanarRegion query) {
        RigidBodyTransformReadOnly transformToLocal = query.getTransformToLocal();
        Point3D firstEndPointInLocal = new Point3D((Tuple3DReadOnly)capsuleSegmentInWorld.getFirstEndpoint());
        Point3D secondEndPointInLocal = new Point3D((Tuple3DReadOnly)capsuleSegmentInWorld.getSecondEndpoint());
        firstEndPointInLocal.applyTransform((Transform)transformToLocal);
        secondEndPointInLocal.applyTransform((Transform)transformToLocal);
        List<Point2D> concaveHull = query.getConcaveHull();
        ArrayList<Point3D> convexPolygon3D = new ArrayList<Point3D>();
        for (int i = 0; i < concaveHull.size(); ++i) {
            convexPolygon3D.add(new Point3D((Tuple2DReadOnly)concaveHull.get(i)));
        }
        double minDistanceToEdge = PlanarRegionTools.getDistanceFromLineSegment3DToConvexPolygon((Point3DReadOnly)firstEndPointInLocal, (Point3DReadOnly)secondEndPointInLocal, convexPolygon3D);
        return minDistanceToEdge <= capsuleRadius;
    }

    public static BoundingBox3D getLocalBoundingBox3DInLocal(PlanarRegion planarRegion) {
        BoundingBox3D boundingBox3DInLocal = new BoundingBox3D();
        for (ConvexPolygon2D convexPolygon : planarRegion.getConvexPolygons()) {
            for (int j = 0; j < convexPolygon.getNumberOfVertices(); ++j) {
                boundingBox3DInLocal.updateToIncludePoint(convexPolygon.getVertex(j).getX(), convexPolygon.getVertex(j).getY(), 0.0);
            }
        }
        return boundingBox3DInLocal;
    }

    public static BoundingBox2D getLocalBoundingBox2DInLocal(PlanarRegion planarRegion) {
        BoundingBox2D boundingBox2DInLocal = null;
        for (ConvexPolygon2D convexPolygon : planarRegion.getConvexPolygons()) {
            for (int j = 0; j < convexPolygon.getNumberOfVertices(); ++j) {
                Point2DReadOnly vertex = convexPolygon.getVertex(j);
                if (boundingBox2DInLocal == null) {
                    boundingBox2DInLocal = new BoundingBox2D(vertex, vertex);
                    continue;
                }
                boundingBox2DInLocal.updateToIncludePoint(vertex);
            }
        }
        return boundingBox2DInLocal;
    }

    public static Box3D getLocalBoundingBox3DInWorld(PlanarRegion planarRegion, double height) {
        BoundingBox3D boundingBox3DInLocal = PlanarRegionTools.getLocalBoundingBox3DInLocal(planarRegion);
        boundingBox3DInLocal.updateToIncludePoint(0.0, 0.0, height / 2.0);
        boundingBox3DInLocal.updateToIncludePoint(0.0, 0.0, -height / 2.0);
        Box3D box = GeometryTools.convertBoundingBox3DToBox3D((BoundingBox3DReadOnly)boundingBox3DInLocal);
        box.applyTransform((Transform)planarRegion.getTransformToWorld());
        return box;
    }

    public static BoundingBox3D getWorldBoundingBox3DWithMargin(PlanarRegion planarRegion, double margin) {
        BoundingBox3D boundingBox = planarRegion.getBoundingBox3dInWorldCopy();
        boundingBox.getMaxPoint().add(margin, margin, margin);
        boundingBox.getMinPoint().sub(margin, margin, margin);
        return boundingBox;
    }

    public static List<PlanarRegion> filterPlanarRegionsByHullSize(int minNumberOfVertices, List<PlanarRegion> planarRegions) {
        if (minNumberOfVertices <= 0) {
            return planarRegions;
        }
        return planarRegions.stream().filter(region -> region.getConcaveHull().size() >= minNumberOfVertices).collect(Collectors.toList());
    }

    public static List<PlanarRegion> filterPlanarRegionsByArea(double minArea, List<PlanarRegion> planarRegions) {
        if (!Double.isFinite(minArea) || minArea <= 0.0) {
            return planarRegions;
        }
        return planarRegions.stream().filter(region -> PlanarRegionTools.computePlanarRegionArea(region) >= minArea).collect(Collectors.toList());
    }

    public static List<PlanarRegion> filterPlanarRegionsWithBoundingCircle(Point2DReadOnly circleOrigin, double circleRadius, List<PlanarRegion> planarRegions) {
        if (!Double.isFinite(circleRadius) || circleRadius < 0.0) {
            return planarRegions;
        }
        return planarRegions.stream().filter(region -> PlanarRegionTools.isPlanarRegionIntersectingWithCircle(circleOrigin, circleRadius, region)).collect(Collectors.toList());
    }

    public static List<PlanarRegion> filterPlanarRegionsWithBoundingCapsule(Point3DReadOnly capsuleStartInWorld, Point3DReadOnly capsuleEndInWorld, double capsuleRadius, List<PlanarRegion> planarRegions) {
        return PlanarRegionTools.filterPlanarRegionsWithBoundingCapsule(new LineSegment3D(capsuleStartInWorld, capsuleEndInWorld), capsuleRadius, planarRegions);
    }

    public static List<PlanarRegion> filterPlanarRegionsWithBoundingCapsule(LineSegment3D capsuleSegmentInWorld, double capsuleRadius, List<PlanarRegion> planarRegions) {
        if (!Double.isFinite(capsuleRadius) || capsuleRadius < 0.0) {
            return planarRegions;
        }
        return planarRegions.stream().filter(region -> PlanarRegionTools.isPlanarRegionIntersectingWithCapsule(capsuleSegmentInWorld, capsuleRadius, region)).collect(Collectors.toList());
    }

    public static double computePlanarRegionArea(PlanarRegion planarRegion) {
        double area = 0.0;
        for (int i = 0; i < planarRegion.getNumberOfConvexPolygons(); ++i) {
            area += planarRegion.getConvexPolygon(i).getArea();
        }
        return area;
    }

    public static Point2DReadOnly getCentroid2DInLocal(PlanarRegion planarRegion) {
        Point2D centroid = new Point2D();
        double totalArea = 0.0;
        for (ConvexPolygon2D convexPolygon : planarRegion.getConvexPolygons()) {
            double area = convexPolygon.getArea();
            totalArea += area;
            Point2DReadOnly convexPolygonCentroid = convexPolygon.getCentroid();
            centroid.scaleAdd(area, (Tuple2DReadOnly)convexPolygonCentroid, (Tuple2DReadOnly)centroid);
        }
        centroid.scale(1.0 / totalArea);
        return centroid;
    }

    public static Point3DReadOnly getCentroid3DInWorld(PlanarRegion planarRegion) {
        Point2DReadOnly centroidInLocal = PlanarRegionTools.getCentroid2DInLocal(planarRegion);
        Point3D point3D = new Point3D((Tuple2DReadOnly)centroidInLocal);
        point3D.applyTransform((Transform)planarRegion.getTransformToWorld());
        return point3D;
    }

    public static double computeMinHeightOfRegionAAboveRegionB(PlanarRegion regionA, PlanarRegion regionB) {
        RigidBodyTransformReadOnly transformFromAToWorld = regionA.getTransformToWorld();
        double minZOfAProjectedToB = Double.POSITIVE_INFINITY;
        ConvexPolygon2D convexHullInLocalA = regionA.getConvexHull();
        for (int i = 0; i < convexHullInLocalA.getNumberOfVertices(); ++i) {
            Point3D vertexOfAInWorld = new Point3D((Tuple2DReadOnly)convexHullInLocalA.getVertex(i));
            transformFromAToWorld.transform((Point3DBasics)vertexOfAInWorld);
            Point3D vertexOfAProjectedToBInWorld = PlanarRegionTools.projectInZToPlanarRegion((Point3DReadOnly)vertexOfAInWorld, regionB);
            double deltaZ = vertexOfAInWorld.getZ() - vertexOfAProjectedToBInWorld.getZ();
            minZOfAProjectedToB = Math.min(minZOfAProjectedToB, deltaZ);
        }
        RigidBodyTransformReadOnly transformFromBToWorld = regionB.getTransformToWorld();
        double minZOfBProjectedToA = Double.POSITIVE_INFINITY;
        ConvexPolygon2D convexHullInLocalB = regionB.getConvexHull();
        for (int i = 0; i < convexHullInLocalB.getNumberOfVertices(); ++i) {
            Point3D vertexOfBInWorld = new Point3D((Tuple2DReadOnly)convexHullInLocalB.getVertex(i));
            transformFromBToWorld.transform((Point3DBasics)vertexOfBInWorld);
            Point3D vertexOfBProjectedToAInWorld = PlanarRegionTools.projectInZToPlanarRegion((Point3DReadOnly)vertexOfBInWorld, regionA);
            double deltaZ = vertexOfBProjectedToAInWorld.getZ() - vertexOfBInWorld.getZ();
            minZOfBProjectedToA = Math.min(minZOfBProjectedToA, deltaZ);
        }
        if (Double.isInfinite(minZOfAProjectedToB)) {
            return minZOfBProjectedToA;
        }
        if (Double.isInfinite(minZOfBProjectedToA)) {
            return minZOfAProjectedToB;
        }
        return Math.max(minZOfAProjectedToB, minZOfBProjectedToA);
    }

    public static Point3D projectInZToPlanarRegion(Point3DReadOnly pointInWorldToProjectInZ, PlanarRegion planarRegion) {
        Point3D projectedPoint = new Point3D((Tuple3DReadOnly)pointInWorldToProjectInZ);
        projectedPoint.setZ(planarRegion.getPlaneZGivenXY(pointInWorldToProjectInZ.getX(), pointInWorldToProjectInZ.getY()));
        return projectedPoint;
    }

    public static boolean allVerticesAreAbovePlane3D(Plane3D plane, PlanarRegion planarRegion) {
        Point3D vertexInWorld = new Point3D();
        RigidBodyTransformReadOnly regionToWorld = planarRegion.getTransformToWorld();
        for (ConvexPolygon2D convexPolygon : planarRegion.getConvexPolygons()) {
            for (int i = 0; i < convexPolygon.getNumberOfVertices(); ++i) {
                Point2DReadOnly vertex = convexPolygon.getVertex(i);
                vertexInWorld.set(vertex.getX(), vertex.getY(), 0.0);
                vertexInWorld.applyTransform((Transform)regionToWorld);
                if (EuclidGeometryTools.isPoint3DAbovePlane3D((Point3DReadOnly)vertexInWorld, (Point3DReadOnly)plane.getPoint(), (Vector3DReadOnly)plane.getNormal())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean allVerticesAreBelowPlane3D(Plane3D plane, PlanarRegion planarRegion) {
        Point3D vertexInWorld = new Point3D();
        RigidBodyTransformReadOnly regionToWorld = planarRegion.getTransformToWorld();
        for (ConvexPolygon2D convexPolygon : planarRegion.getConvexPolygons()) {
            for (int i = 0; i < convexPolygon.getNumberOfVertices(); ++i) {
                Point2DReadOnly vertex = convexPolygon.getVertex(i);
                vertexInWorld.set(vertex.getX(), vertex.getY(), 0.0);
                vertexInWorld.applyTransform((Transform)regionToWorld);
                if (EuclidGeometryTools.isPoint3DBelowPlane3D((Point3DReadOnly)vertexInWorld, (Point3DReadOnly)plane.getPoint(), (Vector3DReadOnly)plane.getNormal())) continue;
                return false;
            }
        }
        return true;
    }

    public static List<PlanarRegion> findPlanarRegionsIntersectingPolygon(ConvexPolygon2DReadOnly convexPolygon, PlanarRegionsList regions) {
        return PlanarRegionTools.findPlanarRegionsIntersectingPolygon(convexPolygon, regions.getPlanarRegionsAsList());
    }

    public static List<PlanarRegion> findPlanarRegionsIntersectingPolygon(ConvexPolygon2DReadOnly convexPolygon, List<PlanarRegion> regions) {
        ArrayList<PlanarRegion> containers = new ArrayList<PlanarRegion>();
        if (PlanarRegionTools.findPlanarRegionsIntersectingPolygon(convexPolygon, regions, containers)) {
            return containers;
        }
        return null;
    }

    public static boolean findPlanarRegionsIntersectingPolygon(ConvexPolygon2DReadOnly convexPolygon, List<PlanarRegion> regions, List<PlanarRegion> intersectingRegionsToPack) {
        return PlanarRegionTools.findPlanarRegionsIntersectingPolygon(convexPolygon, regions, intersectingRegionsToPack, null);
    }

    public static boolean findPlanarRegionsIntersectingPolygon(ConvexPolygon2DReadOnly convexPolygon, List<PlanarRegion> regions, List<PlanarRegion> intersectingRegionsToPack, TDoubleArrayList intersectionAreasToPack) {
        intersectingRegionsToPack.clear();
        if (intersectionAreasToPack != null) {
            intersectionAreasToPack.reset();
        }
        boolean hasIntersection = false;
        for (int i = 0; i < regions.size(); ++i) {
            double intersectingArea;
            PlanarRegion candidateRegion = regions.get(i);
            if (candidateRegion.isVertical() || !((intersectingArea = candidateRegion.computeIntersectingArea(convexPolygon)) > 0.0)) continue;
            hasIntersection = true;
            intersectingRegionsToPack.add(candidateRegion);
            if (intersectionAreasToPack == null) continue;
            intersectionAreasToPack.add(intersectingArea);
        }
        return hasIntersection;
    }

    public static List<PlanarRegion> findPlanarRegionsContainingPoint(List<PlanarRegion> planarRegionsToCheck, Point3DReadOnly point, double maximumOrthogonalDistance) {
        ArrayList<PlanarRegion> containers = null;
        for (int i = 0; i < planarRegionsToCheck.size(); ++i) {
            PlanarRegion candidateRegion = planarRegionsToCheck.get(i);
            if (!candidateRegion.isPointInside(point, maximumOrthogonalDistance)) continue;
            if (containers == null) {
                containers = new ArrayList<PlanarRegion>();
            }
            containers.add(candidateRegion);
        }
        return containers;
    }

    public static List<PlanarRegion> findPlanarRegionsContainingPointByProjectionOntoXYPlane(List<PlanarRegion> planarRegionsToCheck, Point2DReadOnly point) {
        return PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegionsToCheck, point.getX(), point.getY());
    }

    public static List<PlanarRegion> findPlanarRegionsContainingPointByProjectionOntoXYPlane(List<PlanarRegion> planarRegionsToCheck, double x, double y) {
        ArrayList<PlanarRegion> containers = null;
        for (int i = 0; i < planarRegionsToCheck.size(); ++i) {
            PlanarRegion candidateRegion = planarRegionsToCheck.get(i);
            if (!candidateRegion.isPointInsideByProjectionOntoXYPlane(x, y)) continue;
            if (containers == null) {
                containers = new ArrayList<PlanarRegion>();
            }
            containers.add(candidateRegion);
        }
        return containers;
    }

    public static boolean isRegionAOverlappingWithRegionB(PlanarRegion regionOne, PlanarRegion regionTwo, double epsilon) {
        BoundingBox2DReadOnly boundingBoxTwo;
        BoundingBox2DReadOnly boundingBoxOne = PlanarRegionTools.getVerticallyProjectedBoundingBox(regionOne);
        return boundingBoxOne.intersectsEpsilon(boundingBoxTwo = PlanarRegionTools.getVerticallyProjectedBoundingBox(regionTwo), epsilon);
    }

    public static BoundingBox2DReadOnly getVerticallyProjectedBoundingBox(PlanarRegion planarRegion) {
        BoundingBox3D boundingBox3D = planarRegion.getBoundingBox3dInWorld();
        Point3DReadOnly maxPoint = boundingBox3D.getMaxPoint();
        Point3DReadOnly minPoint = boundingBox3D.getMinPoint();
        return new BoundingBox2D(minPoint.getX(), minPoint.getY(), maxPoint.getX(), maxPoint.getY());
    }

    public static ConvexPolygon2D getVerticallyProjectedConvexHull(PlanarRegion planarRegion) {
        return PlanarRegionTools.projectPolygonVertically(planarRegion.getTransformToWorld(), (ConvexPolygon2DReadOnly)planarRegion.getConvexHull());
    }

    public static ConvexPolygon2D projectPolygonVertically(RigidBodyTransformReadOnly transformToWorld, ConvexPolygon2DReadOnly polygonInLocalToProjectVertically) {
        List verticesToProject = polygonInLocalToProjectVertically.getPolygonVerticesView();
        ConvexPolygon2D projectedPolygon = new ConvexPolygon2D();
        for (Point2DReadOnly vertexToProject : verticesToProject) {
            Point3D pointToProjectInWorld = new Point3D((Tuple2DReadOnly)vertexToProject);
            transformToWorld.transform((Point3DBasics)pointToProjectInWorld);
            projectedPolygon.addVertex(pointToProjectInWorld.getX(), pointToProjectInWorld.getY());
        }
        projectedPolygon.update();
        return projectedPolygon;
    }

    private static ConvexPolygon2D createSmallRectangleFromLineSegment(ConvexPolygon2D linePolygon, double rectangleWidth) {
        List vertices = linePolygon.getPolygonVerticesView();
        Vector2D vector = new Vector2D();
        vector.set((Tuple2DReadOnly)vertices.get(1));
        vector.sub((Tuple2DReadOnly)vertices.get(0));
        vector.normalize();
        Vector2D toTheRight = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)vector);
        toTheRight.scale(-1.0 * rectangleWidth);
        Point2D newPointA = new Point2D((Tuple2DReadOnly)vertices.get(1));
        newPointA.add((Tuple2DReadOnly)toTheRight);
        Point2D newPointB = new Point2D((Tuple2DReadOnly)vertices.get(0));
        newPointB.add((Tuple2DReadOnly)toTheRight);
        ArrayList<Object> polygonPoints = new ArrayList<Object>();
        polygonPoints.add((Point2DReadOnly)vertices.get(0));
        polygonPoints.add((Point2DReadOnly)vertices.get(1));
        polygonPoints.add(newPointA);
        polygonPoints.add(newPointB);
        linePolygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(polygonPoints));
        return linePolygon;
    }

    public static boolean isPointInWorldInsidePlanarRegion(PlanarRegion planarRegion, Point3DReadOnly pointInWorldToCheck) {
        return PlanarRegionTools.isPointInWorldInsidePlanarRegion(planarRegion, pointInWorldToCheck, 0.0);
    }

    public static boolean areBothPointsInsidePlanarRegion(Point2DReadOnly point1, Point2DReadOnly point2, PlanarRegion homeRegion) {
        if (!PlanarRegionTools.isPointInLocalInsidePlanarRegion(homeRegion, point1)) {
            return false;
        }
        return PlanarRegionTools.isPointInLocalInsidePlanarRegion(homeRegion, point2);
    }

    public static Point3D projectPointToPlanes(Point3DReadOnly point, PlanarRegionsList regions) {
        double smallestDistance = Double.POSITIVE_INFINITY;
        Point3D closestPoint = null;
        for (PlanarRegion region : regions.getPlanarRegionsAsList()) {
            Point3D intersection = PlanarRegionTools.closestPointOnPlanarRegion(point, region);
            double distance = intersection.distance(point);
            if (closestPoint != null && !(distance < smallestDistance)) continue;
            smallestDistance = distance;
            closestPoint = intersection;
        }
        return closestPoint;
    }

    public static double distanceToPlanarRegion(Point3DReadOnly pointInWorld, PlanarRegion planarRegion) {
        return pointInWorld.distance((Point3DReadOnly)PlanarRegionTools.closestPointOnPlanarRegion(pointInWorld, planarRegion));
    }

    public static Point3D closestPointOnPlanarRegion(Point3DReadOnly pointInWorld, PlanarRegion region) {
        return PlanarRegionTools.closestPointOnPlanarRegion(pointInWorld, (ConvexPolygon2DReadOnly)region.getConvexHull(), region.getTransformToWorld(), region.getTransformToLocal());
    }

    public static Point3D closestPointOnPlanarRegion(Point3DReadOnly pointInWorld, ConvexPolygon2DReadOnly regionConvexHull, RigidBodyTransformReadOnly regionToWorld, RigidBodyTransformReadOnly regionToLocal) {
        Vector3D planeNormal = new Vector3D(0.0, 0.0, 1.0);
        planeNormal.applyTransform((Transform)regionToWorld);
        Point3D pointOnPlane = new Point3D();
        pointOnPlane.set((Tuple2DReadOnly)regionConvexHull.getVertex(0));
        pointOnPlane.applyTransform((Transform)regionToWorld);
        Point3D intersectionWithPlane = EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)pointInWorld, (Vector3DReadOnly)planeNormal);
        if (intersectionWithPlane == null) {
            return null;
        }
        Point3D intersectionInPlaneFrame = new Point3D((Tuple3DReadOnly)intersectionWithPlane);
        intersectionInPlaneFrame.applyTransform((Transform)regionToLocal);
        Point2D intersectionInPlaneFrame2D = new Point2D((Tuple3DReadOnly)intersectionInPlaneFrame);
        if (!regionConvexHull.isPointInside((Point2DReadOnly)intersectionInPlaneFrame2D)) {
            regionConvexHull.orthogonalProjection((Point2DBasics)intersectionInPlaneFrame2D);
            intersectionWithPlane.setToZero();
            intersectionWithPlane.set((Tuple2DReadOnly)intersectionInPlaneFrame2D);
            intersectionWithPlane.applyTransform((Transform)regionToWorld);
        }
        return intersectionWithPlane;
    }

    public static <T extends RegionInWorldInterface<T>> Point3D intersectRegionWithLine(RegionInWorldInterface<T> region, Line3DReadOnly projectionLineInWorld) {
        Point3D pointToReturn = new Point3D();
        if (PlanarRegionTools.intersectRegionWithLine(region, projectionLineInWorld, (Point3DBasics)pointToReturn)) {
            return pointToReturn;
        }
        return null;
    }

    public static <T extends RegionInWorldInterface<T>> boolean intersectRegionWithLine(RegionInWorldInterface<T> region, Line3DReadOnly projectionLineInWorld, Point3DBasics intersectionToPack) {
        return PlanarRegionTools.intersectRegionWithLine(region, projectionLineInWorld.getPoint(), (Vector3DReadOnly)projectionLineInWorld.getDirection(), intersectionToPack);
    }

    public static <T extends RegionInWorldInterface<T>> boolean intersectRegionWithLine(RegionInWorldInterface<T> region, Point3DReadOnly lineOriginInWorld, Vector3DReadOnly lineDirectionInWorld, Point3DBasics intersectionToPack) {
        return PlanarRegionTools.intersectRegionWithLine(region, lineOriginInWorld.getX(), lineOriginInWorld.getY(), lineOriginInWorld.getZ(), lineDirectionInWorld.getX(), lineDirectionInWorld.getY(), lineDirectionInWorld.getZ(), intersectionToPack);
    }

    public static <T extends RegionInWorldInterface<T>> boolean intersectRegionWithLine(RegionInWorldInterface<T> region, double lineOriginInWorldX, double lineOriginInWorldY, double lineOriginInWorldZ, double lineDirectionInWorldX, double lineDirectionInWorldY, double lineDirectionInWorldZ, Point3DBasics intersectionToPack) {
        Point3DReadOnly pointOnPlane = region.getPoint();
        UnitVector3DReadOnly planeNormal = region.getNormal();
        boolean intersectsPlane = EuclidCoreMissingTools.intersectionBetweenLine3DAndPlane3D(pointOnPlane.getX(), pointOnPlane.getY(), pointOnPlane.getZ(), planeNormal.getX(), planeNormal.getY(), planeNormal.getZ(), lineOriginInWorldX, lineOriginInWorldY, lineOriginInWorldZ, lineDirectionInWorldX, lineDirectionInWorldY, lineDirectionInWorldZ, intersectionToPack);
        if (!intersectsPlane) {
            intersectionToPack.setToNaN();
            return false;
        }
        region.getTransformToLocal().transform(intersectionToPack);
        if (region.isPointInside(intersectionToPack.getX(), intersectionToPack.getY())) {
            region.getTransformToWorld().transform(intersectionToPack);
            return true;
        }
        intersectionToPack.setToNaN();
        return false;
    }

    public static ImmutablePair<Point3D, PlanarRegion> intersectRegionsWithRay(PlanarRegionsList regions, Point3DReadOnly rayStart, Vector3D rayDirection) {
        return PlanarRegionTools.intersectRegionsWithRay(regions.getPlanarRegionsAsList(), rayStart, rayDirection);
    }

    public static ImmutablePair<Point3D, PlanarRegion> intersectRegionsWithRay(List<PlanarRegion> regions, Point3DReadOnly rayStart, Vector3D rayDirection) {
        double smallestDistance = Double.POSITIVE_INFINITY;
        ImmutablePair closestIntersection = null;
        for (PlanarRegion region : regions) {
            double distance;
            Point3D intersection = PlanarRegionTools.intersectRegionWithRay(region, rayStart, (Vector3DReadOnly)rayDirection);
            if (intersection == null || !((distance = intersection.distance(rayStart)) < smallestDistance)) continue;
            smallestDistance = distance;
            closestIntersection = new ImmutablePair((Object)intersection, (Object)region);
        }
        return closestIntersection;
    }

    public static Point3D intersectRegionWithRay(PlanarRegion region, Point3DReadOnly rayStart, Vector3DReadOnly rayDirection) {
        RigidBodyTransformReadOnly regionToWorld = region.getTransformToWorld();
        RigidBodyTransformReadOnly regionToLocal = region.getTransformToLocal();
        Vector3D planeNormal = new Vector3D(0.0, 0.0, 1.0);
        planeNormal.applyTransform((Transform)regionToWorld);
        Point3D pointOnPlane = new Point3D();
        pointOnPlane.set((Tuple2DReadOnly)region.getConvexPolygon(0).getVertex(0));
        pointOnPlane.applyTransform((Transform)regionToWorld);
        Point3D intersectionWithPlane = EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)rayStart, (Vector3DReadOnly)rayDirection);
        if (intersectionWithPlane == null) {
            return null;
        }
        Point3D intersectionInPlaneFrame = new Point3D((Tuple3DReadOnly)intersectionWithPlane);
        intersectionInPlaneFrame.applyTransform((Transform)regionToLocal);
        if (!region.getConvexHull().isPointInside(intersectionInPlaneFrame.getX(), intersectionInPlaneFrame.getY())) {
            return null;
        }
        Vector3D rayToIntersection = new Vector3D();
        rayToIntersection.sub((Tuple3DReadOnly)intersectionWithPlane, (Tuple3DReadOnly)rayStart);
        if (rayToIntersection.dot((Tuple3DReadOnly)rayDirection) < 0.0) {
            return null;
        }
        return intersectionWithPlane;
    }

    public static Point3D projectPointToPlanesVertically(Point3DReadOnly pointInWorld, PlanarRegionsList regions) {
        if (regions == null) {
            return PlanarRegionTools.projectPointToPlanesVertically(pointInWorld, (List<PlanarRegion>)null);
        }
        return PlanarRegionTools.projectPointToPlanesVertically(pointInWorld, regions.getPlanarRegionsAsList());
    }

    public static Point3D projectPointToPlanesVertically(Point3DReadOnly pointInWorld, List<PlanarRegion> regions) {
        return PlanarRegionTools.projectPointToPlanesVertically(pointInWorld, regions, null);
    }

    public static <T extends RegionInWorldInterface<T>> Point3D projectPointToPlanesVertically(Point3DReadOnly pointInWorld, List<T> regions, T highestRegionToPack) {
        Point3D highestIntersection = null;
        Line3D verticalLine = new Line3D();
        verticalLine.set(pointInWorld, (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        if (regions == null) {
            return null;
        }
        for (RegionInWorldInterface region : regions) {
            Point3D intersection = PlanarRegionTools.intersectRegionWithLine(region, (Line3DReadOnly)verticalLine);
            if (intersection == null) continue;
            if (highestIntersection == null) {
                highestIntersection = new Point3D((Tuple3DReadOnly)pointInWorld);
                highestIntersection.setZ(Double.NEGATIVE_INFINITY);
                if (highestRegionToPack != null) {
                    highestRegionToPack.set(region);
                }
            }
            double height = intersection.getZ();
            if (!(highestIntersection.getZ() < height)) continue;
            highestIntersection.setZ(height);
            if (highestRegionToPack == null) continue;
            highestRegionToPack.set(region);
        }
        if (highestIntersection != null && Double.isInfinite(highestIntersection.getZ())) {
            return null;
        }
        return highestIntersection;
    }

    public static <T extends RegionInWorldInterface<T>> T projectPointToPlanesVertically(Point3DReadOnly pointInWorldToProject, List<T> regions, Point3DBasics projectedPointToPack, T highestRegionToPack) {
        if (regions == null) {
            projectedPointToPack.setToNaN();
            return null;
        }
        double originalX = projectedPointToPack.getX();
        double originalY = projectedPointToPack.getY();
        double highestZ = Double.NEGATIVE_INFINITY;
        RegionInWorldInterface highestRegion = null;
        for (int i = 0; i < regions.size(); ++i) {
            double height;
            RegionInWorldInterface region = (RegionInWorldInterface)regions.get(i);
            if (!PlanarRegionTools.intersectRegionWithLine(region, pointInWorldToProject.getX(), pointInWorldToProject.getY(), pointInWorldToProject.getZ(), 0.0, 0.0, 1.0, projectedPointToPack) || !(highestZ < (height = projectedPointToPack.getZ()))) continue;
            highestZ = height;
            highestRegion = region;
            if (highestRegionToPack == null) continue;
            highestRegionToPack.set(region);
        }
        if (Double.isInfinite(highestZ)) {
            projectedPointToPack.setToNaN();
            return null;
        }
        projectedPointToPack.set(originalX, originalY, highestZ);
        return (T)highestRegion;
    }

    public static boolean isPointOnRegion(PlanarRegion region, Point3D point, double epsilon) {
        Point3D closestPoint = PlanarRegionTools.closestPointOnPlanarRegion((Point3DReadOnly)point, region);
        return closestPoint.epsilonEquals((EuclidGeometry)point, epsilon);
    }

    public static PlanarRegion createSquarePlanarRegion(float length, Point3D translation, Quaternion orientation) {
        ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
        convexPolygon.addVertex((double)(-length / 2.0f), (double)(length / 2.0f));
        convexPolygon.addVertex((double)(length / 2.0f), (double)(length / 2.0f));
        convexPolygon.addVertex((double)(length / 2.0f), (double)(-length / 2.0f));
        convexPolygon.addVertex((double)(-length / 2.0f), (double)(-length / 2.0f));
        convexPolygon.update();
        return new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)translation), (Vertex2DSupplier)convexPolygon);
    }
}

