/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class HullFace {
    private Plane3D plane = new Plane3D();
    private List<Point3D> facePoints = new ArrayList<Point3D>();
    private double slopeAngle;
    private double area;

    public HullFace(List<Point3D> points) {
        this.setPoints(points);
        this.computeAndUpdate();
    }

    public HullFace(Point3D[] points) {
        this.setPoints(Arrays.asList(points));
        this.computeAndUpdate();
    }

    public HullFace(Point3D[] points, int[] vertexIndices) {
        this.setPoints(points, vertexIndices);
        this.computeAndUpdate();
    }

    public HullFace(List<Point3D> points, int[] vertexIndices) {
        this.setPoints(points, vertexIndices);
        this.computeAndUpdate();
    }

    private void computeAndUpdate() {
        int i;
        if (this.facePoints == null || this.facePoints.size() < 3) {
            return;
        }
        this.plane.setToNaN();
        Point3D faceCenter = new Point3D();
        Vector3D planeNormal = new Vector3D();
        Point3D p0 = this.facePoints.get(0);
        Vector3D edge01 = new Vector3D();
        Vector3D edge02 = new Vector3D();
        Vector3D singleCross = new Vector3D();
        int numPoints = this.facePoints.size();
        for (i = 1; i < numPoints - 1; ++i) {
            edge01.set((Tuple3DReadOnly)this.facePoints.get(i));
            edge02.set((Tuple3DReadOnly)this.facePoints.get(i + 1));
            edge01.sub((Tuple3DReadOnly)p0);
            edge02.sub((Tuple3DReadOnly)p0);
            singleCross.cross((Tuple3DReadOnly)edge01, (Tuple3DReadOnly)edge02);
            planeNormal.add((Tuple3DReadOnly)singleCross);
        }
        planeNormal.scale(-1.0);
        this.area = planeNormal.length() / 2.0;
        planeNormal.normalize();
        this.slopeAngle = Math.acos(planeNormal.getZ());
        for (i = 0; i < numPoints; ++i) {
            faceCenter.add((Tuple3DReadOnly)this.facePoints.get(i));
        }
        faceCenter.scale(1.0 / (double)numPoints);
        this.plane.getPoint().set((Tuple3DReadOnly)faceCenter);
        this.plane.getNormal().set((Tuple3DReadOnly)planeNormal);
    }

    public double getSlopeAngle() {
        return this.slopeAngle;
    }

    public double getArea() {
        return this.area;
    }

    public void getPlane(Plane3D planeToPack) {
        planeToPack.set(this.plane);
    }

    public List<Point3D> getPoints() {
        return this.facePoints;
    }

    private void setPoints(List<Point3D> points) {
        this.facePoints = points;
    }

    public void setPoints(Point3D[] points, int[] vertexIndecies) {
        for (int i = 0; i < vertexIndecies.length; ++i) {
            int index = vertexIndecies[i];
            if (index >= points.length) {
                System.err.println(this.getClass().getSimpleName() + " Index out of bounds");
                this.facePoints.clear();
                return;
            }
            this.facePoints.add(points[index]);
        }
    }

    public void setPoints(List<Point3D> points, int[] vertexIndecies) {
        int maxIndex = points.size();
        for (int i = 0; i < vertexIndecies.length; ++i) {
            int index = vertexIndecies[i];
            if (index >= maxIndex) {
                System.err.println(this.getClass().getSimpleName() + " Index out of bounds");
                this.facePoints.clear();
                return;
            }
            this.facePoints.add(points.get(index));
        }
    }

    public void get2DPolygonAndPose(ConvexPolygon2D polygonToPack, Pose3D polygonPose) {
        if (this.facePoints.isEmpty()) {
            return;
        }
        ArrayList<Point3DBasics> projectedPoints = new ArrayList<Point3DBasics>();
        Point3D averagePoint = new Point3D();
        for (Point3D point3d : this.facePoints) {
            Point3DBasics projectedPoint = this.plane.orthogonalProjectionCopy((Point3DReadOnly)point3d);
            averagePoint.add((Tuple3DReadOnly)projectedPoint);
            projectedPoints.add(projectedPoint);
        }
        averagePoint.scale(1.0 / (double)this.facePoints.size());
        polygonPose.getPosition().set(averagePoint);
        Vector3D xVec = new Vector3D((Tuple3DReadOnly)projectedPoints.get(0));
        xVec.sub((Tuple3DReadOnly)averagePoint);
        xVec.normalize();
        Vector3D zVec = new Vector3D((Tuple3DReadOnly)this.plane.getNormal());
        Vector3D yVec = new Vector3D();
        yVec.cross((Tuple3DReadOnly)zVec, (Tuple3DReadOnly)xVec);
        yVec.normalize();
        RotationMatrix rotationMatrix = new RotationMatrix();
        rotationMatrix.setColumns((Tuple3DReadOnly)xVec, (Tuple3DReadOnly)yVec, (Tuple3DReadOnly)zVec);
        polygonPose.getOrientation().set((Orientation3DReadOnly)rotationMatrix);
        rotationMatrix.transpose();
        polygonToPack.clear();
        for (Point3DBasics point : projectedPoints) {
            point.sub((Tuple3DReadOnly)averagePoint);
            rotationMatrix.transform((Tuple3DBasics)point);
            if (Math.abs(point.getZ()) > 1.0E-14) {
                System.out.println("Error in HullFace class, failed to get polygon");
            }
            polygonToPack.addVertex(point.getX(), point.getY());
        }
        polygonToPack.update();
    }
}

