/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.List;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.Plane3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.geometry.LeastSquaresZPlaneFitter;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotQuadrant;

public class GroundPlaneEstimator {
    private static final int MAX_GROUND_PLANE_POINTS = 100;
    private final Plane3D groundPlane = new Plane3D();
    private final RecyclingArrayList<FramePoint3D> groundPlanePoints = new RecyclingArrayList(FramePoint3D.class);
    private final LeastSquaresZPlaneFitter planeFitter = new LeastSquaresZPlaneFitter();
    private final FramePose3D groundPlanePose = new FramePose3D();
    private final PoseReferenceFrame groundPlaneFrame = new PoseReferenceFrame("groundPlaneFrame", ReferenceFrame.getWorldFrame());

    public double getPitch() {
        return Math.atan2(this.groundPlane.getNormal().getX(), this.groundPlane.getNormal().getZ());
    }

    public double getRoll() {
        return Math.atan2(-this.groundPlane.getNormal().getY(), this.groundPlane.getNormal().getZ());
    }

    public double getPitch(double yaw) {
        return Math.atan2(Math.cos(yaw) * this.groundPlane.getNormal().getX() + Math.sin(yaw) * this.groundPlane.getNormal().getY(), this.groundPlane.getNormal().getZ());
    }

    public double getRoll(double yaw) {
        return Math.atan2(Math.sin(yaw) * this.groundPlane.getNormal().getX() - Math.cos(yaw) * this.groundPlane.getNormal().getY(), this.groundPlane.getNormal().getZ());
    }

    public void getPlane(Plane3D plane3dToPack) {
        plane3dToPack.set(this.groundPlane);
    }

    public Plane3DReadOnly getPlane() {
        return this.groundPlane;
    }

    public void getPlanePoint(FixedFramePoint3DBasics pointToPack) {
        pointToPack.setMatchingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.groundPlane.getPoint());
    }

    public Point3DReadOnly getPlanePoint() {
        return this.groundPlane.getPoint();
    }

    public void getPlaneNormal(FixedFrameVector3DBasics normalToPack) {
        normalToPack.setMatchingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.groundPlane.getNormal());
    }

    public Vector3DReadOnly getPlaneNormal() {
        return this.groundPlane.getNormal();
    }

    public void projectZ(FramePoint3DBasics pointToPack) {
        GroundPlaneEstimator.projectZ(pointToPack, (Plane3DReadOnly)this.groundPlane);
    }

    public static void projectZ(FramePoint3DBasics pointToPack, Plane3DReadOnly groundPlane) {
        ReferenceFrame originalFrame = pointToPack.getReferenceFrame();
        pointToPack.changeFrame(ReferenceFrame.getWorldFrame());
        pointToPack.setZ(groundPlane.getZOnPlane(pointToPack.getX(), pointToPack.getY()));
        pointToPack.changeFrame(originalFrame);
    }

    public void projectOrthogonal(FramePoint3DBasics pointToPack) {
        ReferenceFrame originalFrame = pointToPack.getReferenceFrame();
        pointToPack.changeFrame(ReferenceFrame.getWorldFrame());
        this.groundPlane.orthogonalProjection((Point3DBasics)pointToPack);
        pointToPack.changeFrame(originalFrame);
    }

    public void clearContactPoints() {
        this.groundPlanePoints.clear();
    }

    public void addContactPoint(FramePoint3DReadOnly contactPoint) {
        ((FramePoint3D)this.groundPlanePoints.add()).setMatchingFrame((FrameTuple3DReadOnly)contactPoint);
    }

    public void compute() {
        this.compute(0.0);
    }

    public void compute(double yaw) {
        this.planeFitter.fitPlaneToPoints((List<? extends Point3DReadOnly>)this.groundPlanePoints, this.groundPlane);
        this.groundPlanePose.getPosition().set((Tuple3DReadOnly)this.groundPlane.getPoint());
        this.groundPlanePose.getOrientation().setYawPitchRoll(yaw, this.getPitch(yaw), this.getRoll(yaw));
        this.groundPlaneFrame.setPoseAndUpdate((FramePose3DReadOnly)this.groundPlanePose);
    }

    public void compute(List<? extends FramePoint3DReadOnly> contactPoints) {
        this.compute(contactPoints, 0.0);
    }

    public void compute(List<? extends FramePoint3DReadOnly> contactPoints, double yaw) {
        this.groundPlanePoints.clear();
        int nPoints = Math.min(contactPoints.size(), 100);
        for (int i = 0; i < nPoints; ++i) {
            this.addContactPoint(contactPoints.get(i));
        }
        this.compute(yaw);
    }

    public void compute(QuadrantDependentList<? extends FramePoint3DReadOnly> contactPoints) {
        this.compute(contactPoints, 0.0);
    }

    public void compute(QuadrantDependentList<? extends FramePoint3DReadOnly> contactPoints, double yaw) {
        this.groundPlanePoints.clear();
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            this.addContactPoint((FramePoint3DReadOnly)contactPoints.get(robotQuadrant));
        }
        this.compute(yaw);
    }

    public PoseReferenceFrame getGroundPlaneFrame() {
        return this.groundPlaneFrame;
    }
}

