/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;

public class FramePose3DChangedTracker {
    private final FramePose3DReadOnly poseToTrack;
    private FramePose3D lastValue = null;
    private final double tolerance;

    public FramePose3DChangedTracker(FramePose3DReadOnly poseToTrack) {
        this(poseToTrack, 1.0E-4);
    }

    public FramePose3DChangedTracker(FramePose3DReadOnly poseToTrack, double tolerance) {
        this.poseToTrack = poseToTrack;
        this.tolerance = tolerance;
    }

    public boolean hasChanged() {
        if (this.lastValue == null) {
            this.lastValue = new FramePose3D(this.poseToTrack);
            return true;
        }
        this.lastValue.changeFrame(this.poseToTrack.getReferenceFrame());
        boolean hasChanged = !this.poseToTrack.geometricallyEquals((EuclidFrameGeometry)this.lastValue, this.tolerance);
        this.lastValue.setIncludingFrame(this.poseToTrack);
        return hasChanged;
    }

    public void markAsChanged() {
        this.lastValue = null;
    }
}

