/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Capsule {
    public final Point3D p1 = new Point3D();
    public final Point3D p2 = new Point3D();
    public double radius;

    public Capsule(Point3DReadOnly p1_, Point3DReadOnly p2_, double rad) {
        this.p1.set((Tuple3DReadOnly)p1_);
        this.p2.set((Tuple3DReadOnly)p2_);
        this.radius = rad;
    }

    public Capsule(Capsule other) {
        this.p1.set(other.p1);
        this.p2.set(other.p2);
        this.radius = other.radius;
    }

    public void set(Capsule other) {
        this.p1.set(other.p1);
        this.p2.set(other.p2);
        this.radius = other.radius;
    }

    public void transform(Transform trans) {
        trans.transform((Point3DBasics)this.p1);
        trans.transform((Point3DBasics)this.p2);
    }

    private static double dot(Vector3DReadOnly u, Vector3DReadOnly v) {
        return u.getX() * v.getX() + u.getY() * v.getY() + u.getZ() * v.getZ();
    }

    private static Vector3D diff(Point3DReadOnly u, Point3DReadOnly v) {
        return new Vector3D(u.getX() - v.getX(), u.getY() - v.getY(), u.getZ() - v.getZ());
    }

    private static void sum(Point3DReadOnly u, Vector3DReadOnly v, Point3DBasics res) {
        res.set(u.getX() + v.getX(), u.getY() + v.getY(), u.getZ() + v.getZ());
    }

    private static double dist(Point3DReadOnly u, Point3DReadOnly v) {
        double dx = u.getX() - v.getX();
        double dy = u.getY() - v.getY();
        double dz = u.getZ() - v.getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double distanceQuery(Capsule C1, Capsule C2, Point3DBasics dp1, Point3DBasics dp2) {
        double tN;
        double sN;
        double D;
        double SMALL_NUM = 1.0E-8;
        Vector3D u = Capsule.diff((Point3DReadOnly)C1.p2, (Point3DReadOnly)C1.p1);
        Vector3D v = Capsule.diff((Point3DReadOnly)C2.p2, (Point3DReadOnly)C2.p1);
        Vector3D w = Capsule.diff((Point3DReadOnly)C1.p1, (Point3DReadOnly)C2.p1);
        double a = Capsule.dot((Vector3DReadOnly)u, (Vector3DReadOnly)u);
        double b = Capsule.dot((Vector3DReadOnly)u, (Vector3DReadOnly)v);
        double c = Capsule.dot((Vector3DReadOnly)v, (Vector3DReadOnly)v);
        double d = Capsule.dot((Vector3DReadOnly)u, (Vector3DReadOnly)w);
        double e = Capsule.dot((Vector3DReadOnly)v, (Vector3DReadOnly)w);
        double sD = D = a * c - b * b;
        double tD = D;
        if (D < SMALL_NUM) {
            sN = 0.0;
            sD = 1.0;
            tN = e;
            tD = c;
        } else {
            sN = b * e - c * d;
            tN = a * e - b * d;
            if (sN < 0.0) {
                sN = 0.0;
                tN = e;
                tD = c;
            } else if (sN > sD) {
                sN = sD;
                tN = e + b;
                tD = c;
            }
        }
        if (tN < 0.0) {
            tN = 0.0;
            if (-d < 0.0) {
                sN = 0.0;
            } else if (-d > a) {
                sN = sD;
            } else {
                sN = -d;
                sD = a;
            }
        } else if (tN > tD) {
            tN = tD;
            if (-d + b < 0.0) {
                sN = 0.0;
            } else if (-d + b > a) {
                sN = sD;
            } else {
                sN = -d + b;
                sD = a;
            }
        }
        double sc = Math.abs(sN) < SMALL_NUM ? 0.0 : sN / sD;
        double tc = Math.abs(tN) < SMALL_NUM ? 0.0 : tN / tD;
        u.scale(sc);
        Capsule.sum((Point3DReadOnly)C1.p1, (Vector3DReadOnly)u, dp1);
        v.scale(tc);
        Capsule.sum((Point3DReadOnly)C2.p1, (Vector3DReadOnly)v, dp2);
        Vector3D dP = Capsule.diff((Point3DReadOnly)dp2, (Point3DReadOnly)dp1);
        dP.normalize();
        double distance_radius_zero = Capsule.dist((Point3DReadOnly)dp1, (Point3DReadOnly)dp2);
        if (Math.abs(C1.radius) > SMALL_NUM) {
            dP.scale(C1.radius);
            dp1.add((Tuple3DReadOnly)dP);
            dP.scale(-C2.radius / C1.radius);
            dp2.add((Tuple3DReadOnly)dP);
        } else {
            dP.scale(-C2.radius);
            dp2.add((Tuple3DReadOnly)dP);
        }
        double distA = distance_radius_zero - C1.radius - C2.radius;
        double distB = Capsule.diff((Point3DReadOnly)dp1, (Point3DReadOnly)dp2).length();
        double distC = Capsule.dist((Point3DReadOnly)dp1, (Point3DReadOnly)dp2);
        return distance_radius_zero - C1.radius - C2.radius;
    }
}

