/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.functionApproximation.NeuralNetwork;

import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import us.ihmc.robotics.functionApproximation.NeuralNetwork.activationFunction.ActivationFunction;

public class Neuron {
    private final ArrayList<Neuron> inputs = new ArrayList();
    private final TObjectDoubleHashMap<Neuron> weights = new TObjectDoubleHashMap();
    private final ActivationFunction activationFunction;
    private double output = 0.0;
    private double bias = 0.0;

    public Neuron(ActivationFunction activationFunction, double bias) {
        this.activationFunction = activationFunction;
        this.bias = bias;
    }

    public void addInputNeuron(Neuron neuron, double weight) {
        this.inputs.add(neuron);
        this.weights.put((Object)neuron, weight);
    }

    public void compute() {
        double sum = this.bias;
        for (int i = 0; i < this.inputs.size(); ++i) {
            Neuron neuron = this.inputs.get(i);
            double weight = this.weights.get((Object)neuron);
            sum += neuron.getOutput() * weight;
        }
        this.output = this.activationFunction.computeOutput(sum);
    }

    public void setBias(double bias) {
        this.bias = bias;
    }

    public double getOutput() {
        return this.output;
    }
}

