/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.dataStructures.validation;

import java.lang.reflect.Field;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableThreadAccessValidator {
    private static final boolean DEBUG = false;
    private final YoRegistry root;
    private Thread accessorThread = null;
    private static boolean REGISTERED_ACCESS_VALIDATOR = false;

    public static void registerAccessValidator() {
        ClassPool pool = ClassPool.getDefault();
        try {
            CtClass yoVariable = pool.get("us.ihmc.simulationconstructionset.YoVariable");
            CtClass yoVariableThreadAccessValidator = pool.get(YoVariableThreadAccessValidator.class.getCanonicalName());
            CtField validatorField = new CtField(yoVariableThreadAccessValidator, "validator", yoVariable);
            validatorField.setModifiers(1);
            yoVariable.addField(validatorField, "null");
            yoVariable.toClass();
            CtClass doubleYoVariable = pool.get("us.ihmc.simulationconstructionset.YoDouble");
            CtMethod method = doubleYoVariable.getDeclaredMethod("getDoubleValue");
            method.insertBefore("if(validator != null) { validator.validateReadAccess(this); }");
            doubleYoVariable.toClass();
            REGISTERED_ACCESS_VALIDATOR = true;
        }
        catch (CannotCompileException | NotFoundException e) {
            e.printStackTrace();
        }
    }

    public YoVariableThreadAccessValidator(YoRegistry root) {
        this.root = root;
    }

    public void validateReadAccess(YoVariable v) {
        Thread currentThread = Thread.currentThread();
        switch (currentThread.getName()) {
            case "AWT-EventQueue-0": 
            case "SCS simulation thread": 
            case "CombinedVarPanelTimer": {
                return;
            }
        }
        if (this.accessorThread == null) {
            this.accessorThread = currentThread;
        }
        if (!currentThread.equals(this.accessorThread)) {
            try {
                throw new Exception("Variable " + v.getFullNameString() + " read by thread " + String.valueOf(currentThread) + ", expected: " + String.valueOf(this.accessorThread));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void testAccess(YoVariable v) {
        Thread currentThread = Thread.currentThread();
        switch (currentThread.getName()) {
            case "AWT-EventQueue-0": 
            case "SCS simulation thread": {
                System.out.println("[" + this.getClass().getSimpleName() + "] Variable " + v.getName() + " was changed from the UI.");
                return;
            }
        }
        if (this.accessorThread == null) {
            this.accessorThread = currentThread;
        }
        if (!currentThread.equals(this.accessorThread)) {
            try {
                throw new Exception("Variable " + v.getFullNameString() + " changed by thread " + String.valueOf(currentThread) + ", expected: " + String.valueOf(this.accessorThread));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void start() {
        List variables = this.root.collectSubtreeVariables();
        Field validator = null;
        if (REGISTERED_ACCESS_VALIDATOR) {
            try {
                validator = YoVariable.class.getField("validator");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        for (int i = 0; i < variables.size(); ++i) {
            YoVariable yoVariable = (YoVariable)variables.get(i);
            yoVariable.addListener(new YoVariableChangedListener(){

                public void changed(YoVariable v) {
                    YoVariableThreadAccessValidator.this.testAccess(v);
                }
            });
            if (validator == null) continue;
            try {
                validator.set(yoVariable, this);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

