/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains.implementations;

import us.ihmc.commons.MathTools;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPDGains;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoPIDGains
extends YoPDGains
implements PIDGainsReadOnly {
    private final YoDouble ki;
    private final YoDouble maxIntegralError;
    private final YoDouble integralLeakRatio;

    public YoPIDGains(String suffix, YoRegistry registry) {
        super(suffix, registry);
        this.ki = new YoDouble("ki" + suffix, registry);
        this.maxIntegralError = new YoDouble("maxIntegralError" + suffix, registry);
        this.integralLeakRatio = new YoDouble("integralLeakRatio" + suffix, registry);
        this.integralLeakRatio.set(1.0);
    }

    public void setPIDGains(double kp, double zeta, double ki, double maxIntegralError) {
        this.setPDGains(kp, zeta);
        this.ki.set(ki);
        this.maxIntegralError.set(maxIntegralError);
    }

    public void setKi(double ki) {
        this.ki.set(ki);
    }

    public void setMaximumIntegralError(double maxIntegralError) {
        this.maxIntegralError.set(maxIntegralError);
    }

    public void setIntegralLeakRatio(double integralLeakRatio) {
        this.integralLeakRatio.set(MathTools.clamp((double)integralLeakRatio, (double)0.0, (double)1.0));
    }

    @Override
    public double getKi() {
        return this.ki.getDoubleValue();
    }

    @Override
    public double getMaxIntegralError() {
        return this.maxIntegralError.getDoubleValue();
    }

    @Override
    public double getIntegralLeakRatio() {
        return this.integralLeakRatio.getDoubleValue();
    }

    public YoDouble getYoKi() {
        return this.ki;
    }

    public YoDouble getYoMaxIntegralError() {
        return this.maxIntegralError;
    }

    public YoDouble getYoIntegralLeakRatio() {
        return this.integralLeakRatio;
    }

    public void set(YoPIDGains other) {
        super.set(other);
        this.ki.set(other.ki.getDoubleValue());
        this.maxIntegralError.set(other.maxIntegralError.getDoubleValue());
        this.integralLeakRatio.set(other.integralLeakRatio.getDoubleValue());
    }

    public void set(PIDGainsReadOnly pidGains) {
        super.set(pidGains);
        this.setKi(pidGains.getKi());
        this.setMaximumIntegralError(pidGains.getMaxIntegralError());
        this.setIntegralLeakRatio(pidGains.getIntegralLeakRatio());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PIDGainsReadOnly) {
            return PIDGainsReadOnly.super.equals((PIDGainsReadOnly)object);
        }
        return false;
    }
}

