/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains.implementations;

import us.ihmc.robotics.controllers.pidGains.implementations.YoPIDGains;
import us.ihmc.yoVariables.filters.RateLimitedYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoLimitedPIDGains
extends YoPIDGains {
    private final RateLimitedYoVariable limitedKp;
    private final RateLimitedYoVariable limitedKi;
    private final RateLimitedYoVariable limitedKd;
    private final YoDouble maxKpRate;
    private final YoDouble maxKiRate;
    private final YoDouble maxKdRate;

    public YoLimitedPIDGains(String suffix, double controlDT, YoRegistry registry) {
        super(suffix, registry);
        this.maxKpRate = new YoDouble("maxKpRate" + suffix, registry);
        this.maxKdRate = new YoDouble("maxKdRate" + suffix, registry);
        this.maxKiRate = new YoDouble("maxKiRate" + suffix, registry);
        this.limitedKi = new RateLimitedYoVariable("limitedKi" + suffix, registry, (DoubleProvider)this.maxKiRate, (DoubleProvider)super.getYoKi(), controlDT);
        this.limitedKp = new RateLimitedYoVariable("limitedKp" + suffix, registry, (DoubleProvider)this.maxKpRate, (DoubleProvider)super.getYoKp(), controlDT);
        this.limitedKd = new RateLimitedYoVariable("limitedKd" + suffix, registry, (DoubleProvider)this.maxKdRate, (DoubleProvider)super.getYoKd(), controlDT);
        this.maxKpRate.set(Double.POSITIVE_INFINITY);
        this.maxKdRate.set(Double.POSITIVE_INFINITY);
        this.maxKiRate.set(Double.POSITIVE_INFINITY);
    }

    public void setMaxKiRate(double maxKiRate) {
        this.maxKiRate.set(maxKiRate);
    }

    public void setMaxKpRate(double maxKpRate) {
        this.maxKpRate.set(maxKpRate);
    }

    public void setMaxKdRate(double maxKdRate) {
        this.maxKdRate.set(maxKdRate);
    }

    @Override
    public double getKp() {
        return this.limitedKp.getDoubleValue();
    }

    @Override
    public double getKd() {
        return this.limitedKd.getDoubleValue();
    }

    @Override
    public double getKi() {
        return this.limitedKi.getDoubleValue();
    }

    @Override
    public YoDouble getYoKp() {
        return this.limitedKp;
    }

    @Override
    public YoDouble getYoKd() {
        return this.limitedKd;
    }

    @Override
    public YoDouble getYoKi() {
        return this.limitedKi;
    }

    public RateLimitedYoVariable getLimitedYoKp() {
        return this.limitedKp;
    }

    public RateLimitedYoVariable getLimitedYoKd() {
        return this.limitedKd;
    }

    public RateLimitedYoVariable getLimitedYoKi() {
        return this.limitedKi;
    }
}

