/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains.implementations;

import us.ihmc.robotics.controllers.pidGains.implementations.YoPDGains;
import us.ihmc.yoVariables.filters.RateLimitedYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoLimitedPDGains
extends YoPDGains {
    private final RateLimitedYoVariable limitedKp;
    private final RateLimitedYoVariable limitedKd;
    private final YoDouble maxKpRate;
    private final YoDouble maxKdRate;

    public YoLimitedPDGains(String suffix, double controlDT, YoRegistry registry) {
        super(suffix, registry);
        this.maxKpRate = new YoDouble("maxKpRate" + suffix, registry);
        this.maxKdRate = new YoDouble("maxKdRate" + suffix, registry);
        this.limitedKp = new RateLimitedYoVariable("limitedKp" + suffix, registry, (DoubleProvider)this.maxKpRate, (DoubleProvider)super.getYoKp(), controlDT);
        this.limitedKd = new RateLimitedYoVariable("limitedKd" + suffix, registry, (DoubleProvider)this.maxKdRate, (DoubleProvider)super.getYoKd(), controlDT);
        this.maxKpRate.set(Double.POSITIVE_INFINITY);
        this.maxKdRate.set(Double.POSITIVE_INFINITY);
    }

    public void setMaxKpRate(double maxKpRate) {
        this.maxKpRate.set(maxKpRate);
    }

    public void setMaxKdRate(double maxKdRate) {
        this.maxKdRate.set(maxKdRate);
    }

    @Override
    public double getKp() {
        return this.limitedKp.getDoubleValue();
    }

    @Override
    public double getKd() {
        return this.limitedKd.getDoubleValue();
    }

    @Override
    public YoDouble getYoKp() {
        return this.limitedKp;
    }

    @Override
    public YoDouble getYoKd() {
        return this.limitedKd;
    }
}

