/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains;

import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;

public interface PID3DGains
extends PID3DGainsReadOnly {
    public void setProportionalGains(double var1, double var3, double var5);

    public void setDerivativeGains(double var1, double var3, double var5);

    public void setIntegralGains(double var1, double var3, double var5, double var7);

    public void setMaxFeedbackAndFeedbackRate(double var1, double var3);

    public void setMaxDerivativeError(double var1);

    public void setMaxProportionalError(double var1);

    default public void setProportionalGains(double[] proportionalGains) {
        PID3DGainsReadOnly.checkArrayLength(proportionalGains);
        this.setProportionalGains(proportionalGains[0], proportionalGains[1], proportionalGains[2]);
    }

    default public void setProportionalGains(Tuple3DReadOnly proportionalGains) {
        this.setProportionalGains(proportionalGains.getX(), proportionalGains.getY(), proportionalGains.getZ());
    }

    default public void setDerivativeGains(double[] derivativeGains) {
        PID3DGainsReadOnly.checkArrayLength(derivativeGains);
        this.setDerivativeGains(derivativeGains[0], derivativeGains[1], derivativeGains[2]);
    }

    default public void setDerivativeGains(Tuple3DReadOnly derivativeGains) {
        this.setDerivativeGains(derivativeGains.getX(), derivativeGains.getY(), derivativeGains.getZ());
    }

    default public void setIntegralGains(double[] integralGains, double maxIntegralError) {
        PID3DGainsReadOnly.checkArrayLength(integralGains);
        this.setIntegralGains(integralGains[0], integralGains[1], integralGains[2], maxIntegralError);
    }

    default public void setIntegralGains(Tuple3DReadOnly integralGains, double maxIntegralError) {
        this.setIntegralGains(integralGains.getX(), integralGains.getY(), integralGains.getZ(), maxIntegralError);
    }

    default public void setProportionalGains(double proportionalGain) {
        this.setProportionalGains(proportionalGain, proportionalGain, proportionalGain);
    }

    default public void setDerivativeGains(double derivativeGain) {
        this.setDerivativeGains(derivativeGain, derivativeGain, derivativeGain);
    }

    default public void setIntegralGains(double integralGain, double maxIntegralError) {
        this.setIntegralGains(integralGain, integralGain, integralGain, maxIntegralError);
    }

    default public void setProportialAndDerivativeGains(double proportionalGain, double derivativeGain) {
        this.setProportionalGains(proportionalGain);
        this.setDerivativeGains(derivativeGain);
    }

    default public void setGains(double proportionalGain, double derivativeGain, double integralGain, double maxIntegralError) {
        this.setProportionalGains(proportionalGain);
        this.setDerivativeGains(derivativeGain);
        this.setIntegralGains(integralGain, maxIntegralError);
    }

    default public void set(PID3DGainsReadOnly other) {
        this.setProportionalGains(other.getProportionalGains());
        this.setDerivativeGains(other.getDerivativeGains());
        this.setIntegralGains(other.getIntegralGains(), other.getMaximumIntegralError());
        this.setMaxFeedbackAndFeedbackRate(other.getMaximumFeedback(), other.getMaximumFeedbackRate());
        this.setMaxDerivativeError(other.getMaximumDerivativeError());
        this.setMaxProportionalError(other.getMaximumProportionalError());
    }
}

