/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.commons.MathTools;
import us.ihmc.robotics.controllers.AbstractPIDController;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPIDGains;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class PIDController
extends AbstractPIDController {
    private final YoDouble proportionalGain;
    private final YoDouble integralGain;
    private final YoDouble derivativeGain;
    private final YoDouble positionDeadband;
    private final YoDouble maxIntegralError;
    private final YoDouble maxFeedback;
    private final YoDouble integralLeakRatio;

    public PIDController(String suffix, YoRegistry registry) {
        this(new YoDouble("kp_" + suffix, registry), new YoDouble("ki_" + suffix, registry), new YoDouble("kd_" + suffix, registry), new YoDouble("maxIntegralError_" + suffix, registry), suffix, registry);
        this.proportionalGain.set(0.0);
        this.integralGain.set(0.0);
        this.derivativeGain.set(0.0);
        this.maxIntegralError.set(Double.POSITIVE_INFINITY);
    }

    public PIDController(YoDouble proportionalGain, YoDouble integralGain, YoDouble derivativeGain, YoDouble maxIntegralError, String suffix, YoRegistry registry) {
        this(proportionalGain, integralGain, derivativeGain, new YoDouble("positionDeadband_" + suffix, registry), maxIntegralError, new YoDouble("maxOutput_" + suffix, registry), new YoDouble("leak_" + suffix, registry), suffix, registry);
        this.positionDeadband.set(0.0);
        this.maxFeedback.set(Double.POSITIVE_INFINITY);
        this.integralLeakRatio.set(1.0);
    }

    public PIDController(YoPIDGains yoPIDGains, String suffix, YoRegistry registry) {
        this(yoPIDGains.getYoKp(), yoPIDGains.getYoKi(), yoPIDGains.getYoKd(), yoPIDGains.getYoPositionDeadband(), yoPIDGains.getYoMaxIntegralError(), yoPIDGains.getYoMaximumFeedback(), yoPIDGains.getYoIntegralLeakRatio(), suffix, registry);
    }

    public PIDController(YoDouble proportionalGain, YoDouble integralGain, YoDouble derivativeGain, YoDouble positionDeadband, YoDouble maxIntegralError, YoDouble maxFeedback, YoDouble integralLeakRatio, String suffix, YoRegistry registry) {
        super((DoubleProvider)proportionalGain, (DoubleProvider)integralGain, (DoubleProvider)derivativeGain, (DoubleProvider)positionDeadband, (DoubleProvider)maxIntegralError, (DoubleProvider)maxFeedback, (DoubleProvider)integralLeakRatio, suffix, registry);
        this.proportionalGain = (YoDouble)((AbstractPIDController)this).proportionalGain;
        this.integralGain = (YoDouble)((AbstractPIDController)this).integralGain;
        this.derivativeGain = (YoDouble)((AbstractPIDController)this).derivativeGain;
        this.positionDeadband = (YoDouble)((AbstractPIDController)this).positionDeadband;
        this.maxIntegralError = (YoDouble)((AbstractPIDController)this).maxIntegralError;
        this.maxFeedback = (YoDouble)((AbstractPIDController)this).maxFeedback;
        this.integralLeakRatio = (YoDouble)((AbstractPIDController)this).integralLeakRatio;
        this.addLeakRatioClipper();
    }

    private void addLeakRatioClipper() {
        YoVariableChangedListener leakRatioClipper = new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                PIDController.this.integralLeakRatio.set(MathTools.clamp((double)PIDController.this.integralLeakRatio.getDoubleValue(), (double)0.0, (double)1.0), false);
            }
        };
        this.integralLeakRatio.addListener(leakRatioClipper);
    }

    public void setMaximumOutputLimit(double max) {
        if (max <= 0.0) {
            this.maxFeedback.set(Double.POSITIVE_INFINITY);
        } else {
            this.maxFeedback.set(max);
        }
    }

    public void setProportionalGain(double proportionalGain) {
        this.proportionalGain.set(proportionalGain);
    }

    public void setDerivativeGain(double derivativeGain) {
        this.derivativeGain.set(derivativeGain);
    }

    public void setPositionDeadband(double deadband) {
        this.positionDeadband.set(deadband);
    }

    public void setIntegralGain(double integralGain) {
        this.integralGain.set(integralGain);
    }

    public void setIntegralLeakRatio(double integralLeakRatio) {
        this.integralLeakRatio.set(MathTools.clamp((double)integralLeakRatio, (double)0.0, (double)1.0));
    }

    public void setMaxIntegralError(double maxIntegralError) {
        this.maxIntegralError.set(maxIntegralError);
    }

    public void setGains(PIDGainsReadOnly gains) {
        this.setProportionalGain(gains.getKp());
        this.setDerivativeGain(gains.getKd());
        this.setPositionDeadband(gains.getPositionDeadband());
        this.setMaximumOutputLimit(gains.getMaximumFeedback());
        this.setIntegralLeakRatio(gains.getIntegralLeakRatio());
        this.setIntegralGain(gains.getKi());
        this.setMaxIntegralError(gains.getMaxIntegralError());
    }
}

