/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.robotics.controllers.pidGains.GainCoupling;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.YoPID3DGains;
import us.ihmc.robotics.controllers.pidGains.implementations.DefaultYoPID3DGains;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.yoVariables.euclid.filters.RateLimitedYoFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class AxisAngleOrientationController {
    private final YoRegistry registry;
    private final YoFrameVector3D rotationErrorInBody;
    private final YoFrameVector3D rotationErrorCumulated;
    private final YoFrameVector3D velocityError;
    private final Matrix3D tempGainMatrix = new Matrix3D();
    private final ReferenceFrame bodyFrame;
    private final FrameVector3D proportionalTerm;
    private final FrameVector3D derivativeTerm;
    private final FrameVector3D integralTerm;
    private final FrameQuaternion desiredOrientation = new FrameQuaternion();
    private final FrameVector3D desiredAngularVelocity = new FrameVector3D();
    private final FrameVector3D feedForwardAngularAction = new FrameVector3D();
    private final FrameVector3D angularActionFromOrientationController = new FrameVector3D();
    private final AxisAngle errorAngleAxis = new AxisAngle();
    private final Quaternion errorQuaternion = new Quaternion();
    private final YoFrameVector3D feedbackAngularAction;
    private final RateLimitedYoFrameVector3D rateLimitedFeedbackAngularAction;
    private final double dt;
    private final YoPID3DGains gains;

    public AxisAngleOrientationController(String prefix, ReferenceFrame bodyFrame, double dt, YoRegistry parentRegistry) {
        this(prefix, bodyFrame, dt, null, parentRegistry);
    }

    public AxisAngleOrientationController(String prefix, ReferenceFrame bodyFrame, double dt, YoPID3DGains gains, YoRegistry parentRegistry) {
        this.dt = dt;
        this.bodyFrame = bodyFrame;
        this.registry = new YoRegistry(prefix + this.getClass().getSimpleName());
        if (gains == null) {
            gains = new DefaultYoPID3DGains(prefix, GainCoupling.NONE, true, this.registry);
        }
        this.gains = gains;
        this.rotationErrorInBody = new YoFrameVector3D(prefix + "RotationErrorInBody", bodyFrame, this.registry);
        this.rotationErrorCumulated = new YoFrameVector3D(prefix + "RotationErrorCumulated", bodyFrame, this.registry);
        this.velocityError = new YoFrameVector3D(prefix + "AngularVelocityError", bodyFrame, this.registry);
        this.proportionalTerm = new FrameVector3D(bodyFrame);
        this.derivativeTerm = new FrameVector3D(bodyFrame);
        this.integralTerm = new FrameVector3D(bodyFrame);
        this.feedbackAngularAction = new YoFrameVector3D(prefix + "FeedbackAngularAction", bodyFrame, this.registry);
        this.rateLimitedFeedbackAngularAction = new RateLimitedYoFrameVector3D(prefix + "RateLimitedFeedbackAngularAction", "", this.registry, (DoubleProvider)gains.getYoMaximumFeedbackRate(), dt, (FrameTuple3DReadOnly)this.feedbackAngularAction);
        parentRegistry.addChild(this.registry);
    }

    public void reset() {
        this.rateLimitedFeedbackAngularAction.reset();
    }

    public void resetIntegrator() {
        this.rotationErrorCumulated.setToZero();
    }

    public void compute(FrameVector3D output, FrameQuaternion desiredOrientation, FrameVector3D desiredAngularVelocity, FrameVector3D currentAngularVelocity, FrameVector3D feedForward) {
        this.computeProportionalTerm(desiredOrientation);
        if (currentAngularVelocity != null) {
            this.computeDerivativeTerm(desiredAngularVelocity, currentAngularVelocity);
        }
        this.computeIntegralTerm();
        output.setToZero(this.proportionalTerm.getReferenceFrame());
        output.add((FrameTuple3DReadOnly)this.proportionalTerm);
        output.add((FrameTuple3DReadOnly)this.derivativeTerm);
        output.add((FrameTuple3DReadOnly)this.integralTerm);
        double feedbackAngularActionMagnitude = output.length();
        double maximumAction = this.gains.getMaximumFeedback();
        if (feedbackAngularActionMagnitude > maximumAction) {
            output.scale(maximumAction / feedbackAngularActionMagnitude);
        }
        this.feedbackAngularAction.set((FrameTuple3DReadOnly)output);
        this.rateLimitedFeedbackAngularAction.update();
        output.set((FrameTuple3DReadOnly)this.rateLimitedFeedbackAngularAction);
        feedForward.changeFrame(this.bodyFrame);
        output.add((FrameTuple3DReadOnly)feedForward);
    }

    public void compute(Twist twistToPack, FramePose3D desiredPose, TwistReadOnly desiredTwist) {
        this.checkBodyFrames(desiredTwist, (TwistReadOnly)twistToPack);
        this.checkBaseFrames(desiredTwist, (TwistReadOnly)twistToPack);
        this.checkExpressedInFrames(desiredTwist, (TwistReadOnly)twistToPack);
        twistToPack.setToZero(this.bodyFrame, desiredTwist.getBaseFrame(), this.bodyFrame);
        this.desiredOrientation.setIncludingFrame((FrameQuaternionReadOnly)desiredPose.getOrientation());
        this.desiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredTwist.getAngularPart());
        this.feedForwardAngularAction.setIncludingFrame((FrameTuple3DReadOnly)desiredTwist.getAngularPart());
        this.compute(this.angularActionFromOrientationController, this.desiredOrientation, this.desiredAngularVelocity, null, this.feedForwardAngularAction);
        twistToPack.getAngularPart().set((FrameTuple3DReadOnly)this.angularActionFromOrientationController);
    }

    private void checkBodyFrames(TwistReadOnly desiredTwist, TwistReadOnly currentTwist) {
        desiredTwist.getBodyFrame().checkReferenceFrameMatch(this.bodyFrame);
        currentTwist.getBodyFrame().checkReferenceFrameMatch(this.bodyFrame);
    }

    private void checkBaseFrames(TwistReadOnly desiredTwist, TwistReadOnly currentTwist) {
        desiredTwist.getBaseFrame().checkReferenceFrameMatch(currentTwist.getBaseFrame());
    }

    private void checkExpressedInFrames(TwistReadOnly desiredTwist, TwistReadOnly currentTwist) {
        desiredTwist.getReferenceFrame().checkReferenceFrameMatch(this.bodyFrame);
        currentTwist.getReferenceFrame().checkReferenceFrameMatch(this.bodyFrame);
    }

    private void computeProportionalTerm(FrameQuaternion desiredOrientation) {
        desiredOrientation.changeFrame(this.bodyFrame);
        this.errorQuaternion.set((QuaternionReadOnly)desiredOrientation);
        this.errorAngleAxis.set((Orientation3DReadOnly)this.errorQuaternion);
        this.errorAngleAxis.setAngle(AngleTools.trimAngleMinusPiToPi(this.errorAngleAxis.getAngle()));
        double maximumError = this.gains.getMaximumProportionalError();
        if (Math.abs(this.errorAngleAxis.getAngle()) > maximumError) {
            this.errorAngleAxis.setAngle(Math.signum(this.errorAngleAxis.getAngle()) * maximumError);
        }
        this.proportionalTerm.set(this.errorAngleAxis.getX(), this.errorAngleAxis.getY(), this.errorAngleAxis.getZ());
        this.proportionalTerm.scale(this.errorAngleAxis.getAngle());
        this.rotationErrorInBody.set((FrameTuple3DReadOnly)this.proportionalTerm);
        this.gains.getProportionalGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)this.proportionalTerm);
    }

    private void computeDerivativeTerm(FrameVector3D desiredAngularVelocity, FrameVector3D currentAngularVelocity) {
        desiredAngularVelocity.changeFrame(this.bodyFrame);
        currentAngularVelocity.changeFrame(this.bodyFrame);
        this.derivativeTerm.sub((FrameTuple3DReadOnly)desiredAngularVelocity, (FrameTuple3DReadOnly)currentAngularVelocity);
        double maximumVelocityError = this.gains.getMaximumDerivativeError();
        double velocityErrorMagnitude = this.derivativeTerm.length();
        if (velocityErrorMagnitude > maximumVelocityError) {
            this.derivativeTerm.scale(maximumVelocityError / velocityErrorMagnitude);
        }
        this.velocityError.set((FrameTuple3DReadOnly)this.derivativeTerm);
        this.gains.getDerivativeGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)this.derivativeTerm);
    }

    private void computeIntegralTerm() {
        if (this.gains.getMaximumIntegralError() < 1.0E-5) {
            this.integralTerm.setToZero(this.bodyFrame);
            return;
        }
        double integratedErrorAngle = this.errorAngleAxis.getAngle() * this.dt;
        double errorIntegratedX = this.errorAngleAxis.getX() * integratedErrorAngle;
        double errorIntegratedY = this.errorAngleAxis.getY() * integratedErrorAngle;
        double errorIntegratedZ = this.errorAngleAxis.getZ() * integratedErrorAngle;
        this.rotationErrorCumulated.add(errorIntegratedX, errorIntegratedY, errorIntegratedZ);
        double errorMagnitude = this.rotationErrorCumulated.length();
        if (errorMagnitude > this.gains.getMaximumIntegralError()) {
            this.rotationErrorCumulated.scale(this.gains.getMaximumIntegralError() / errorMagnitude);
        }
        this.integralTerm.set((FrameTuple3DReadOnly)this.rotationErrorCumulated);
        this.gains.getIntegralGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)this.integralTerm);
    }

    public void setProportionalGains(double proportionalGainX, double proportionalGainY, double proportionalGainZ) {
        this.gains.setProportionalGains(proportionalGainX, proportionalGainY, proportionalGainZ);
    }

    public void setDerivativeGains(double derivativeGainX, double derivativeGainY, double derivativeGainZ) {
        this.gains.setDerivativeGains(derivativeGainX, derivativeGainY, derivativeGainZ);
    }

    public void setIntegralGains(double integralGainX, double integralGainY, double integralGainZ, double maxIntegralError) {
        this.gains.setIntegralGains(integralGainX, integralGainY, integralGainZ, maxIntegralError);
    }

    public void setProportionalGains(double[] proportionalGains) {
        this.gains.setProportionalGains(proportionalGains);
    }

    public void setDerivativeGains(double[] derivativeGains) {
        this.gains.setDerivativeGains(derivativeGains);
    }

    public void setIntegralGains(double[] integralGains, double maxIntegralError) {
        this.gains.setIntegralGains(integralGains, maxIntegralError);
    }

    public void setMaxFeedbackAndFeedbackRate(double maxFeedback, double maxFeedbackRate) {
        this.gains.setMaxFeedbackAndFeedbackRate(maxFeedback, maxFeedbackRate);
    }

    public void setMaxDerivativeError(double maxDerivativeError) {
        this.gains.setMaxDerivativeError(maxDerivativeError);
    }

    public void setMaxProportionalError(double maxProportionalError) {
        this.gains.setMaxProportionalError(maxProportionalError);
    }

    public void setGains(PID3DGainsReadOnly gains) {
        this.gains.set(gains);
    }
}

