/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.commons.MathTools;
import us.ihmc.robotics.controllers.AbstractPDController;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class AbstractPIDController
extends AbstractPDController {
    private final YoDouble cumulativeError;
    private final YoDouble actionI;
    protected final DoubleProvider integralGain;
    protected final DoubleProvider maxIntegralError;
    protected final DoubleProvider maxFeedback;
    protected final DoubleProvider integralLeakRatio;

    protected AbstractPIDController(DoubleProvider proportionalGain, DoubleProvider integralGain, DoubleProvider derivativeGain, DoubleProvider positionDeadband, DoubleProvider maxIntegralError, DoubleProvider maxFeedback, DoubleProvider integralLeakRatio, String suffix, YoRegistry registry) {
        super(proportionalGain, derivativeGain, positionDeadband, suffix, registry);
        this.integralGain = integralGain;
        this.maxIntegralError = maxIntegralError;
        this.maxFeedback = maxFeedback;
        this.integralLeakRatio = integralLeakRatio;
        this.cumulativeError = new YoDouble("cumulativeError_" + suffix, registry);
        this.cumulativeError.set(0.0);
        this.actionI = new YoDouble("action_I_" + suffix, registry);
        this.actionI.set(0.0);
    }

    public double getMaximumFeedback() {
        return this.maxFeedback.getValue();
    }

    public double getIntegralGain() {
        return this.integralGain.getValue();
    }

    public double getMaxIntegralError() {
        return this.maxIntegralError.getValue();
    }

    public double getIntegralLeakRatio() {
        return this.integralLeakRatio.getValue();
    }

    public double getCumulativeError() {
        return this.cumulativeError.getDoubleValue();
    }

    public void setCumulativeError(double error) {
        this.cumulativeError.set(error);
    }

    public void resetIntegrator() {
        this.cumulativeError.set(0.0);
    }

    public double compute(double currentPosition, double desiredPosition, double currentRate, double desiredRate, double deltaTime) {
        super.compute(currentPosition, desiredPosition, currentRate, desiredRate);
        return this.computeIntegralEffortAndAddPDEffort(deltaTime);
    }

    public double computeForAngles(double currentPosition, double desiredPosition, double currentRate, double desiredRate, double deltaTime) {
        super.computeForAngles(currentPosition, desiredPosition, currentRate, desiredRate);
        return this.computeIntegralEffortAndAddPDEffort(deltaTime);
    }

    private double computeIntegralEffortAndAddPDEffort(double deltaTime) {
        double outputSignal = this.actionP.getDoubleValue() + this.actionD.getDoubleValue();
        if (this.integralGain.getValue() < 1.0E-5) {
            this.cumulativeError.set(0.0);
        } else {
            double maxError = this.maxIntegralError.getValue();
            double errorAfterLeak = this.positionError.getDoubleValue() * deltaTime + this.integralLeakRatio.getValue() * this.cumulativeError.getDoubleValue();
            this.cumulativeError.set(MathTools.clamp((double)errorAfterLeak, (double)maxError));
            this.actionI.set(this.integralGain.getValue() * this.cumulativeError.getDoubleValue());
            outputSignal += this.actionI.getDoubleValue();
        }
        double maximumOutput = Math.abs(this.maxFeedback.getValue());
        outputSignal = MathTools.clamp((double)outputSignal, (double)maximumOutput);
        return outputSignal;
    }
}

