/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.commons.DeadbandTools;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class AbstractPDController {
    protected final YoDouble positionError;
    protected final YoDouble rateError;
    protected final YoDouble actionP;
    protected final YoDouble actionD;
    protected final DoubleProvider proportionalGain;
    protected final DoubleProvider derivativeGain;
    protected final DoubleProvider positionDeadband;

    protected AbstractPDController(DoubleProvider proportionalGain, DoubleProvider derivativeGain, DoubleProvider positionDeadband, String suffix, YoRegistry registry) {
        this.proportionalGain = proportionalGain;
        this.derivativeGain = derivativeGain;
        this.positionDeadband = positionDeadband;
        this.positionError = new YoDouble("positionError_" + suffix, registry);
        this.positionError.set(0.0);
        this.rateError = new YoDouble("rateError_" + suffix, registry);
        this.rateError.set(0.0);
        this.actionP = new YoDouble("action_P_" + suffix, registry);
        this.actionP.set(0.0);
        this.actionD = new YoDouble("action_D_" + suffix, registry);
        this.actionD.set(0.0);
    }

    public double getProportionalGain() {
        return this.proportionalGain.getValue();
    }

    public double getDerivativeGain() {
        return this.derivativeGain.getValue();
    }

    public double getPositionDeadband() {
        return this.positionDeadband.getValue();
    }

    public double getPositionError() {
        return this.positionError.getDoubleValue();
    }

    public double getRateError() {
        return this.rateError.getDoubleValue();
    }

    public double compute(double currentPosition, double desiredPosition, double currentRate, double desiredRate) {
        this.positionError.set(DeadbandTools.applyDeadband((double)this.positionDeadband.getValue(), (double)(desiredPosition - currentPosition)));
        this.rateError.set(desiredRate - currentRate);
        this.actionP.set(this.proportionalGain.getValue() * this.positionError.getDoubleValue());
        this.actionD.set(this.derivativeGain.getValue() * this.rateError.getDoubleValue());
        return this.actionP.getDoubleValue() + this.actionD.getDoubleValue();
    }

    public double computeForAngles(double currentPosition, double desiredPosition, double currentRate, double desiredRate) {
        this.positionError.set(DeadbandTools.applyDeadband((double)this.positionDeadband.getValue(), (double)AngleTools.computeAngleDifferenceMinusPiToPi(desiredPosition, currentPosition)));
        this.rateError.set(desiredRate - currentRate);
        this.actionP.set(this.proportionalGain.getValue() * this.positionError.getDoubleValue());
        this.actionD.set(this.derivativeGain.getValue() * this.rateError.getDoubleValue());
        return this.actionP.getDoubleValue() + this.actionD.getDoubleValue();
    }
}

