/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.multiBodySystem.CrossFourBarJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class MultiBodySystemMissingTools {
    public static void copyOneDoFJointsConfiguration(JointBasics[] source, JointBasics[] destination) {
        OneDoFJointBasics[] oneDofJoints2;
        OneDoFJointBasics[] oneDofJoints1 = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])source, OneDoFJointBasics.class);
        if (oneDofJoints1.length != (oneDofJoints2 = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])destination, OneDoFJointBasics.class)).length) {
            throw new IllegalArgumentException("The lists of joints must be the same length. %d != %d".formatted(oneDofJoints1.length, oneDofJoints2.length));
        }
        for (int i = 0; i < oneDofJoints1.length; ++i) {
            oneDofJoints2[i].setJointConfiguration((OneDoFJointReadOnly)oneDofJoints1[i]);
        }
    }

    public static RigidBodyBasics getDetachedCopyOfSubtreeWithElevator(RigidBodyBasics rootBodyToDetach) {
        RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
        SixDoFJoint floatingJoint = new SixDoFJoint(rootBodyToDetach.getName(), (RigidBodyBasics)elevator);
        RigidBodyBasics clonedRootBody = MultiBodySystemFactories.DEFAULT_RIGID_BODY_BUILDER.cloneRigidBody((RigidBodyReadOnly)rootBodyToDetach, null, "", (JointBasics)floatingJoint);
        MultiBodySystemMissingTools.cloneSubtree((RigidBodyReadOnly)rootBodyToDetach, clonedRootBody, "", null);
        return elevator;
    }

    public static RigidBodyBasics getDetachedCopyOfSubtreeWithElevator(RigidBodyBasics rootBodyToDetach, OneDoFJointBasics childJointToFollow, @Nullable String endRigidBodyName) {
        RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
        SixDoFJoint floatingJoint = new SixDoFJoint(rootBodyToDetach.getName(), (RigidBodyBasics)elevator);
        RigidBodyBasics clonedChest = MultiBodySystemFactories.DEFAULT_RIGID_BODY_BUILDER.cloneRigidBody((RigidBodyReadOnly)rootBodyToDetach, null, "", (JointBasics)floatingJoint);
        JointBasics clonedFirstShoulderJoint = MultiBodySystemFactories.DEFAULT_JOINT_BUILDER.cloneJoint((JointReadOnly)childJointToFollow, "", clonedChest);
        RigidBodyBasics clonedFirstShoulderLink = MultiBodySystemFactories.DEFAULT_RIGID_BODY_BUILDER.cloneRigidBody((RigidBodyReadOnly)childJointToFollow.getSuccessor(), null, "", clonedFirstShoulderJoint);
        MultiBodySystemMissingTools.cloneSubtree((RigidBodyReadOnly)childJointToFollow.getSuccessor(), clonedFirstShoulderLink, "", endRigidBodyName);
        return elevator;
    }

    public static RigidBodyBasics getDetachedCopyOfSubtree(RigidBodyBasics rootBodyToDetach, @Nullable ReferenceFrame cloneStationaryFrame, OneDoFJointBasics childJointToFollow, @Nullable String endRigidBodyName) {
        RigidBodyBasics clonedChest = MultiBodySystemFactories.DEFAULT_RIGID_BODY_BUILDER.cloneRigidBody((RigidBodyReadOnly)rootBodyToDetach, cloneStationaryFrame, "", null);
        JointBasics clonedFirstShoulderJoint = MultiBodySystemFactories.DEFAULT_JOINT_BUILDER.cloneJoint((JointReadOnly)childJointToFollow, "", clonedChest);
        RigidBodyBasics clonedFirstShoulderLink = MultiBodySystemFactories.DEFAULT_RIGID_BODY_BUILDER.cloneRigidBody((RigidBodyReadOnly)childJointToFollow.getSuccessor(), null, "", clonedFirstShoulderJoint);
        MultiBodySystemMissingTools.cloneSubtree((RigidBodyReadOnly)childJointToFollow.getSuccessor(), clonedFirstShoulderLink, "", endRigidBodyName);
        return clonedChest;
    }

    private static void cloneSubtree(RigidBodyReadOnly originalStart, RigidBodyBasics cloneStart, String cloneSuffix, String endRigidBodyName) {
        MultiBodySystemFactories.RigidBodyBuilder rigidBodyBuilder = MultiBodySystemFactories.DEFAULT_RIGID_BODY_BUILDER;
        MultiBodySystemFactories.JointBuilder jointBuilder = MultiBodySystemFactories.DEFAULT_JOINT_BUILDER;
        HashMap<String, RigidBodyBasics> originalToCloneBodyMap = new HashMap<String, RigidBodyBasics>();
        originalToCloneBodyMap.put(originalStart.getName(), cloneStart);
        ArrayList<JointBasics> loopClosureCloneJoints = new ArrayList<JointBasics>();
        ArrayList<JointReadOnly> loopClosureOriginalJoints = new ArrayList<JointReadOnly>();
        for (JointReadOnly originalJoint : originalStart.childrenSubtreeIterable()) {
            RigidBodyReadOnly originalPredecessor = originalJoint.getPredecessor();
            if (endRigidBodyName != null && originalPredecessor.getName().equals(endRigidBodyName)) break;
            RigidBodyBasics clonePredecessor = (RigidBodyBasics)originalToCloneBodyMap.get(originalPredecessor.getName());
            JointBasics cloneJoint = jointBuilder.cloneJoint(originalJoint, cloneSuffix, clonePredecessor);
            if (originalJoint.isLoopClosure()) {
                loopClosureCloneJoints.add(cloneJoint);
                loopClosureOriginalJoints.add(originalJoint);
                continue;
            }
            RigidBodyReadOnly originalSuccessor = originalJoint.getSuccessor();
            RigidBodyBasics cloneSuccessor = rigidBodyBuilder.cloneRigidBody(originalSuccessor, null, cloneSuffix, cloneJoint);
            originalToCloneBodyMap.put(originalSuccessor.getName(), cloneSuccessor);
        }
        for (int loopClosureIndex = 0; loopClosureIndex < loopClosureCloneJoints.size(); ++loopClosureIndex) {
            JointBasics cloneJoint = (JointBasics)loopClosureCloneJoints.get(loopClosureIndex);
            JointReadOnly originalJoint = (JointReadOnly)loopClosureOriginalJoints.get(loopClosureIndex);
            RigidBodyBasics cloneSuccessor = (RigidBodyBasics)originalToCloneBodyMap.get(originalJoint.getSuccessor().getName());
            RigidBodyTransform cloneTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)originalJoint.getLoopClosureFrame().getTransformToParent());
            cloneTransform.invert();
            cloneJoint.setupLoopClosure(cloneSuccessor, (RigidBodyTransformReadOnly)cloneTransform);
        }
    }

    public static <J extends JointReadOnly> J[] getSubtreeJointArray(Class<J> jointTypeFilter, RigidBodyReadOnly start) {
        ArrayList joints = new ArrayList();
        SubtreeStreams.fromChildren(jointTypeFilter, (RigidBodyReadOnly)start).forEach(joints::add);
        return joints.toArray((JointReadOnly[])Array.newInstance(jointTypeFilter, 0));
    }

    public static List<JointBasics> getSubtreeJointsIncludingFourBars(RigidBodyBasics rootBody) {
        ArrayList<JointBasics> joints = new ArrayList<JointBasics>();
        for (JointBasics joint : rootBody.childrenSubtreeIterable()) {
            if (joint instanceof CrossFourBarJoint) {
                joints.addAll(((CrossFourBarJoint)joint).getFourBarFunction().getLoopJoints());
                continue;
            }
            joints.add(joint);
        }
        return joints;
    }

    public static MultiBodySystemBasics createSingleBodySystem(final RigidBodyBasics singleBody) {
        final ArrayList allJoints = new ArrayList();
        final ArrayList jointsToConsider = new ArrayList();
        final ArrayList jointsToIgnore = new ArrayList();
        final JointMatrixIndexProvider jointMatrixIndexProvider = JointMatrixIndexProvider.toIndexProvider(jointsToConsider);
        return new MultiBodySystemBasics(){

            public RigidBodyBasics getRootBody() {
                return singleBody;
            }

            public List<? extends JointBasics> getAllJoints() {
                return allJoints;
            }

            public List<? extends JointBasics> getJointsToConsider() {
                return jointsToConsider;
            }

            public List<? extends JointBasics> getJointsToIgnore() {
                return jointsToIgnore;
            }

            public JointMatrixIndexProvider getJointMatrixIndexProvider() {
                return jointMatrixIndexProvider;
            }
        };
    }

    public static double computeSubTreeMass(RigidBodyReadOnly rootBody) {
        SpatialInertiaReadOnly inertia = rootBody.getInertia();
        double ret = inertia == null ? 0.0 : inertia.getMass();
        for (int i = 0; i < rootBody.getChildrenJoints().size(); ++i) {
            ret += MultiBodySystemMissingTools.computeSubTreeMass(((JointReadOnly)rootBody.getChildrenJoints().get(i)).getSuccessor());
        }
        return ret;
    }
}

