/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics;

import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidGeometryMissingTools {
    public static double getZOnPlane(Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal, double pointX, double pointY) {
        double x0 = pointOnPlane.getX();
        double y0 = pointOnPlane.getY();
        double z0 = pointOnPlane.getZ();
        double a = planeNormal.getX();
        double b = planeNormal.getY();
        double c = planeNormal.getZ();
        double z = a / c * (x0 - pointX) + b / c * (y0 - pointY) + z0;
        return z;
    }

    public static double distanceXYFromPoint3DToLine3D(FramePoint3DReadOnly point, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine) {
        point.checkReferenceFrameMatch((ReferenceFrameHolder)firstPointOnLine);
        point.checkReferenceFrameMatch((ReferenceFrameHolder)secondPointOnLine);
        double pointOnLineX = firstPointOnLine.getX();
        double pointOnLineY = firstPointOnLine.getY();
        double lineDirectionX = secondPointOnLine.getX() - firstPointOnLine.getX();
        double lineDirectionY = secondPointOnLine.getY() - firstPointOnLine.getY();
        return EuclidGeometryTools.distanceFromPoint2DToLine2D((double)point.getX(), (double)point.getY(), (double)pointOnLineX, (double)pointOnLineY, (double)lineDirectionX, (double)lineDirectionY);
    }

    public static BoundingBox2D computeIntersectionOfTwoBoundingBoxes(BoundingBox2DReadOnly a, BoundingBox2DReadOnly b) {
        double maxX = Math.min(a.getMaxX(), b.getMaxX());
        double maxY = Math.min(a.getMaxY(), b.getMaxY());
        double minX = Math.max(a.getMinX(), b.getMinX());
        double minY = Math.max(a.getMinY(), b.getMinY());
        if (maxX <= minX || maxY <= minY) {
            return null;
        }
        return new BoundingBox2D(minX, minY, maxX, maxY);
    }

    public static BoundingBox3D computeIntersectionOfTwoBoundingBoxes(BoundingBox3DReadOnly a, BoundingBox3DReadOnly b) {
        double maxX = Math.min(a.getMaxX(), b.getMaxX());
        double maxY = Math.min(a.getMaxY(), b.getMaxY());
        double maxZ = Math.min(a.getMaxZ(), b.getMaxZ());
        double minX = Math.max(a.getMinX(), b.getMinX());
        double minY = Math.max(a.getMinY(), b.getMinY());
        double minZ = Math.max(a.getMinZ(), b.getMinZ());
        if (maxX <= minX || maxY <= minY || maxZ <= minZ) {
            return null;
        }
        return new BoundingBox3D(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static double computeBoundingBoxVolume3D(BoundingBox3DReadOnly boundingBox) {
        return Math.abs(boundingBox.getMaxX() - boundingBox.getMinX()) * Math.abs(boundingBox.getMaxY() - boundingBox.getMinY()) * Math.abs(boundingBox.getMaxZ() - boundingBox.getMinZ());
    }
}

