/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics;

import java.lang.reflect.Field;
import java.util.Random;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class EuclidCoreMissingTools {
    public static final String DEGREE_SYMBOL = "\u00b0";
    private static final Field referenceFrameHasBeenRemoved;
    private static final Field referenceFrameName;

    public static void floorToGivenPrecision(Tuple3DBasics tuple3d, double precision) {
        tuple3d.setX(MathTools.floorToPrecision((double)tuple3d.getX(), (double)precision));
        tuple3d.setY(MathTools.floorToPrecision((double)tuple3d.getY(), (double)precision));
        tuple3d.setZ(MathTools.floorToPrecision((double)tuple3d.getZ(), (double)precision));
    }

    public static void roundToGivenPrecision(Tuple3DBasics tuple3d, double precision) {
        tuple3d.setX(MathTools.roundToPrecision((double)tuple3d.getX(), (double)precision));
        tuple3d.setY(MathTools.roundToPrecision((double)tuple3d.getY(), (double)precision));
        tuple3d.setZ(MathTools.roundToPrecision((double)tuple3d.getZ(), (double)precision));
    }

    public static void floorToGivenPrecision(Tuple2DBasics tuple2d, double precision) {
        tuple2d.setX(MathTools.floorToPrecision((double)tuple2d.getX(), (double)precision));
        tuple2d.setY(MathTools.floorToPrecision((double)tuple2d.getY(), (double)precision));
    }

    public static void roundToGivenPrecision(Tuple2DBasics tuple2d, double precision) {
        tuple2d.setX(MathTools.roundToPrecision((double)tuple2d.getX(), (double)precision));
        tuple2d.setY(MathTools.roundToPrecision((double)tuple2d.getY(), (double)precision));
    }

    public static boolean isFinite(Tuple3DBasics tuple) {
        return Double.isFinite(tuple.getX()) && Double.isFinite(tuple.getY()) && Double.isFinite(tuple.getZ());
    }

    public static boolean isPoint2DOnLineSegment2D(double pointX, double pointY, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((double)pointX, (double)pointY, (double)lineSegmentStart.getX(), (double)lineSegmentStart.getY(), (double)lineSegmentEnd.getX(), (double)lineSegmentEnd.getY()) < 1.0E-8;
    }

    public static void projectRotationOnAxis(QuaternionReadOnly rotation, Vector3DReadOnly axis, QuaternionBasics result) {
        double dotProduct = rotation.getX() * axis.getX() + rotation.getY() * axis.getY() + rotation.getZ() * axis.getZ();
        double scale = dotProduct / axis.normSquared();
        double projectedX = scale * axis.getX();
        double projectedY = scale * axis.getY();
        double projectedZ = scale * axis.getZ();
        result.set(projectedX, projectedY, projectedZ, rotation.getS());
        result.normalize();
    }

    public static boolean intersectionBetweenTwoLine2Ds(Point2DReadOnly firstPointOnLine1, Point2DReadOnly secondPointOnLine1, Point2DReadOnly firstPointOnLine2, Point2DReadOnly secondPointOnLine2, Point2DBasics intersectionToPack) {
        double pointOnLine1x = firstPointOnLine1.getX();
        double pointOnLine1y = firstPointOnLine1.getY();
        double lineDirection1x = secondPointOnLine1.getX() - firstPointOnLine1.getX();
        double lineDirection1y = secondPointOnLine1.getY() - firstPointOnLine1.getY();
        double pointOnLine2x = firstPointOnLine2.getX();
        double pointOnLine2y = firstPointOnLine2.getY();
        double lineDirection2x = secondPointOnLine2.getX() - firstPointOnLine2.getX();
        double lineDirection2y = secondPointOnLine2.getY() - firstPointOnLine2.getY();
        return EuclidGeometryTools.intersectionBetweenTwoLine2Ds((double)pointOnLine1x, (double)pointOnLine1y, (double)lineDirection1x, (double)lineDirection1y, (double)pointOnLine2x, (double)pointOnLine2y, (double)lineDirection2x, (double)lineDirection2y, (Point2DBasics)intersectionToPack);
    }

    public static double percentageOfIntersectionBetweenTwoLine2DsInfCase(double startPoint1x, double startPoint1y, double segmentTravel1x, double segmentTravel1y, double startPoint2x, double startPoint2y, double segmentTravel2x, double segmentTravel2y) {
        double determinant = -segmentTravel1x * segmentTravel2y + segmentTravel1y * segmentTravel2x;
        double dx = startPoint2x - startPoint1x;
        double dy = startPoint2y - startPoint1y;
        if (Math.abs(determinant) < 1.0E-12) {
            double cross = dx * segmentTravel1y - dy * segmentTravel1x;
            if (Math.abs(cross) < 1.0E-12) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        double oneOverDeterminant = 1.0 / determinant;
        double AInverse00 = oneOverDeterminant * -segmentTravel2y;
        double AInverse01 = oneOverDeterminant * segmentTravel2x;
        double alpha = AInverse00 * dx + AInverse01 * dy;
        return alpha;
    }

    public static void rotationMatrix3DFromZUpToVector3D(Vector3DReadOnly vector, CommonMatrix3DBasics rotationToPack) {
        EuclidCoreMissingTools.rotationMatrix3DFromFirstToSecondVector3D((Vector3DReadOnly)Axis3D.Z, vector, rotationToPack);
    }

    public static void rotationMatrix3DFromFirstToSecondVector3D(Vector3DReadOnly firstVector, Vector3DReadOnly secondVector, CommonMatrix3DBasics rotationToPack) {
        EuclidCoreMissingTools.rotationMatrix3DFromFirstToSecondVector3D(firstVector.getX(), firstVector.getY(), firstVector.getZ(), secondVector.getX(), secondVector.getY(), secondVector.getZ(), rotationToPack);
    }

    public static void rotationMatrix3DFromFirstToSecondVector3D(double firstVectorX, double firstVectorY, double firstVectorZ, double secondVectorX, double secondVectorY, double secondVectorZ, CommonMatrix3DBasics rotationToPack) {
        double rotationAxisZ;
        double rotationAxisY;
        double secondVectorLengthInv;
        double firstVectorLengthInv;
        double rotationAxisX;
        double sinAngle;
        boolean normalsAreParallel;
        boolean bl = normalsAreParallel = (sinAngle = Math.sqrt(EuclidCoreTools.normSquared((double)(rotationAxisX = (firstVectorY *= (firstVectorLengthInv = 1.0 / Math.sqrt(EuclidCoreTools.normSquared((double)firstVectorX, (double)firstVectorY, (double)firstVectorZ)))) * (secondVectorZ *= (secondVectorLengthInv = 1.0 / Math.sqrt(EuclidCoreTools.normSquared((double)secondVectorX, (double)secondVectorY, (double)secondVectorZ)))) - (firstVectorZ *= firstVectorLengthInv) * (secondVectorY *= secondVectorLengthInv)), (double)(rotationAxisY = firstVectorZ * (secondVectorX *= secondVectorLengthInv) - (firstVectorX *= firstVectorLengthInv) * secondVectorZ), (double)(rotationAxisZ = firstVectorX * secondVectorY - firstVectorY * secondVectorX)))) < 1.0E-7;
        if (normalsAreParallel) {
            rotationToPack.setIdentity();
            return;
        }
        rotationAxisX /= sinAngle;
        rotationAxisY /= sinAngle;
        rotationAxisZ /= sinAngle;
        double cosAngle = firstVectorX * secondVectorX + firstVectorY * secondVectorY + firstVectorZ * secondVectorZ;
        if (cosAngle > 1.0) {
            cosAngle = 1.0;
        } else if (cosAngle < -1.0) {
            cosAngle = -1.0;
        }
        double t = 1.0 - cosAngle;
        double xz = rotationAxisX * rotationAxisZ;
        double xy = rotationAxisX * rotationAxisY;
        double yz = rotationAxisY * rotationAxisZ;
        double m00 = t * rotationAxisX * rotationAxisX + cosAngle;
        double m01 = t * xy - sinAngle * rotationAxisZ;
        double m02 = t * xz + sinAngle * rotationAxisY;
        double m10 = t * xy + sinAngle * rotationAxisZ;
        double m11 = t * rotationAxisY * rotationAxisY + cosAngle;
        double m12 = t * yz - sinAngle * rotationAxisX;
        double m20 = t * xz - sinAngle * rotationAxisY;
        double m21 = t * yz + sinAngle * rotationAxisX;
        double m22 = t * rotationAxisZ * rotationAxisZ + cosAngle;
        if (rotationToPack instanceof RotationMatrix) {
            ((RotationMatrix)rotationToPack).setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        } else {
            rotationToPack.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }
    }

    public static double closestPoint2DsBetweenTwoLineSegment2Ds(Point2DReadOnly lineSegmentStart1, Point2DReadOnly lineSegmentEnd1, Point2DReadOnly lineSegmentStart2, Point2DReadOnly lineSegmentEnd2, Point2DBasics closestPointOnLineSegment1ToPack, Point2DBasics closestPointOnLineSegment2ToPack) {
        double tNumerator;
        double sNumerator;
        double delta;
        Point2DReadOnly P0 = lineSegmentStart1;
        double ux = lineSegmentEnd1.getX() - lineSegmentStart1.getX();
        double uy = lineSegmentEnd1.getY() - lineSegmentStart1.getY();
        Point2DReadOnly Q0 = lineSegmentStart2;
        double vx = lineSegmentEnd2.getX() - lineSegmentStart2.getX();
        double vy = lineSegmentEnd2.getY() - lineSegmentStart2.getY();
        Point2DBasics Psc = closestPointOnLineSegment1ToPack;
        Point2DBasics Qtc = closestPointOnLineSegment2ToPack;
        double w0X = P0.getX() - Q0.getX();
        double w0Y = P0.getY() - Q0.getY();
        double a = ux * ux + uy * uy;
        double b = ux * vx + uy * vy;
        double c = vx * vx + vy * vy;
        double d = ux * w0X + uy * w0Y;
        double e = vx * w0X + vy * w0Y;
        double sDenominator = delta = a * c - b * b;
        double tDenominator = delta;
        if (delta <= 1.0E-6) {
            sNumerator = 0.0;
            sDenominator = 1.0;
            tNumerator = e;
            tDenominator = c;
        } else {
            sNumerator = b * e - c * d;
            tNumerator = a * e - b * d;
            if (sNumerator < 0.0) {
                sNumerator = 0.0;
                tNumerator = e;
                tDenominator = c;
            } else if (sNumerator > sDenominator) {
                sNumerator = sDenominator;
                tNumerator = e + b;
                tDenominator = c;
            }
        }
        if (tNumerator < 0.0) {
            tNumerator = 0.0;
            sNumerator = -d;
            if (sNumerator < 0.0) {
                sNumerator = 0.0;
            } else if (sNumerator > a) {
                sNumerator = a;
            }
            sDenominator = a;
        } else if (tNumerator > tDenominator) {
            tNumerator = tDenominator;
            sNumerator = -d + b;
            if (sNumerator < 0.0) {
                sNumerator = 0.0;
            } else if (sNumerator > a) {
                sNumerator = a;
            }
            sDenominator = a;
        }
        double sc = Math.abs(sNumerator) < 1.0E-6 ? 0.0 : sNumerator / sDenominator;
        double tc = Math.abs(tNumerator) < 1.0E-6 ? 0.0 : tNumerator / tDenominator;
        double PscX = sc * ux + P0.getX();
        double PscY = sc * uy + P0.getY();
        double QtcX = tc * vx + Q0.getX();
        double QtcY = tc * vy + Q0.getY();
        if (Psc != null) {
            Psc.set(PscX, PscY);
        }
        if (Qtc != null) {
            Qtc.set(QtcX, QtcY);
        }
        double dx = PscX - QtcX;
        double dy = PscY - QtcY;
        return Math.sqrt(EuclidCoreTools.normSquared((double)dx, (double)dy));
    }

    public static double distanceBetweenTwoLineSegment2Ds(Point2DReadOnly lineSegmentStart1, Point2DReadOnly lineSegmentEnd1, Point2DReadOnly lineSegmentStart2, Point2DReadOnly lineSegmentEnd2) {
        return EuclidCoreMissingTools.closestPoint2DsBetweenTwoLineSegment2Ds(lineSegmentStart1, lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2, null, null);
    }

    public static double distanceSquaredFromPoint2DToLineSegment2D(double pointX, double pointY, double lineSegmentStartX, double lineSegmentStartY, double lineSegmentEndX, double lineSegmentEndY, Point2D intersectionPointToPack) {
        double percentage = EuclidGeometryTools.percentageAlongLineSegment2D((double)pointX, (double)pointY, (double)lineSegmentStartX, (double)lineSegmentStartY, (double)lineSegmentEndX, (double)lineSegmentEndY);
        if (percentage > 1.0) {
            percentage = 1.0;
        } else if (percentage < 0.0) {
            percentage = 0.0;
        }
        double projectionX = (1.0 - percentage) * lineSegmentStartX + percentage * lineSegmentEndX;
        double projectionY = (1.0 - percentage) * lineSegmentStartY + percentage * lineSegmentEndY;
        if (intersectionPointToPack != null) {
            intersectionPointToPack.set(projectionX, projectionY);
        }
        double dx = projectionX - pointX;
        double dy = projectionY - pointY;
        return dx * dx + dy * dy;
    }

    public static boolean epsilonEquals(RigidBodyTransformReadOnly a, RigidBodyTransformReadOnly b, double rotationEpsilon, double translationEpsilon) {
        return a.getRotation().geometricallyEquals((EuclidGeometry)b.getRotation(), rotationEpsilon) && a.getTranslation().geometricallyEquals((EuclidGeometry)b.getTranslation(), translationEpsilon);
    }

    public static void extractNormalPart(Tuple3DReadOnly input, Vector3DReadOnly normalAxis, Tuple3DBasics inputNormalPartToPack) {
        double normalX = normalAxis.getX();
        double normalY = normalAxis.getY();
        double normalZ = normalAxis.getZ();
        double normalLengthSquared = EuclidCoreTools.normSquared((double)normalX, (double)normalY, (double)normalZ);
        double dot = TupleTools.dot((Tuple3DReadOnly)normalAxis, (Tuple3DReadOnly)input) / normalLengthSquared;
        inputNormalPartToPack.setAndScale(dot, (Tuple3DReadOnly)normalAxis);
    }

    public static void extractNormalPart(FrameTuple3DReadOnly input, FrameVector3DReadOnly normalAxis, FixedFrameTuple3DBasics inputNormalPartToPack) {
        input.checkReferenceFrameMatch((ReferenceFrameHolder)normalAxis, (ReferenceFrameHolder)inputNormalPartToPack);
        EuclidCoreMissingTools.extractNormalPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)inputNormalPartToPack);
    }

    public static void extractNormalPart(FrameTuple3DReadOnly input, FrameVector3DReadOnly normalAxis, FrameTuple3DBasics inputNormalPartToPack) {
        input.checkReferenceFrameMatch((ReferenceFrameHolder)normalAxis);
        inputNormalPartToPack.setReferenceFrame(input.getReferenceFrame());
        EuclidCoreMissingTools.extractNormalPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)inputNormalPartToPack);
    }

    public static void extractTangentialPart(Tuple3DReadOnly input, Vector3DReadOnly normalAxis, Tuple3DBasics inputTagentialPartToPack) {
        double normalX = normalAxis.getX();
        double normalY = normalAxis.getY();
        double normalZ = normalAxis.getZ();
        double normalLengthSquared = EuclidCoreTools.normSquared((double)normalX, (double)normalY, (double)normalZ);
        double dot = TupleTools.dot((double)normalX, (double)normalY, (double)normalZ, (Tuple3DReadOnly)input) / normalLengthSquared;
        double normalPartX = dot * normalX;
        double normalPartY = dot * normalY;
        double normalPartZ = dot * normalZ;
        inputTagentialPartToPack.set(input);
        inputTagentialPartToPack.sub(normalPartX, normalPartY, normalPartZ);
    }

    public static void extractTangentialPart(FrameTuple3DReadOnly input, FrameVector3DReadOnly normalAxis, FixedFrameTuple3DBasics inputTangentialPartToPack) {
        input.checkReferenceFrameMatch((ReferenceFrameHolder)normalAxis, (ReferenceFrameHolder)inputTangentialPartToPack);
        EuclidCoreMissingTools.extractTangentialPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)inputTangentialPartToPack);
    }

    public static void extractTangentialPart(FrameTuple3DReadOnly input, FrameVector3DReadOnly normalAxis, FrameTuple3DBasics inputTangentialPartToPack) {
        input.checkReferenceFrameMatch((ReferenceFrameHolder)normalAxis);
        inputTangentialPartToPack.setReferenceFrame(input.getReferenceFrame());
        EuclidCoreMissingTools.extractTangentialPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)inputTangentialPartToPack);
    }

    public static void setNormalPart(Tuple3DReadOnly input, Vector3DReadOnly normalAxis, Tuple3DBasics tupleToModify) {
        double normalX = normalAxis.getX();
        double normalY = normalAxis.getY();
        double normalZ = normalAxis.getZ();
        double normalLengthSquared = EuclidCoreTools.normSquared((double)normalX, (double)normalY, (double)normalZ);
        double dot = (TupleTools.dot((Tuple3DReadOnly)normalAxis, (Tuple3DReadOnly)input) - TupleTools.dot((Tuple3DReadOnly)normalAxis, (Tuple3DReadOnly)tupleToModify)) / normalLengthSquared;
        tupleToModify.scaleAdd(dot, (Tuple3DReadOnly)normalAxis, (Tuple3DReadOnly)tupleToModify);
    }

    public static int intersectionBetweenLineSegment2DAndCylinder3D(double circleRadius, Point2DReadOnly circlePosition, Point2DReadOnly startPoint, Point2DReadOnly endPoint, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        return EuclidCoreMissingTools.intersectionBetweenLine2DAndCircle(circleRadius, circlePosition.getX(), circlePosition.getY(), startPoint.getX(), startPoint.getY(), false, endPoint.getX(), endPoint.getY(), false, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenRay2DAndCircle(double circleRadius, Point2DReadOnly circlePosition, Point2DReadOnly startPoint, Point2DReadOnly pointOnRay, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        return EuclidCoreMissingTools.intersectionBetweenLine2DAndCircle(circleRadius, circlePosition.getX(), circlePosition.getY(), startPoint.getX(), startPoint.getY(), false, pointOnRay.getX(), pointOnRay.getY(), true, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenRay2DAndCircle(double circleRadius, Point2DReadOnly circlePosition, Point2DReadOnly startPoint, Vector2DReadOnly direction, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        return EuclidCoreMissingTools.intersectionBetweenLine2DAndCircle(circleRadius, circlePosition.getX(), circlePosition.getY(), startPoint.getX(), startPoint.getY(), false, startPoint.getX() + direction.getX(), startPoint.getY() + direction.getY(), true, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenLine2DAndCircle(double circleRadius, Point2DReadOnly circlePosition, Point2DReadOnly pointOnLine, Vector2DReadOnly direction, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        return EuclidCoreMissingTools.intersectionBetweenLine2DAndCircle(circleRadius, circlePosition.getX(), circlePosition.getY(), pointOnLine.getX(), pointOnLine.getY(), true, pointOnLine.getX() + direction.getX(), pointOnLine.getY() + direction.getY(), true, firstIntersectionToPack, secondIntersectionToPack);
    }

    private static int intersectionBetweenLine2DAndCircle(double circleRadius, double circlePositionX, double circlePositionY, double startX, double startY, boolean canIntersectionOccurBeforeStart, double endX, double endY, boolean canIntersectionOccurAfterEnd, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        double C;
        if (circleRadius < 0.0) {
            throw new IllegalArgumentException("The circle radius has to be positive.");
        }
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setToNaN();
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setToNaN();
        }
        if (circleRadius == 0.0) {
            return 0;
        }
        double radiusSquared = circleRadius * circleRadius;
        double dx = endX - startX;
        double dy = endY - startY;
        double dIntersection1 = Double.NaN;
        double dIntersection2 = Double.NaN;
        double deltaPX = startX - circlePositionX;
        double deltaPY = startY - circlePositionY;
        double B = 2.0 * (dx * deltaPX + dy * deltaPY);
        double A = EuclidCoreTools.normSquared((double)dx, (double)dy);
        double delta = EuclidCoreTools.squareRoot((double)(B * B - 4.0 * A * (C = EuclidCoreTools.normSquared((double)deltaPX, (double)deltaPY) - radiusSquared)));
        if (Double.isFinite(delta)) {
            double intersection2Y;
            double intersection2X;
            double oneOverTwoA = 0.5 / A;
            double dCircle1 = -(B + delta) * oneOverTwoA;
            double dCircle2 = -(B - delta) * oneOverTwoA;
            double intersection1X = dCircle1 * dx + startX;
            double intersection1Y = dCircle1 * dy + startY;
            if (Math.abs(EuclidGeometryTools.percentageAlongLine2D((double)intersection1X, (double)intersection1Y, (double)circlePositionX, (double)circlePositionY, (double)1.0, (double)0.0)) > circleRadius - 1.0E-12) {
                dCircle1 = Double.NaN;
            }
            if (Double.isFinite(dCircle1)) {
                if (Double.isNaN(dIntersection1) || Math.abs(dCircle1 - dIntersection1) < 1.0E-12) {
                    dIntersection1 = dCircle1;
                } else if (dCircle1 < dIntersection1) {
                    dIntersection2 = dIntersection1;
                    dIntersection1 = dCircle1;
                } else {
                    dIntersection2 = dCircle1;
                }
            }
            if (Math.abs(EuclidGeometryTools.percentageAlongLine2D((double)(intersection2X = dCircle2 * dx + startX), (double)(intersection2Y = dCircle2 * dy + startY), (double)circlePositionX, (double)circlePositionY, (double)1.0, (double)0.0)) > circleRadius - 1.0E-12) {
                dCircle2 = Double.NaN;
            } else if (Math.abs(dCircle1 - dCircle2) < 1.0E-12) {
                dCircle2 = Double.NaN;
            }
            if (Double.isFinite(dCircle2)) {
                if (Double.isNaN(dIntersection1)) {
                    dIntersection1 = dCircle2;
                } else if (dCircle2 < dIntersection1) {
                    dIntersection2 = dIntersection1;
                    dIntersection1 = dCircle2;
                } else {
                    dIntersection2 = dCircle2;
                }
            }
        }
        if (!canIntersectionOccurBeforeStart) {
            if (dIntersection2 < 0.0) {
                dIntersection2 = Double.NaN;
            }
            if (dIntersection1 < 0.0) {
                dIntersection1 = dIntersection2;
                dIntersection2 = Double.NaN;
            }
        }
        if (!canIntersectionOccurAfterEnd) {
            if (dIntersection2 > 1.0) {
                dIntersection2 = Double.NaN;
            }
            if (dIntersection1 > 1.0) {
                dIntersection1 = dIntersection2;
                dIntersection2 = Double.NaN;
            }
        }
        if (Double.isNaN(dIntersection1)) {
            return 0;
        }
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.set(dx, dy);
            firstIntersectionToPack.scale(dIntersection1);
            firstIntersectionToPack.add(startX, startY);
        }
        if (Double.isNaN(dIntersection2)) {
            return 1;
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.set(dx, dy);
            secondIntersectionToPack.scale(dIntersection2);
            secondIntersectionToPack.add(startX, startY);
        }
        return 2;
    }

    public static double angleFromFirstToSecondVector3D(Vector3DReadOnly firstVector, Vector3DReadOnly secondVector) {
        return EuclidCoreMissingTools.angleFromFirstToSecondVector3D(firstVector.getX(), firstVector.getY(), firstVector.getZ(), firstVector instanceof UnitVector3DReadOnly, secondVector.getX(), secondVector.getY(), secondVector.getZ(), secondVector instanceof UnitVector3DReadOnly);
    }

    private static double angleFromFirstToSecondVector3D(double firstVectorX, double firstVectorY, double firstVectorZ, boolean isFirstVectorUnitary, double secondVectorX, double secondVectorY, double secondVectorZ, boolean isSecondVectorUnitary) {
        double firstVectorLength = isFirstVectorUnitary ? 1.0 : EuclidCoreTools.norm((double)firstVectorX, (double)firstVectorY, (double)firstVectorZ);
        double secondVectorLength = isSecondVectorUnitary ? 1.0 : EuclidCoreTools.norm((double)secondVectorX, (double)secondVectorY, (double)secondVectorZ);
        double dotProduct = firstVectorX * secondVectorX + firstVectorY * secondVectorY + firstVectorZ * secondVectorZ;
        if ((dotProduct /= firstVectorLength * secondVectorLength) > 1.0) {
            dotProduct = 1.0;
        } else if (dotProduct < -1.0) {
            dotProduct = -1.0;
        }
        return EuclidCoreTools.acos((double)dotProduct);
    }

    public static boolean intersectionBetweenLine3DAndPlane3D(double pointOnPlaneX, double pointOnPlaneY, double pointOnPlaneZ, double planeNormalX, double planeNormalY, double planeNormalZ, double pointOnLineX, double pointOnLineY, double pointOnLineZ, double lineDirectionX, double lineDirectionY, double lineDirectionZ, Point3DBasics intersectionToPack) {
        double numerator = (pointOnPlaneX - pointOnLineX) * planeNormalX;
        numerator += (pointOnPlaneY - pointOnLineY) * planeNormalY;
        numerator += (pointOnPlaneZ - pointOnLineZ) * planeNormalZ;
        double denominator = planeNormalX * lineDirectionX + planeNormalY * lineDirectionY + planeNormalZ * lineDirectionZ;
        if (Math.abs(denominator) < 1.0E-12) {
            return false;
        }
        double d = numerator / denominator;
        intersectionToPack.setX(d * lineDirectionX + pointOnLineX);
        intersectionToPack.setY(d * lineDirectionY + pointOnLineY);
        intersectionToPack.setZ(d * lineDirectionZ + pointOnLineZ);
        return true;
    }

    public static boolean intersectionBetweenRay2DAndLine2D(Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection, Point2DReadOnly lineOrigin, Vector2DReadOnly lineDirection, Point2DBasics intersectionToPack) {
        return EuclidCoreMissingTools.intersectionBetweenRay2DAndLine2D(rayOrigin.getX(), rayOrigin.getY(), rayDirection.getX(), rayDirection.getY(), lineOrigin.getX(), lineOrigin.getY(), lineDirection.getX(), lineDirection.getY(), intersectionToPack);
    }

    public static boolean intersectionBetweenRay2DAndLine2D(Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection, Point2DReadOnly linePoint1, Point2DReadOnly linePoint2, Point2DBasics intersectionToPack) {
        return EuclidCoreMissingTools.intersectionBetweenRay2DAndLine2D(rayOrigin.getX(), rayOrigin.getY(), rayDirection.getX(), rayDirection.getY(), linePoint1.getX(), linePoint1.getY(), linePoint2.getX() - linePoint1.getX(), linePoint2.getY() - linePoint1.getY(), intersectionToPack);
    }

    public static boolean intersectionBetweenRay2DAndLine2D(double rayOriginX, double rayOriginY, double rayDirectionX, double rayDirectionY, double lineOriginX, double lineOriginY, double lineDirectionX, double lineDirectionY, Point2DBasics intersectionToPack) {
        double start1x = rayOriginX;
        double start1y = rayOriginY;
        double end1x = rayOriginX + rayDirectionX;
        double end1y = rayOriginY + rayDirectionY;
        double start2x = lineOriginX;
        double start2y = lineOriginY;
        double end2x = lineOriginX + lineDirectionX;
        double end2y = lineOriginY + lineDirectionY;
        return EuclidCoreMissingTools.intersectionBetweenTwoLine2DsImpl(start1x, start1y, false, end1x, end1y, true, start2x, start2y, true, end2x, end2y, true, intersectionToPack);
    }

    private static boolean intersectionBetweenTwoLine2DsImpl(double start1x, double start1y, boolean canIntersectionOccurBeforeStart1, double end1x, double end1y, boolean canIntersectionOccurBeforeEnd1, double start2x, double start2y, boolean canIntersectionOccurBeforeStart2, double end2x, double end2y, boolean canIntersectionOccurBeforeEnd2, Point2DBasics intersectionToPack) {
        boolean areIntersecting;
        double epsilon = 1.0E-7;
        double direction1x = end1x - start1x;
        double direction1y = end1y - start1y;
        double direction2x = end2x - start2x;
        double direction2y = end2y - start2y;
        double determinant = -direction1x * direction2y + direction1y * direction2x;
        double zeroish = 0.0 - epsilon;
        if (Math.abs(determinant) < epsilon) {
            double dx = start2x - start1x;
            double dy = start2y - start1y;
            double cross = dx * direction1y - dy * direction1x;
            if (Math.abs(cross) < epsilon) {
                if (canIntersectionOccurBeforeStart1 && canIntersectionOccurBeforeEnd1) {
                    if (canIntersectionOccurBeforeStart2 && canIntersectionOccurBeforeEnd2) {
                        if (intersectionToPack != null) {
                            intersectionToPack.set(start1x, start1y);
                        }
                        return true;
                    }
                    if (intersectionToPack != null) {
                        intersectionToPack.set(start2x, start2y);
                    }
                    return true;
                }
                if (canIntersectionOccurBeforeStart2 && canIntersectionOccurBeforeEnd2) {
                    if (intersectionToPack != null) {
                        intersectionToPack.set(start1x, start1y);
                    }
                    return true;
                }
                double direction1LengthSquare = EuclidCoreTools.normSquared((double)direction1x, (double)direction1y);
                dx = start2x - start1x;
                dy = start2y - start1y;
                double dot = dx * direction1x + dy * direction1y;
                if ((canIntersectionOccurBeforeStart1 || zeroish < dot) && (canIntersectionOccurBeforeEnd1 || dot < direction1LengthSquare + epsilon)) {
                    if (intersectionToPack != null) {
                        intersectionToPack.set(start2x, start2y);
                    }
                    return true;
                }
                dx = end2x - start1x;
                dy = end2y - start1y;
                dot = dx * direction1x + dy * direction1y;
                if ((canIntersectionOccurBeforeStart1 || zeroish < dot) && (canIntersectionOccurBeforeEnd1 || dot < direction1LengthSquare + epsilon)) {
                    if (intersectionToPack != null) {
                        intersectionToPack.set(end2x, end2y);
                    }
                    return true;
                }
                double direction2LengthSquare = EuclidCoreTools.normSquared((double)direction2x, (double)direction2y);
                dx = start1x - start2x;
                dy = start1y - start2y;
                dot = dx * direction2x + dy * direction2y;
                if ((canIntersectionOccurBeforeStart2 || zeroish < dot) && (canIntersectionOccurBeforeEnd2 || dot < direction2LengthSquare + epsilon)) {
                    if (intersectionToPack != null) {
                        intersectionToPack.set(start1x, start1y);
                    }
                    return true;
                }
                dx = end1x - start2x;
                dy = end1y - start2y;
                dot = dx * direction2x + dy * direction2y;
                if ((canIntersectionOccurBeforeStart2 || zeroish < dot) && (canIntersectionOccurBeforeEnd2 || dot < direction2LengthSquare + epsilon)) {
                    if (intersectionToPack != null) {
                        intersectionToPack.set(end1x, end1y);
                    }
                    return true;
                }
                if (intersectionToPack != null) {
                    intersectionToPack.setToNaN();
                }
                return false;
            }
            if (intersectionToPack != null) {
                intersectionToPack.setToNaN();
            }
            return false;
        }
        double dx = start2x - start1x;
        double dy = start2y - start1y;
        double oneOverDeterminant = 1.0 / determinant;
        double AInverse00 = -direction2y;
        double AInverse01 = direction2x;
        double AInverse10 = -direction1y;
        double AInverse11 = direction1x;
        double alpha = oneOverDeterminant * (AInverse00 * dx + AInverse01 * dy);
        double beta = oneOverDeterminant * (AInverse10 * dx + AInverse11 * dy);
        double oneish = 1.0 + epsilon;
        boolean bl = areIntersecting = (canIntersectionOccurBeforeStart1 || zeroish < alpha) && (canIntersectionOccurBeforeEnd1 || alpha < oneish);
        if (areIntersecting) {
            boolean bl2 = areIntersecting = (canIntersectionOccurBeforeStart2 || zeroish < beta) && (canIntersectionOccurBeforeEnd2 || beta < oneish);
        }
        if (intersectionToPack != null) {
            if (areIntersecting) {
                intersectionToPack.set(start1x + alpha * direction1x, start1y + alpha * direction1y);
            } else {
                intersectionToPack.setToNaN();
            }
        }
        return areIntersecting;
    }

    public static void differentiateOrientation(QuaternionReadOnly qStart, QuaternionReadOnly qEnd, double duration, Vector3DBasics angularVelocityToPack) {
        double q1x = qStart.getX();
        double q1y = qStart.getY();
        double q1z = qStart.getZ();
        double q1s = qStart.getS();
        double q2x = qEnd.getX();
        double q2y = qEnd.getY();
        double q2z = qEnd.getZ();
        double q2s = qEnd.getS();
        double diffx = q1s * q2x - q1x * q2s - q1y * q2z + q1z * q2y;
        double diffy = q1s * q2y + q1x * q2z - q1y * q2s - q1z * q2x;
        double diffz = q1s * q2z - q1x * q2y + q1y * q2x - q1z * q2s;
        double diffs = q1s * q2s + q1x * q2x + q1y * q2y + q1z * q2z;
        if (diffs < 0.0) {
            diffx = -diffx;
            diffy = -diffy;
            diffz = -diffz;
            diffs = -diffs;
        }
        double sinHalfTheta = EuclidCoreTools.norm((double)diffx, (double)diffy, (double)diffz);
        double angle = EuclidCoreTools.epsilonEquals((double)1.0, (double)diffs, (double)1.0E-12) ? 2.0 * sinHalfTheta / diffs : 2.0 * EuclidCoreTools.atan2((double)sinHalfTheta, (double)diffs);
        angularVelocityToPack.set(diffx, diffy, diffz);
        angularVelocityToPack.scale(angle / (sinHalfTheta * duration));
    }

    public static DMatrixRMaj quaternionDotToOmegaTransform(QuaternionReadOnly rotatingFrameQuaternion) {
        double qs = rotatingFrameQuaternion.getS();
        double qx = rotatingFrameQuaternion.getX();
        double qy = rotatingFrameQuaternion.getY();
        double qz = rotatingFrameQuaternion.getZ();
        DMatrixRMaj E = new DMatrixRMaj(4, 4);
        E.set(0, 0, qs);
        E.set(0, 1, qx);
        E.set(0, 2, qy);
        E.set(0, 3, qz);
        E.set(1, 0, -qx);
        E.set(1, 1, qs);
        E.set(1, 2, qz);
        E.set(1, 3, -qy);
        E.set(2, 0, -qy);
        E.set(2, 1, -qz);
        E.set(2, 2, qs);
        E.set(2, 3, qx);
        E.set(3, 0, -qz);
        E.set(3, 1, qy);
        E.set(3, 2, -qx);
        E.set(3, 3, qs);
        return E;
    }

    public static void setYawPitchRollDegrees(Orientation3DBasics orientation3DBasics, double yaw, double pitch, double roll) {
        orientation3DBasics.setYawPitchRoll(Math.toRadians(yaw), Math.toRadians(pitch), Math.toRadians(roll));
    }

    public static String getYawPitchRollStringDegrees(Orientation3DBasics orientation3DBasics) {
        return EuclidCoreIOTools.getYawPitchRollString((String)EuclidCoreIOTools.DEFAULT_FORMAT, (double)Math.toDegrees(orientation3DBasics.getYaw()), (double)Math.toDegrees(orientation3DBasics.getPitch()), (double)Math.toDegrees(orientation3DBasics.getRoll())) + DEGREE_SYMBOL;
    }

    public static String getYawPitchRollValuesStringDegrees(Orientation3DBasics orientation3DBasics) {
        return EuclidCoreIOTools.getStringOf((String)"(", (String)")", (String)", ", (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])new double[]{Math.toDegrees(orientation3DBasics.getYaw()), Math.toDegrees(orientation3DBasics.getPitch()), Math.toDegrees(orientation3DBasics.getRoll())}) + DEGREE_SYMBOL;
    }

    public static Matrix3D nextPositiveDefiniteMatrix3D(Random random) {
        return EuclidCoreMissingTools.nextPositiveDefiniteMatrix3D(random, 1.0);
    }

    public static Matrix3D nextPositiveDefiniteMatrix3D(Random random, double minMaxValue) {
        Matrix3D matrix3D = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)minMaxValue);
        matrix3D.multiplyTransposeOther((Matrix3DReadOnly)matrix3D);
        double diagonalDominanceScalar = Math.abs(minMaxValue);
        matrix3D.addM00(diagonalDominanceScalar);
        matrix3D.addM11(diagonalDominanceScalar);
        matrix3D.addM22(diagonalDominanceScalar);
        double scalarToShrinkMatrixWithinBounds = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)(minMaxValue / matrix3D.maxAbsElement()));
        matrix3D.scale(scalarToShrinkMatrixWithinBounds);
        return matrix3D;
    }

    public static boolean hasBeenRemoved(ReferenceFrame referenceFrame) {
        try {
            return referenceFrameHasBeenRemoved.getBoolean(referenceFrame);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static String frameName(ReferenceFrame referenceFrame) {
        try {
            return referenceFrameName.get(referenceFrame).toString();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static FrameVector3DReadOnly newLinkedFrameVector3DReadOnly(ReferenceFrameHolder referenceFrameHolder, DMatrixRMaj source) {
        return EuclidCoreMissingTools.newLinkedFrameVector3DReadOnly(referenceFrameHolder, 0, source);
    }

    public static FrameVector3DReadOnly newLinkedFrameVector3DReadOnly(ReferenceFrameHolder referenceFrameHolder, int startIndex, DMatrixRMaj source) {
        int xIndex = startIndex;
        int yIndex = startIndex + 1;
        int zIndex = startIndex + 2;
        return EuclidFrameFactories.newLinkedFrameVector3DReadOnly((ReferenceFrameHolder)referenceFrameHolder, () -> source.get(xIndex, 0), () -> source.get(yIndex, 0), () -> source.get(zIndex, 0));
    }

    static {
        try {
            referenceFrameHasBeenRemoved = ReferenceFrame.class.getDeclaredField("hasBeenRemoved");
            referenceFrameHasBeenRemoved.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            referenceFrameName = ReferenceFrame.class.getDeclaredField("frameName");
            referenceFrameName.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

