/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.trajectories;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.robotics.trajectories.ListOfPointsTrajectory;
import us.ihmc.robotics.trajectories.MinimumJerkTrajectory;

public class WaypointMotionGenerator {
    private ListOfPointsTrajectory listOfPointsTrajectory;
    private double pathLength;
    private double stepSizeforNumericalCalculation = 0.001;
    private double moveDuration;
    private MinimumJerkTrajectory minimumJerkTrajectory = new MinimumJerkTrajectory();

    public WaypointMotionGenerator() {
    }

    public WaypointMotionGenerator(ListOfPointsTrajectory listOfPointsTrajectory, double moveDuration) {
        this(listOfPointsTrajectory, moveDuration, 0.0, 0.0, 0.0, 0.0);
    }

    public WaypointMotionGenerator(ListOfPointsTrajectory listOfPointsTrajectory, double moveDuration, double initialVelocity, double initialAcceleration, double finalVelocity, double finalAcceleration) {
        this.initialize(listOfPointsTrajectory, moveDuration, initialVelocity, initialAcceleration, finalVelocity, finalAcceleration);
    }

    public void initialize(ListOfPointsTrajectory listOfPointsTrajectory, double moveDuration) {
        this.initialize(listOfPointsTrajectory, moveDuration, 0.0, 0.0, 0.0, 0.0);
    }

    public void initialize(ListOfPointsTrajectory listOfPointsTrajectory, double moveDuration, double initialVelocity, double initialAcceleration, double finalVelocity, double finalAcceleration) {
        this.listOfPointsTrajectory = listOfPointsTrajectory;
        this.pathLength = listOfPointsTrajectory.getPathLength();
        this.moveDuration = moveDuration;
        double initialPosition = 0.0;
        double finalPosition = this.pathLength;
        this.minimumJerkTrajectory.setMoveParameters(initialPosition, initialVelocity, initialAcceleration, finalPosition, finalVelocity, finalAcceleration, moveDuration);
    }

    public FramePoint3D getCurrentDesiredPoint(double timeInMove) {
        this.minimumJerkTrajectory.computeTrajectory(timeInMove);
        double distanceAlongPath = this.minimumJerkTrajectory.getPosition();
        return this.listOfPointsTrajectory.getPointOnPathDistanceFromStart(distanceAlongPath);
    }

    public FrameVector3D getCurrentDesiredVelocity(double timeInMove) {
        FramePoint3D Xfh = this.getCurrentDesiredPoint(timeInMove + this.stepSizeforNumericalCalculation);
        FramePoint3D Xf2h = this.getCurrentDesiredPoint(timeInMove + 2.0 * this.stepSizeforNumericalCalculation);
        FramePoint3D Xrh = this.getCurrentDesiredPoint(timeInMove - this.stepSizeforNumericalCalculation);
        FramePoint3D Xr2h = this.getCurrentDesiredPoint(timeInMove - 2.0 * this.stepSizeforNumericalCalculation);
        FrameVector3D ret = new FrameVector3D(Xfh.getReferenceFrame());
        ret.setX((-Xf2h.getX() + 8.0 * Xfh.getX() - 8.0 * Xrh.getX() + Xr2h.getX()) / (12.0 * this.stepSizeforNumericalCalculation));
        ret.setY((-Xf2h.getY() + 8.0 * Xfh.getY() - 8.0 * Xrh.getY() + Xr2h.getY()) / (12.0 * this.stepSizeforNumericalCalculation));
        ret.setZ((-Xf2h.getZ() + 8.0 * Xfh.getZ() - 8.0 * Xrh.getZ() + Xr2h.getZ()) / (12.0 * this.stepSizeforNumericalCalculation));
        if (timeInMove <= this.stepSizeforNumericalCalculation || this.moveDuration - timeInMove <= this.stepSizeforNumericalCalculation) {
            ret.setX(ret.getX() * 2.0);
            ret.setY(ret.getY() * 2.0);
            ret.setZ(ret.getZ() * 2.0);
        }
        return ret;
    }

    public FrameVector3D getCurrentDesiredAcceleration(double timeInMove) {
        FramePoint3D Xfh = this.getCurrentDesiredPoint(timeInMove + this.stepSizeforNumericalCalculation);
        FramePoint3D X = this.getCurrentDesiredPoint(timeInMove);
        FramePoint3D Xrh = this.getCurrentDesiredPoint(timeInMove - this.stepSizeforNumericalCalculation);
        FrameVector3D ret = new FrameVector3D(X.getReferenceFrame());
        ret.setX((Xfh.getX() - 2.0 * X.getX() + Xrh.getX()) / MathTools.square((double)this.stepSizeforNumericalCalculation));
        ret.setY((Xfh.getY() - 2.0 * X.getY() + Xrh.getY()) / MathTools.square((double)this.stepSizeforNumericalCalculation));
        ret.setZ((Xfh.getZ() - 2.0 * X.getZ() + Xrh.getZ()) / MathTools.square((double)this.stepSizeforNumericalCalculation));
        return ret;
    }

    public void setStepSizeforNumericalCalculation(double stepSize) {
        this.stepSizeforNumericalCalculation = stepSize;
    }
}

