/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine;

import java.util.ArrayList;
import java.util.EnumMap;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.PreviousStateProvider;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.State;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateChangedListener;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateTransition;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.TimeInCurrentStateProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

@Deprecated
public class GenericStateMachine<E extends Enum<E>, T extends State<E>>
implements TimeInCurrentStateProvider,
PreviousStateProvider<E, State<E>> {
    private static final boolean DEBUG = false;
    private final EnumMap<E, T> enumsToStates;
    private final YoEnum<E> stateYoVariable;
    private final YoEnum<E> previousStateYoVariable;
    private final YoDouble switchTimeYoVariable;
    private final DoubleProvider time;
    private ArrayList<StateChangedListener<E>> stateChangedListeners;
    protected ArrayList<T> states = new ArrayList();

    public GenericStateMachine(String name, String switchTimeName, Class<E> enumType, YoDouble timeVariable, YoRegistry registry) {
        this(name, switchTimeName, enumType, null, (DoubleProvider)timeVariable, registry);
    }

    public GenericStateMachine(String stateYoVariableName, String switchTimeName, Class<E> enumType, DoubleProvider timeProvider, YoRegistry registry) {
        this(stateYoVariableName, switchTimeName, enumType, null, timeProvider, registry);
    }

    public GenericStateMachine(String stateYoVariableName, String switchTimeName, Class<E> enumType, E initialState, DoubleProvider timeProvider, YoRegistry registry) {
        this.stateYoVariable = new YoEnum(stateYoVariableName, "State machine variable to keep track of the state.", registry, enumType, false);
        this.previousStateYoVariable = new YoEnum(stateYoVariableName + "PreviousState", "State machine variable to keep track of the previous state.", registry, enumType, true);
        this.enumsToStates = new EnumMap(enumType);
        if (initialState != null) {
            this.stateYoVariable.set(initialState);
        }
        this.previousStateYoVariable.set(null);
        this.switchTimeYoVariable = new YoDouble(switchTimeName, registry);
        this.time = timeProvider;
        this.switchTimeYoVariable.set(this.time.getValue());
    }

    public String getStateYoVariableName() {
        return this.stateYoVariable.getName();
    }

    public String getSwitchTimeName() {
        return this.switchTimeYoVariable.getName();
    }

    public void attachStateChangedListener(StateChangedListener<E> listener) {
        if (this.stateChangedListeners == null) {
            this.stateChangedListeners = new ArrayList();
        }
        this.stateChangedListeners.add(listener);
    }

    public void addState(T state) {
        for (State tempState : this.states) {
            if (tempState.getStateEnum() != ((State)state).getStateEnum()) continue;
            throw new RuntimeException("Duplicate state enums, name: " + ((State)state).getStateEnum() + ", already in use.");
        }
        ((State)state).setTimeInCurrentStateProvider(this);
        ((State)state).setPreviousStateProvider(this);
        this.states.add(state);
        this.enumsToStates.put((E)((State)state).getStateEnum(), state);
    }

    public void setCurrentState(E nextStateEnum) {
        T previousState = this.getCurrentState();
        State state = (State)this.enumsToStates.get(nextStateEnum);
        if (state != null) {
            this.switchTimeYoVariable.set(this.time.getValue());
            this.previousStateYoVariable.set(this.stateYoVariable.getEnumValue());
            this.stateYoVariable.set(nextStateEnum);
            if (this.stateChangedListeners != null) {
                for (int i = 0; i < this.stateChangedListeners.size(); ++i) {
                    StateChangedListener<E> listener = this.stateChangedListeners.get(i);
                    listener.stateChanged((State<E>)previousState, state, this.switchTimeYoVariable.getDoubleValue());
                }
            }
        } else {
            throw new RuntimeException("Need to add state " + nextStateEnum + " to the state machine. Can't transition into the state unless it is added!");
        }
        state.doTransitionIntoAction();
    }

    public boolean isCurrentState(E stateEnum) {
        return this.stateYoVariable.getEnumValue() == stateEnum;
    }

    @Override
    public double timeInCurrentState() {
        return this.time.getValue() - this.switchTimeYoVariable.getDoubleValue();
    }

    public boolean inCurrentStateForDuration(double duration) {
        return this.timeInCurrentState() >= duration;
    }

    public void doAction() {
        T currentState = this.getCurrentState();
        if (currentState != null) {
            ((State)currentState).doAction();
        }
    }

    public T getCurrentState() {
        Enum stateEnum = this.stateYoVariable.getEnumValue();
        return (T)((State)this.enumsToStates.get(stateEnum));
    }

    @Override
    public T getPreviousState() {
        Enum stateEnum = this.previousStateYoVariable.getEnumValue();
        return (T)((State)this.enumsToStates.get(stateEnum));
    }

    public E getCurrentStateEnum() {
        return (E)this.stateYoVariable.getEnumValue();
    }

    public E getPreviousStateEnum() {
        Enum stateEnum = this.previousStateYoVariable.getEnumValue();
        return (E)stateEnum;
    }

    public T getState(E stateEnum) {
        for (State state : this.states) {
            if (state.getStateEnum() != stateEnum) continue;
            return (T)state;
        }
        return null;
    }

    public boolean checkTransitionConditions() {
        T currentState = this.getCurrentState();
        StateTransition stateTransition = ((State)currentState).checkTransitionConditions(this.timeInCurrentState());
        if (stateTransition == null) {
            if (((State)currentState).getTransitionToDefaultNextState()) {
                ((State)currentState).clearTransitionToDefaultNextState();
                stateTransition = ((State)currentState).getDefaultNextStateTransition();
                if (stateTransition == null) {
                    throw new RuntimeException("DefaultNextState was not set for currentState=" + currentState);
                }
            } else {
                return false;
            }
        }
        ((State)currentState).doTransitionOutOfAction();
        stateTransition.doAction();
        this.setCurrentState(stateTransition.getNextStateEnum());
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("State Machine:\n");
        for (State state : this.states) {
            stringBuffer.append(state.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public YoEnum<E> getStateYoVariable() {
        return this.stateYoVariable;
    }
}

