/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.sensors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.robotics.screwTheory.GenericCRC32;
import us.ihmc.robotics.sensors.ForceSensorData;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.robotics.sensors.ForceSensorDefinition;

public class ForceSensorDataHolder
implements ForceSensorDataHolderReadOnly,
Settable<ForceSensorDataHolder> {
    private final List<ForceSensorDefinition> forceSensorDefinitions = new ArrayList<ForceSensorDefinition>();
    private final List<ForceSensorData> forceSensorDatas = new ArrayList<ForceSensorData>();
    private final transient Map<String, ForceSensorPackage> sensorNameToDefintionMap = new LinkedHashMap<String, ForceSensorPackage>();

    public ForceSensorDataHolder() {
    }

    public ForceSensorDataHolder(ForceSensorDefinition[] forceSensors) {
        for (ForceSensorDefinition forceSensorDefinition : forceSensors) {
            this.registerForceSensor(forceSensorDefinition);
        }
    }

    public ForceSensorDataHolder(List<ForceSensorDefinition> forceSensors) {
        for (ForceSensorDefinition forceSensorDefinition : forceSensors) {
            this.registerForceSensor(forceSensorDefinition);
        }
    }

    public void clear() {
        this.forceSensorDefinitions.clear();
        this.forceSensorDatas.clear();
    }

    public ForceSensorData registerForceSensor(ForceSensorDefinition forceSensorDefinition) {
        String sensorName = forceSensorDefinition.getSensorName();
        ForceSensorPackage sensorPackage = this.sensorNameToDefintionMap.get(sensorName);
        if (sensorPackage == null) {
            sensorPackage = new ForceSensorPackage(forceSensorDefinition);
            this.sensorNameToDefintionMap.put(sensorName, sensorPackage);
        } else {
            sensorPackage.definition.set(forceSensorDefinition);
        }
        this.forceSensorDefinitions.add(sensorPackage.definition);
        this.forceSensorDatas.add(sensorPackage.data);
        return sensorPackage.data;
    }

    @Override
    public List<ForceSensorDefinition> getForceSensorDefinitions() {
        return this.forceSensorDefinitions;
    }

    public List<ForceSensorData> getForceSensorDatas() {
        return this.forceSensorDatas;
    }

    @Override
    public ForceSensorData getData(ForceSensorDefinition sensorDefinition) {
        return this.getData(sensorDefinition.getSensorName());
    }

    @Override
    public ForceSensorData getData(String sensorName) {
        ForceSensorPackage sensorPackage = this.sensorNameToDefintionMap.get(sensorName);
        return sensorPackage == null ? null : sensorPackage.data;
    }

    @Override
    public ForceSensorDefinition getDefinition(String sensorName) {
        ForceSensorPackage sensorPackage = this.sensorNameToDefintionMap.get(sensorName);
        return sensorPackage == null ? null : sensorPackage.definition;
    }

    public int getNumberOfForceSensors() {
        return this.forceSensorDefinitions.size();
    }

    public void set(ForceSensorDataHolder other) {
        this.clear();
        for (int i = 0; i < other.getForceSensorDefinitions().size(); ++i) {
            ForceSensorDefinition definition = other.getForceSensorDefinitions().get(i);
            ForceSensorData data = other.getForceSensorDatas().get(i);
            this.registerForceSensor(definition).set(data);
        }
    }

    public void set(ForceSensorDataHolderReadOnly other) {
        this.clear();
        for (int i = 0; i < other.getForceSensorDefinitions().size(); ++i) {
            ForceSensorDefinition forceSensorDefinition = other.getForceSensorDefinitions().get(i);
            this.registerForceSensor(forceSensorDefinition).set(other.getData(forceSensorDefinition));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ForceSensorDataHolder) {
            ForceSensorDataHolder other = (ForceSensorDataHolder)obj;
            if (this.forceSensorDefinitions.size() != other.forceSensorDefinitions.size()) {
                return false;
            }
            for (int i = 0; i < this.forceSensorDefinitions.size(); ++i) {
                if (!this.forceSensorDefinitions.get(i).equals(other.forceSensorDefinitions.get(i))) {
                    return false;
                }
                if (this.forceSensorDatas.get(i).equals(other.forceSensorDatas.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void calculateChecksum(GenericCRC32 checksum) {
        for (int i = 0; i < this.forceSensorDatas.size(); ++i) {
            this.forceSensorDatas.get(i).calculateChecksum(checksum);
        }
    }

    public String toString() {
        return "Force sensor data: " + EuclidCoreIOTools.getCollectionString((String)"[\n\t", (String)"\n]", (String)"\n\t", this.forceSensorDatas, data -> "sensorName=" + data.getSensorName() + ", value=" + Arrays.toString(data.getWrenchMatrix().data));
    }

    private static class ForceSensorPackage {
        private final ForceSensorDefinition definition;
        private final ForceSensorData data;

        public ForceSensorPackage(ForceSensorDefinition source) {
            this.definition = new ForceSensorDefinition(source);
            this.data = new ForceSensorData(this.definition);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ForceSensorPackage) {
                ForceSensorPackage other = (ForceSensorPackage)object;
                return Objects.equals(this.definition, other.definition) && Objects.equals(this.data, other.data);
            }
            return false;
        }
    }
}

