/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.sensors;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.SCS2YoGraphicHolder;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;

public interface FootSwitchInterface
extends SCS2YoGraphicHolder {
    public void reset();

    default public void update() {
    }

    default public boolean hasFootHitGroundFiltered() {
        return this.hasFootHitGroundSensitive();
    }

    public boolean hasFootHitGroundSensitive();

    public double getFootLoadPercentage();

    public FramePoint2DReadOnly getCenterOfPressure();

    default public void getCenterOfPressure(FramePoint2DBasics centerOfPressureToPack) {
        FramePoint2DReadOnly thisCoP = this.getCenterOfPressure();
        if (thisCoP == null) {
            centerOfPressureToPack.setToNaN(this.getMeasurementFrame());
        } else {
            centerOfPressureToPack.setIncludingFrame((FrameTuple2DReadOnly)thisCoP);
        }
    }

    public WrenchReadOnly getMeasuredWrench();

    default public void getMeasuredWrench(WrenchBasics measuredWrenchToPack) {
        WrenchReadOnly thisMeasuredWrench = this.getMeasuredWrench();
        if (thisMeasuredWrench == null) {
            measuredWrenchToPack.setToNaN(this.getMeasurementFrame(), this.getMeasurementFrame());
        } else {
            measuredWrenchToPack.setIncludingFrame(thisMeasuredWrench);
        }
    }

    public ReferenceFrame getMeasurementFrame();

    @Override
    default public YoGraphicDefinition getSCS2YoGraphics() {
        return null;
    }
}

