/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import org.ejml.data.DMatrix;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;

public class PassiveRevoluteJoint
extends RevoluteJoint {
    private final boolean isPartOfClosedKinematicLoop;

    public PassiveRevoluteJoint(String name, RigidBodyBasics predecessor, RigidBodyTransform transformToParent, Vector3DReadOnly jointAxis, boolean isPartOfClosedKinematicLoop) {
        super(name, predecessor, (RigidBodyTransformReadOnly)transformToParent, jointAxis);
        this.isPartOfClosedKinematicLoop = isPartOfClosedKinematicLoop;
    }

    public int getJointTau(int rowStart, DMatrix matrix) {
        MathTools.checkIntervalContains((long)matrix.getNumRows(), (long)1L, (long)Integer.MAX_VALUE);
        MathTools.checkIntervalContains((long)matrix.getNumCols(), (long)1L, (long)Integer.MAX_VALUE);
        matrix.set(0, 0, 0.0);
        return rowStart + 1;
    }

    public void setJointAccelerationToZero() {
        throw new RuntimeException("Cannot set acceleration of a passive joint");
    }

    public void setJointWrench(WrenchReadOnly jointWrench) {
        throw new RuntimeException("Cannot set torque of a passive joint");
    }

    public int setJointAcceleration(int rowStart, DMatrix matrix) {
        throw new RuntimeException("Cannot set acceleration of a passive joint");
    }

    public void setQ(double q) {
        super.setQ(q);
    }

    public void setQd(double qd) {
        super.setQd(qd);
    }

    public void setQdd(double qdd) {
        super.setQdd(qdd);
    }

    public void setTau(double tau) {
        throw new RuntimeException("Cannot set torque of a passive joint");
    }

    public int setJointConfiguration(int rowStart, DMatrix matrix) {
        throw new RuntimeException("Cannot set position of a passive joint");
    }

    public int setJointVelocity(int rowStart, DMatrix matrix) {
        throw new RuntimeException("Cannot set velocity of a passive joint");
    }

    public boolean isPartOfClosedKinematicLoop() {
        return this.isPartOfClosedKinematicLoop;
    }
}

