/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.List;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.PrismaticJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;

public class InverseDynamicsMechanismExplorer {
    private final RigidBodyBasics rootbody;

    public InverseDynamicsMechanismExplorer(RigidBodyBasics rootbody) {
        this.rootbody = rootbody;
    }

    public void getRobotInformationAsStringBuffer(StringBuffer buffer) {
        this.printLinkInformation(this.rootbody, buffer);
    }

    private void printJointInformation(JointBasics joint, StringBuffer buffer) {
        String jointName = joint.getName();
        buffer.append("Joint name = " + jointName + "\n");
        JointBasics parentJoint = joint.getPredecessor().getParentJoint();
        if (parentJoint == null) {
            buffer.append("Root joint\n");
        } else {
            Vector3D jointOffset = new Vector3D();
            MovingReferenceFrame frameBeforeJoint = joint.getFrameBeforeJoint();
            MovingReferenceFrame frameAfterParentJoint = parentJoint.getFrameAfterJoint();
            RigidBodyTransform comOffsetTransform = frameBeforeJoint.getTransformToDesiredFrame((ReferenceFrame)frameAfterParentJoint);
            jointOffset.set((Tuple3DReadOnly)comOffsetTransform.getTranslation());
            buffer.append("Joint offset = " + jointOffset + "\n");
        }
        if (joint instanceof RevoluteJoint) {
            this.printPinJointInformation((RevoluteJoint)joint, buffer);
        } else if (joint instanceof PrismaticJoint) {
            this.printSliderJointInformation((PrismaticJoint)joint, buffer);
        } else if (joint instanceof SixDoFJoint) {
            this.printFloatingJointInformation((SixDoFJoint)joint, buffer);
        } else {
            throw new RuntimeException("Only Pin and Slider implemented right now");
        }
        RigidBodyBasics linkRigidBody = joint.getSuccessor();
        this.printLinkInformation(linkRigidBody, buffer);
    }

    private void printPinJointInformation(RevoluteJoint revoluteJoint, StringBuffer buffer) {
        Twist twist = new Twist();
        twist.setIncludingFrame((SpatialMotionReadOnly)revoluteJoint.getUnitJointTwist());
        FixedFrameVector3DBasics jointAxis = twist.getAngularPart();
        buffer.append("Joint axis = " + (Vector3DReadOnly)jointAxis + "\n");
        buffer.append("Joint is a Pin Joint.\n");
    }

    private void printSliderJointInformation(PrismaticJoint prismaticJoint, StringBuffer buffer) {
        Twist twist = new Twist();
        twist.setIncludingFrame((SpatialMotionReadOnly)prismaticJoint.getUnitJointTwist());
        FixedFrameVector3DBasics jointAxis = twist.getLinearPart();
        buffer.append("Joint axis = " + (Vector3DReadOnly)jointAxis + "\n");
        buffer.append("Joint is a Slider Joint.\n");
    }

    private void printFloatingJointInformation(SixDoFJoint floatingJoint, StringBuffer buffer) {
        buffer.append("Joint is a Floating Joint.\n");
    }

    private void printLinkInformation(RigidBodyBasics link, StringBuffer buffer) {
        SpatialInertiaBasics inertia = link.getInertia();
        JointBasics parentJoint = link.getParentJoint();
        if (inertia != null) {
            double mass = inertia.getMass();
            Vector3D comOffset = new Vector3D();
            RigidBodyTransform comOffsetTransform = link.getBodyFixedFrame().getTransformToDesiredFrame((ReferenceFrame)parentJoint.getFrameAfterJoint());
            comOffset.set((Tuple3DReadOnly)comOffsetTransform.getTranslation());
            Matrix3DBasics momentOfInertia = inertia.getMomentOfInertia();
            buffer.append("Mass = " + mass + "\n");
            buffer.append("comOffset = " + comOffset + "\n");
            buffer.append("momentOfInertia = \n" + momentOfInertia + "\n");
        }
        List childrenJoints = link.getChildrenJoints();
        for (JointBasics childJoint : childrenJoints) {
            String parentJointName = parentJoint != null ? parentJoint.getName() : "root joint";
            buffer.append("Found Child Joint of " + parentJointName + ".\n");
            this.printJointInformation(childJoint, buffer);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.getRobotInformationAsStringBuffer(buffer);
        return buffer.toString();
    }
}

