/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.screwTheory.WholeBodyAngularVelocityCalculator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class AngularExcursionCalculator {
    private final WholeBodyAngularVelocityCalculator angularVelocityCalculator;
    private final Vector3D axisAngle = new Vector3D();
    private final Quaternion rotation = new Quaternion();
    private final YoFrameQuaternion angularExcursion;
    private final YoFrameYawPitchRoll angularExcursionRPY;
    private final YoFrameVector3D wholeBodyAngularVelocity;
    private final YoFrameVector3D wholeBodyAngularMomentum;
    private final YoBoolean zeroAngularExcursionFlag;
    private final double dt;
    private final Vector3D tempVector = new Vector3D();
    private final YoFramePose3D comPose;
    private final ReferenceFrame centerOfMassFrame;

    public AngularExcursionCalculator(ReferenceFrame centerOfMassFrame, RigidBodyBasics rootBody, double dt, YoRegistry registry, YoGraphicsListRegistry graphicsListRegistry) {
        this.dt = dt;
        this.centerOfMassFrame = centerOfMassFrame;
        this.angularVelocityCalculator = new WholeBodyAngularVelocityCalculator(centerOfMassFrame, graphicsListRegistry, rootBody.subtreeArray());
        this.zeroAngularExcursionFlag = new YoBoolean("zeroAngularExcursionFlag", registry);
        this.angularExcursion = new YoFrameQuaternion("angularExcursion", centerOfMassFrame, registry);
        this.angularExcursionRPY = new YoFrameYawPitchRoll("angularExcursion", centerOfMassFrame, registry);
        this.wholeBodyAngularVelocity = new YoFrameVector3D("wholeBodyAngularVelocity", centerOfMassFrame, registry);
        this.wholeBodyAngularMomentum = new YoFrameVector3D("wholeBodyAngularMomentum", centerOfMassFrame, registry);
        this.comPose = new YoFramePose3D("comPose", ReferenceFrame.getWorldFrame(), registry);
        if (graphicsListRegistry != null) {
            YoGraphicCoordinateSystem comCoordinate = new YoGraphicCoordinateSystem("comCoordinate", this.comPose, 1.0);
            graphicsListRegistry.registerYoGraphic("comFrame", (YoGraphic)comCoordinate);
        }
    }

    public void setToZero() {
        this.angularExcursion.setToZero();
    }

    public void compute() {
        this.comPose.setFromReferenceFrame(this.centerOfMassFrame);
        this.angularVelocityCalculator.compute();
        if (this.zeroAngularExcursionFlag.getBooleanValue()) {
            this.setToZero();
            this.zeroAngularExcursionFlag.set(false);
        }
        this.wholeBodyAngularVelocity.set((FrameTuple3DReadOnly)this.angularVelocityCalculator.getWholeBodyAngularVelocity());
        this.wholeBodyAngularMomentum.set((FrameTuple3DReadOnly)this.angularVelocityCalculator.getAngularMomentum());
        this.axisAngle.setAndScale(this.dt, (Tuple3DReadOnly)this.wholeBodyAngularVelocity);
        this.angularExcursion.inverseTransform((Tuple3DBasics)this.axisAngle);
        this.rotation.setRotationVector((Vector3DReadOnly)this.axisAngle);
        this.angularExcursion.append((Orientation3DReadOnly)this.rotation);
        this.angularExcursionRPY.set((FrameOrientation3DReadOnly)this.angularExcursion);
    }

    public FrameVector3DReadOnly getLinearMomentum() {
        return this.angularVelocityCalculator.getLinearMomentum();
    }

    public FrameVector3DReadOnly getAngularMomentum() {
        return this.angularVelocityCalculator.getAngularMomentum();
    }
}

