/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import java.util.function.Consumer;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.EuclidCoreMissingTools;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;

public class MutableReferenceFrame {
    private final RigidBodyTransform transformToParent = new RigidBodyTransform();
    private final String frameName;
    private ReferenceFrame referenceFrame;

    public MutableReferenceFrame() {
        this(ReferenceFrame.getWorldFrame());
    }

    public MutableReferenceFrame(ReferenceFrame parentFrame) {
        this(ReferenceFrameMissingTools.computeFrameName(), parentFrame);
    }

    public MutableReferenceFrame(String frameName, ReferenceFrame parentFrame) {
        this.frameName = frameName;
        this.referenceFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)frameName, (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)this.transformToParent);
    }

    public void update(Consumer<RigidBodyTransform> transformToParentConsumer) {
        transformToParentConsumer.accept(this.transformToParent);
        this.referenceFrame.update();
    }

    public void setParentFrame(ReferenceFrame parentFrame) {
        if (EuclidCoreMissingTools.hasBeenRemoved(parentFrame)) {
            LogTools.error((String)"Parent frame has been removed! {}", (Object)parentFrame.getName());
        }
        if (parentFrame != this.referenceFrame.getParent()) {
            this.referenceFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)this.frameName, (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)this.transformToParent);
        }
    }

    public void changeFrame(ReferenceFrame parentFrame) {
        RigidBodyTransform newTransformToParent = new RigidBodyTransform();
        this.referenceFrame.getTransformToDesiredFrame(newTransformToParent, parentFrame);
        this.transformToParent.set(newTransformToParent);
        this.referenceFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)this.frameName, (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)this.transformToParent);
    }

    public RigidBodyTransform getTransformToParent() {
        return this.transformToParent;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }
}

