/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.robotics.referenceFrames.ReferenceFrameLibrary;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;

public class DetachableReferenceFrame {
    private final transient ReferenceFrameLibrary referenceFrameLibrary;
    private final RigidBodyTransformReadOnly transformToParent;
    private ReferenceFrame referenceFrame;

    public DetachableReferenceFrame(ReferenceFrameLibrary referenceFrameLibrary, RigidBodyTransformReadOnly transformToParent) {
        this.transformToParent = transformToParent;
        this.referenceFrameLibrary = referenceFrameLibrary;
    }

    public void update(String parentFrameName) {
        boolean frameNeedsRecreating;
        ReferenceFrame parentFrameInWorld = this.referenceFrameLibrary.findFrameByName(parentFrameName);
        boolean shouldBeChildOfWorld = parentFrameInWorld != null;
        boolean bl = frameNeedsRecreating = this.referenceFrame == null;
        if (this.referenceFrame != null) {
            frameNeedsRecreating |= shouldBeChildOfWorld != this.isChildOfWorld();
            frameNeedsRecreating |= this.referenceFrame.getParent() != parentFrameInWorld;
        }
        if (frameNeedsRecreating) {
            ReferenceFrame parentFrame = shouldBeChildOfWorld ? parentFrameInWorld : ReferenceFrameTools.constructARootFrame((String)parentFrameName);
            this.referenceFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent(parentFrame, this.transformToParent);
        } else {
            this.referenceFrame.update();
        }
    }

    public void changeFrame(String parentFrameName, RigidBodyTransform transformToParent) {
        if (this.referenceFrame != null) {
            ReferenceFrame parentFrame = this.referenceFrameLibrary.findFrameByName(parentFrameName);
            RigidBodyTransform newTransformToParent = new RigidBodyTransform();
            if (parentFrame != null && this.referenceFrame.getRootFrame() == parentFrame.getRootFrame()) {
                this.referenceFrame.getTransformToDesiredFrame(newTransformToParent, parentFrame);
                transformToParent.set(newTransformToParent);
            } else {
                parentFrame = ReferenceFrameTools.constructARootFrame((String)parentFrameName);
            }
            this.referenceFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent(parentFrame, (RigidBodyTransformReadOnly)transformToParent);
        }
    }

    public boolean isChildOfWorld() {
        return this.referenceFrame.getRootFrame() == ReferenceFrame.getWorldFrame();
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }
}

