/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.mecano.algorithms.MultiBodyResponseCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.tools.JointStateType;

public interface JointStateProvider {
    public JointStateType getState();

    public DMatrixRMaj getJointState(JointReadOnly var1);

    default public double getJointState(OneDoFJointReadOnly joint) {
        DMatrixRMaj state = this.getJointState((JointReadOnly)joint);
        if (state == null) {
            return Double.NaN;
        }
        return state.get(0);
    }

    public static JointStateProvider toJointTwistProvider(final MultiBodyResponseCalculator calculator) {
        return new JointStateProvider(){

            @Override
            public JointStateType getState() {
                return JointStateType.VELOCITY;
            }

            @Override
            public DMatrixRMaj getJointState(JointReadOnly joint) {
                return calculator.getJointTwistChange(joint);
            }
        };
    }
}

