/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.optimization.constrainedOptimization;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.optimization.CostFunction;
import us.ihmc.robotics.optimization.Optimizer;
import us.ihmc.robotics.optimization.constrainedOptimization.AugmentedLagrangeOptimizationProblem;

public class AugmentedLagrangeOptimizer {
    private final AugmentedLagrangeOptimizationProblem problem;
    private final CostFunction lagrangeCostFunction;
    private final Optimizer optimizer;
    private double optimumCost = Double.POSITIVE_INFINITY;
    private DMatrixD1 optimumParameters = null;
    private boolean verbose = true;

    public AugmentedLagrangeOptimizer(Optimizer optimizer, AugmentedLagrangeOptimizationProblem problem) {
        this.problem = problem;
        this.lagrangeCostFunction = problem.getAugmentedCostFunction();
        this.optimizer = optimizer;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public DMatrixD1 optimize(int numLagrangeIterations, DMatrixD1 seedParameters) {
        DMatrixRMaj initial = new DMatrixRMaj((DMatrix)seedParameters);
        for (int iteration = 0; iteration < numLagrangeIterations; ++iteration) {
            this.optimizer.setCostFunction(this.lagrangeCostFunction);
            this.optimumParameters = this.optimizer.optimize((DMatrixD1)initial);
            this.optimumCost = this.optimizer.getOptimumCost();
            this.problem.updateLagrangeMultipliers(this.optimumParameters);
            initial.set(this.optimumParameters);
            if (!this.verbose) continue;
            LogTools.info((String)"");
            System.out.println("===== Lagrange Iteration: " + iteration + " ==========");
            this.problem.printResults(this.optimumParameters);
        }
        return this.optimumParameters;
    }

    public double getOptimumCost() {
        return this.optimumCost;
    }
}

