/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public interface SO3WaypointReadOnly
extends EuclidGeometry {
    public QuaternionReadOnly getOrientation();

    public Vector3DReadOnly getAngularVelocity();

    default public boolean containsNaN() {
        return this.getOrientation().containsNaN() || this.getAngularVelocity().containsNaN();
    }

    default public double getOrientationX() {
        return this.getOrientation().getX();
    }

    default public double getOrientationY() {
        return this.getOrientation().getY();
    }

    default public double getOrientationZ() {
        return this.getOrientation().getZ();
    }

    default public double getOrientationS() {
        return this.getOrientation().getS();
    }

    default public double getAngularVelocityX() {
        return this.getAngularVelocity().getX();
    }

    default public double getAngularVelocityY() {
        return this.getAngularVelocity().getY();
    }

    default public double getAngularVelocityZ() {
        return this.getAngularVelocity().getZ();
    }

    default public double orientationDistance(SO3WaypointReadOnly other) {
        return this.getOrientation().distance((Orientation3DReadOnly)other.getOrientation());
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SO3WaypointReadOnly)) {
            return false;
        }
        SO3WaypointReadOnly other = (SO3WaypointReadOnly)geometry;
        if (!this.getOrientation().equals((EuclidGeometry)other.getOrientation())) {
            return false;
        }
        return this.getAngularVelocity().equals((EuclidGeometry)other.getAngularVelocity());
    }

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SO3WaypointReadOnly)) {
            return false;
        }
        SO3WaypointReadOnly other = (SO3WaypointReadOnly)geometry;
        if (!this.getOrientation().epsilonEquals((EuclidGeometry)other.getOrientation(), epsilon)) {
            return false;
        }
        return this.getAngularVelocity().epsilonEquals((EuclidGeometry)other.getAngularVelocity(), epsilon);
    }

    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SO3WaypointReadOnly)) {
            return false;
        }
        SO3WaypointReadOnly other = (SO3WaypointReadOnly)geometry;
        if (!this.getOrientation().geometricallyEquals((EuclidGeometry)other.getOrientation(), epsilon)) {
            return false;
        }
        return this.getAngularVelocity().geometricallyEquals((EuclidGeometry)other.getAngularVelocity(), epsilon);
    }

    default public String toString(String format) {
        return String.format("SO3 waypoint: [orientation=%s, angular velocity=%s]", EuclidCoreIOTools.getTuple4DString((String)format, (Tuple4DReadOnly)this.getOrientation()), EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)this.getAngularVelocity()));
    }
}

