/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointReadOnly;
import us.ihmc.yoVariables.euclid.YoPoint3D;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoEuclideanWaypoint
implements EuclideanWaypointBasics {
    private final YoPoint3D position;
    private final YoVector3D linearVelocity;

    public YoEuclideanWaypoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.position = new YoPoint3D(namePrefix + "Position", nameSuffix, registry);
        this.linearVelocity = new YoVector3D(namePrefix + "LinearVelocity", nameSuffix, registry);
    }

    public YoDouble getYoX() {
        return this.position.getYoX();
    }

    public YoDouble getYoY() {
        return this.position.getYoY();
    }

    public YoDouble getYoZ() {
        return this.position.getYoZ();
    }

    @Override
    public Point3DBasics getPosition() {
        return this.position;
    }

    @Override
    public Vector3DBasics getLinearVelocity() {
        return this.linearVelocity;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getPosition(), (Object)this.getLinearVelocity());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof EuclideanWaypointReadOnly) {
            return this.equals((EuclideanWaypointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

