/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointReadOnly;

public class FrameEuclideanWaypoint
implements FrameEuclideanWaypointBasics {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint3DBasics position = EuclidFrameFactories.newFixedFramePoint3DBasics((ReferenceFrameHolder)this);
    private final FixedFrameVector3DBasics linearVelocity = EuclidFrameFactories.newFixedFrameVector3DBasics((ReferenceFrameHolder)this);

    public FrameEuclideanWaypoint() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameEuclideanWaypoint(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameEuclideanWaypoint(FramePoint3DReadOnly position, FrameVector3DReadOnly linearVelocity) {
        this.setIncludingFrame(position, linearVelocity);
    }

    public FrameEuclideanWaypoint(ReferenceFrame referenceFrame, EuclideanWaypointReadOnly waypoint) {
        this.setIncludingFrame(referenceFrame, waypoint);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public FixedFramePoint3DBasics getPosition() {
        return this.position;
    }

    @Override
    public FixedFrameVector3DBasics getLinearVelocity() {
        return this.linearVelocity;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getPosition(), (Object)this.getLinearVelocity());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FrameEuclideanWaypointReadOnly) {
            return this.equals((FrameEuclideanWaypointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

