/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.core;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialBasics;

public class PolynomialTools {
    public static final boolean DEBUG = false;

    public static void setXPowers(double[] xPowers, double x) {
        xPowers[0] = 1.0;
        for (int i = 1; i < xPowers.length; ++i) {
            xPowers[i] = xPowers[i - 1] * x;
        }
    }

    public static int getDerivativeCoefficient(int order, int exponent) {
        int coeff = 1;
        for (int i = exponent; i > exponent - order; --i) {
            coeff *= i;
        }
        return coeff;
    }

    public static void getXPowersDerivativeVector(double[] xPowersToPack, DMatrixRMaj xPowersDerivativeVectorToPack, int order, double x, int numberOfCoefficients) {
        PolynomialTools.setXPowers(xPowersToPack, x);
        xPowersDerivativeVectorToPack.zero();
        int derivativeCoefficient = 0;
        for (int i = order; i < numberOfCoefficients; ++i) {
            derivativeCoefficient = PolynomialTools.getDerivativeCoefficient(order, i);
            xPowersDerivativeVectorToPack.set(i, (double)derivativeCoefficient * xPowersToPack[i - order]);
        }
    }

    public static ComplexNumber evaluate(PolynomialBasics polynomialBasics, ComplexNumber input) {
        ComplexNumber x_n = new ComplexNumber(1.0, 0.0);
        ComplexNumber ret = new ComplexNumber(0.0, 0.0);
        for (int i = 0; i < polynomialBasics.getNumberOfCoefficients(); ++i) {
            double coefficient = polynomialBasics.getCoefficient(i);
            ret = ret.plus(x_n.times(coefficient));
            x_n = x_n.times(input);
        }
        return ret;
    }
}

