/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.math.trajectories.BlendedPoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.BlendedWaypointPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FixedFrameEuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.yoVariables.YoGraphicTrajectory3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BlendedPositionTrajectoryGeneratorVisualizer {
    private static final boolean useBagOfBalls = true;
    private static final int numberOfBalls = 25;
    private final DoubleProvider swingDuration;
    private final BlendedWaypointPositionTrajectoryGenerator trajectory;
    private final BagOfBalls trajectoryViz;
    private final BagOfBalls waypointViz;
    private final YoGraphicTrajectory3D splineViz;

    public BlendedPositionTrajectoryGeneratorVisualizer(String namePrefix, BlendedPoseTrajectoryGenerator trajectory, DoubleProvider swingDuration, YoRegistry registry, YoGraphicsListRegistry graphicsListRegistry) {
        this(namePrefix, trajectory.getPositionTrajectoryGenerator(), swingDuration, registry, graphicsListRegistry);
    }

    public BlendedPositionTrajectoryGeneratorVisualizer(String namePrefix, BlendedWaypointPositionTrajectoryGenerator trajectory, DoubleProvider swingDuration, YoRegistry registry, YoGraphicsListRegistry graphicsListRegistry) {
        this.trajectory = trajectory;
        this.swingDuration = swingDuration;
        this.trajectoryViz = new BagOfBalls(25, 0.01, namePrefix + "BlendTrajectory", registry, graphicsListRegistry);
        this.waypointViz = new BagOfBalls(25, 0.025, namePrefix + "BlendWaypoints", YoAppearance.Green(), registry, graphicsListRegistry);
        this.splineViz = null;
    }

    public void visualize() {
        this.trajectoryViz.reset();
        this.waypointViz.reset();
        MultipleWaypointsPositionTrajectoryGenerator blendTrajecotry = this.trajectory.getBlendTrajectory();
        for (int i = 0; i < blendTrajecotry.getCurrentNumberOfWaypoints(); ++i) {
            FixedFrameEuclideanTrajectoryPointBasics blendWaypont = blendTrajecotry.getWaypoint(i);
            this.trajectory.compute(blendWaypont.getTime());
            this.waypointViz.setBall(this.trajectory.getPosition());
        }
        double dt = this.swingDuration.getValue() / 25.0;
        double time = 0.0;
        for (int i = 0; i < 25; ++i) {
            this.trajectory.compute(time);
            this.trajectoryViz.setBall(this.trajectory.getPosition());
            time += dt;
        }
    }

    public void showVisualization() {
    }

    public void hideVisualization() {
        this.trajectoryViz.reset();
        this.trajectoryViz.hideAll();
        this.waypointViz.reset();
        this.waypointViz.hideAll();
    }
}

