/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.robotics.math.functionGenerator.BaseFunctionGenerator;

public class TriangleWaveFunctionGenerator
extends BaseFunctionGenerator {
    @Override
    protected double computeValue() {
        double frequency = this.getFrequency();
        double offset = this.getOffset();
        if (frequency == 0.0) {
            return offset;
        }
        double angle = this.getAngle();
        double amplitude = this.getAmplitude();
        if (angle <= Math.PI) {
            double alpha = angle / Math.PI;
            return offset + EuclidCoreTools.interpolate((double)(-amplitude), (double)amplitude, (double)alpha);
        }
        double alpha = (angle - Math.PI) / Math.PI;
        return offset + EuclidCoreTools.interpolate((double)amplitude, (double)(-amplitude), (double)alpha);
    }

    @Override
    protected double computeValueDot() {
        double frequency = this.getFrequency();
        if (frequency == 0.0) {
            return 0.0;
        }
        double angle = this.getAngle();
        double amplitude = this.getAmplitude();
        return (angle <= Math.PI ? 1.0 : -1.0) * (4.0 * amplitude * frequency);
    }

    @Override
    protected double computeValueDDot() {
        return 0.0;
    }
}

