/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import us.ihmc.robotics.math.functionGenerator.BaseFunctionGenerator;

public class SineWaveFunctionGenerator
extends BaseFunctionGenerator {
    @Override
    protected double computeValue() {
        double offset = this.getOffset();
        double amplitude = this.getAmplitude();
        double angle = this.getAngle();
        double phase = this.getPhase();
        return offset + amplitude * Math.sin(angle + phase);
    }

    @Override
    protected double computeValueDot() {
        double angleDot = this.getAngleDot();
        double amplitude = this.getAmplitude();
        double angle = this.getAngle();
        double phase = this.getPhase();
        return angleDot * amplitude * Math.cos(angle + phase);
    }

    @Override
    protected double computeValueDDot() {
        double angleDot = this.getAngleDot();
        double amplitude = this.getAmplitude();
        double angle = this.getAngle();
        double phase = this.getPhase();
        return -angleDot * angleDot * amplitude * Math.sin(angle + phase);
    }
}

